/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: Form21.c,v $ $Revision: 1.4.2.2 $ $Date: 1992/04/06 15:07:18 $"
#endif
#endif
/*
 *  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */

#include <testlib.h>
#define MAXTEXT 4

Widget DialogShell;
Widget ScrollWin;
Widget Form;
Widget Text[MAXTEXT];

static void            die();
static void            RunTest();
static void            CreateForm();
static void            DestroyForm();
static void            PrintValues();

void  main(argc, argv)
int     argc;
char    **argv;
{
  register int  n;
  Arg args[MAX_ARGS];
  
  CommonTestInit(argc, argv);
    
  n = 0;
  XtSetArg (args[n], XmNwidth,  50);                               n++;
  XtSetArg (args[n], XmNheight, 25);                               n++;
  XtSetValues(Shell1, args, n);
    
  XtRealizeWidget(Shell1);    

  RunTest(Shell1);

  XtAppMainLoop(app_context);
}

static void RunTest(Shell)
Widget Shell;
{
  register int  i;
  register int  n;
  Arg args[MAX_ARGS];

  CreateForm(Shell);
  CommonPause();
    
  for (i = 0; i < MAXTEXT; i++) XtUnmapWidget(Text[i]);
  CommonPause();
    
  for (i = 0; i < MAXTEXT; i++) XtMapWidget(Text[i]);
  CommonPause();
    
  DestroyForm();
  CommonPause();

  CreateForm(Shell);
  CommonPause();

  XtUnmanageChild(Text[0]);
  CommonPause();

  XtUnmanageChild(Text[1]);
  CommonPause();
    
  XtUnmanageChild(Text[2]);
  CommonPause();

  XtUnmanageChild(Text[3]);
  CommonPause();
    
  for (i = 0; i < MAXTEXT; i++) XtManageChild(Text[i]);
  CommonPause();
    
  DestroyForm();
}

static void PrintValues(w)
Widget w;
{
  unsigned int n;
  Arg          args[MAX_ARGS];
  Position     x, y;
  Dimension    width, height;
  
  n = 0;
  XtSetArg(args[n], XmNx,      &x);            n++;
  XtSetArg(args[n], XmNy,      &y);            n++;
  XtSetArg(args[n], XmNwidth,  &width);        n++;
  XtSetArg(args[n], XmNheight, &height);       n++;
  XtGetValues(w, args, n);

  printf("\n\tX: %d Y: %d W: %d H: %d\n", x, y, width, height);

  if ( XtIsManaged(w) ) 
    printf("The Widget is Managed.\n");
  else
    printf("The Widget is NOT Managed.\n");
}

static void CreateForm(Shell)
Widget Shell;
{
  register int  i;
  register int  n;
  Arg args[MAX_ARGS];

  n = 0;
  XtSetArg(args[n], XmNallowShellResize, True);                  n++;
  DialogShell = XmCreateDialogShell(Shell, "Form21", args, n);

  n = 0;
  XtSetArg(args[n], XmNscrollingPolicy, XmAUTOMATIC);            n++;
  XtSetArg(args[n], XmNscrollBarDisplayPolicy, XmSTATIC);        n++;
  ScrollWin = XmCreateScrolledWindow(DialogShell, "ScrollWin", args, n);
  
  n = 0;
  XtSetArg(args[n], XmNresizePolicy, XmRESIZE_GROW);             n++;
  Form = XmCreateForm(ScrollWin, "Form", args, n);
  
  for (i = 0; i < MAXTEXT; i++) {
    n = 0;
    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT);                 n++;
    XtSetArg(args[n], XmNcolumns, 40);                                 n++;
    XtSetArg(args[n], XmNrows,    40);                                 n++;
    switch (i) {
    case 0:
      XtSetArg(args[n], XmNvalue, "This is Text0");                    n++;
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);             n++;
      XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);              n++;
      break;
    case 1:
      n = 0;
      XtSetArg(args[n], XmNvalue, "This is Text1");                     n++;
      XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);             n++;
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);            n++;
      XtSetArg(args[n], XmNleftWidget, Text[0]);                        n++;
      XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);               n++;
      XtSetArg(args[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n], XmNbottomWidget, Text[0]);                      n++;
      break;
    case 2:
      n = 0;
      XtSetArg(args[n], XmNvalue, "This is Text2");                    n++;
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);             n++;
      XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);            n++;
      XtSetArg(args[n], XmNtopWidget, Text[0]);                        n++;
      XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);           n++;
      break;
    case 3:
      n = 0;
      XtSetArg(args[n], XmNvalue, "This is Text3");                     n++;
      XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);             n++;
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET);            n++;
      XtSetArg(args[n], XmNleftWidget, Text[2]);                        n++;
      XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);             n++;
      XtSetArg(args[n], XmNtopWidget, Text[1]);                         n++;
      XtSetArg(args[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
      XtSetArg(args[n], XmNbottomWidget, Text[2]);                      n++;
      break;
    }
    Text[i] = XmCreateText(Form, "Text", args, n);
  }

  XtManageChildren(Text, MAXTEXT);
  XtManageChild(Form);
  XtManageChild(ScrollWin);
}

static void DestroyForm()
{
  XtDestroyWidget(DialogShell);
}
