/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: convenience.c,v $ $Revision: 1.4.2.2 $ $Date: 1992/04/08 15:54:21 $"
#endif
#endif

#include <MrmTest.h>

/*
 * Structures declared in main.c file
 */

extern MrmHierarchy	s_MrmHierarchy;
extern Widget		widgetmain;
extern MrmType		class;

/*
 * Local declarations
 */

void	nyi_proc();

/*
 * Error handling
 */

void error_proc(error_string)
     String	error_string;
{
    fprintf(stdout,"%s\n", error_string);
    fflush(stdout);
}

/*
 * Exit
 */

void exit_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{
    fprintf(stdout,"Exiting\n");
    fflush(stdout);
    MrmCloseHierarchy(s_MrmHierarchy);
    exit(0);
}

/*
 * Help
 */

void help_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{
    nyi_proc(w, "help", NULL);
}

/*
 * Not Yet Implemented - fetches InformationDialog widget
 */

void nyi_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{

    Arg		args[2];
    int		nargs;
    char	buf[80];
    XmString	message;
    Widget	nyi = NULL;
    
    sprintf(buf, "The %s utility is not yet implemented", tag);
    message = XmStringCreateLtoR(buf, XmSTRING_DEFAULT_CHARSET);

    nargs = 0;
    XtSetArg(args[nargs], XmNmessageString, message); nargs++;

    if(MrmFetchWidgetOverride(s_MrmHierarchy,	/* id of uid hierarchy	   */
			      "nyi",		/* uil name of widget	   */
			      widgetmain,	/* parent of widget	   */
			      NULL,		/* override name	   */
			      args,		/* override arg list	   */
			      nargs,		/* number of override args */
			      &nyi,		/* ptr to widget id	   */
			      &class)		/* ptr to widget class	   */
       != MrmSUCCESS)
    {
	error_proc("Can't fetch nyi widget\n");
    }
    else
    {
	XtManageChild(nyi);
    }
}
