/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: FetchSV.c,v $ $Revision: 1.5.2.2 $ $Date: 1992/04/08 15:52:46 $"
#endif
#endif

#include <MrmTest.h> 

/* 
 * Data for summary
 */

#define NUM_TESTS		6
#define TEST_DESCRIP_LENGTH	64

struct TestInfo FetchSetValueInfo[NUM_TESTS] = 
{
    {"Fetch undefined background color - Salmon                       ",
				MrmNOT_FOUND,	NULL},
    {"Fetch one valid value, shadow thickness for button2             ",
				MrmSUCCESS,	NULL},
    {"Fetch value from bad hierarchy, shadow thickness                ",
				MrmBAD_HIERARCHY,	NULL},
	{"Fetch two valid values, topshadow=blue, bottomshadow=black      ",
				MrmSUCCESS,	NULL},
	{"Fetch two values, one found, topshadow=white, bottomshadow=Coral",
				MrmPARTIAL_SUCCESS,	NULL},
	{"Fetch a value not valid for widget, selectColor for pushbutton  ",
				MrmSUCCESS,	NULL},
};
int		FSV_info_cnt = 0;

/*
 * External declarations
 */

extern MrmHierarchy	s_MrmHierarchy;
extern MrmType		class;

extern Widget		toplevel,
					widgetmain;

extern String		summary();

/*
 * Local declarations
 */

#define VALID_TEST1	1
#define VALID_TEST2	2
#define FINISH		3

Widget		test_top,
			test_box,
			buttons[3],
			badwidget1;

int		iteration = 1;

void continue_proc(w, tag, reason)
     Widget		w;
     int		*tag;
     unsigned long	*reason;
{ 	

    String	msg_valid_tst1 = "There should now be two buttons in the second window.\nThe buttons' labels should read\n    TEST                   TEST\n      1         and          1 \n    BTN1                   BTN2.\nThe colors should be: background - yellow, foreground - red.\nThe righthand button should have a wider shadow (6 pixels) around it.\n\nAlso, note that there should be two Mrm Toolkit Warning\nmessages on stdout/stderr about an MrmBAD_HIERARCHY and\nMrm_NOT_FOUND.\n\nPress the continue button to continue the test.";

    String	msg_valid_tst2 = "There should now be two additional buttons in the window.\nThe new buttons' labels should read\n    BTN1                   BTN2\n    TEST        and        TEST\n      2                      2 .\nThe colors for the left button shadow should be:\ntopshadow - blue,  bottomshadow - black.\nThe colors for the right button shadow should be:\ntopshadow - white,  bottomshadow - default, same as the button above it.\n\nNote that there should be another Mrm Toolkit Warning\nmessage on stdout/stderr about an MrmNOT_FOUND.\n\nPress the continue button to continue the test.";

    Arg		args[4];
    int		nargs;

    XmString	message;

    String	summary_msg;
	Pixel	fg, bg;
	int		widgetwidth = 0;

    if(iteration == VALID_TEST1)
    {
	iteration++;

/*
 * Create top level shell widget as parent for test_box widget
 */

	nargs = 0;
	XtSetArg(args[nargs], XtNallowShellResize, TRUE); nargs++;

	test_top =
	XtAppCreateShell("test_top",			/* application class */
			 "TEST_TOP",			/* application name  */
			 topLevelShellWidgetClass,	/* widget class	     */
			 XtDisplay(widgetmain),		/* display	     */
			 args, nargs);			/* arguments	     */

/*
 * Fetch valid test_box widget
 */
	test_box = NULL;
	MrmFetchWidget(
				s_MrmHierarchy,
				"test_box",
				test_top,
				&test_box,
				&class);
/*
 * Fetch undefined background color - Salmon
 */
	nargs = 0;
	XtSetArg(args[nargs], XmNbackground, "Salmon"); nargs++;
	FetchSetValueInfo[FSV_info_cnt].actual_return = MrmFetchSetValues(
						s_MrmHierarchy,
						buttons[0],
						args,
						nargs);
	FSV_info_cnt++;

/*
 * Fetch one valid value, shadow thickness for button2
 */
	buttons[0] = NULL;
	MrmFetchWidget(
				s_MrmHierarchy,
				"button2",
				test_box,
				&buttons[0],
				&class);
	nargs = 0;
	XtSetArg(args[nargs], XmNshadowThickness, "wideshadow"); nargs++;
	FetchSetValueInfo[FSV_info_cnt].actual_return = MrmFetchSetValues(
						s_MrmHierarchy,
						buttons[0],
						args,
						nargs);
	FSV_info_cnt++;


	XtManageChild(test_box);
	XtManageChild(buttons[0]);
	XtRealizeWidget(test_top);

/*
 * Fetch value from bad hierarchy, shadow thickness
 */
	nargs = 0;
	XtSetArg(args[nargs], XmNshadowThickness, "wideshadow"); nargs++;
	FetchSetValueInfo[FSV_info_cnt].actual_return = MrmFetchSetValues(
						NULL,
						buttons[0],
						args,
						nargs);
	FSV_info_cnt++;

/*
 * Replace instruction message with "valid test 1" message
 */

	message = XmStringCreateLtoR(msg_valid_tst1, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
	XmStringFree(message);
			       
    }
    else if(iteration == VALID_TEST2)
    {
	iteration++;

/*
 * Fetch second two button widgets
 */

/* 
 * Fetch two valid values, topshadow=blue, bottomshadow=black
 */
	buttons[1] = NULL;
	MrmFetchWidget(
				s_MrmHierarchy,
				"button3",
				test_box,
				&buttons[1],
				&class);
	nargs = 0;
	XtSetArg(args[nargs], XmNtopShadowColor, "blue"); nargs++;
	XtSetArg(args[nargs], XmNbottomShadowColor, "black"); nargs++;
	XtSetArg(args[nargs], XmNshadowThickness, "wideshadow"); nargs++;
	FetchSetValueInfo[FSV_info_cnt].actual_return = MrmFetchSetValues(
						s_MrmHierarchy,
						buttons[1],
						args,
						nargs);
	FSV_info_cnt++;


/* 
 * Fetch two values, one found, topshadow=white, bottomshadow=Coral
 */
	buttons[2] = NULL;
	MrmFetchWidget(
				s_MrmHierarchy,
				"button4",
				test_box,
				&buttons[2],
				&class);
	nargs = 0;
	XtSetArg(args[nargs], XmNtopShadowColor, "white"); nargs++;
	XtSetArg(args[nargs], XmNbottomShadowColor, "Coral"); nargs++;
	XtSetArg(args[nargs], XmNshadowThickness, "wideshadow"); nargs++;
	FetchSetValueInfo[FSV_info_cnt].actual_return = MrmFetchSetValues(
						s_MrmHierarchy,
						buttons[2],
						args,
						nargs);
	FSV_info_cnt++;

/* 
 * Fetch a value not valid for widget, selectColor for pushbutton
 */
	nargs = 0;
	XtSetArg(args[nargs], XmNselectColor, "white"); nargs++;
	FetchSetValueInfo[FSV_info_cnt].actual_return = MrmFetchSetValues(
						s_MrmHierarchy,
						buttons[2],
						args,
						nargs);
	FSV_info_cnt++;

/*
 * Manage button widgets
 */

	XtManageChildren(&buttons[1], 2);
	
/*
 * Replace the instruction message with "valid test 2" message
 */

	message = XmStringCreateLtoR(msg_valid_tst2, XmSTRING_DEFAULT_CHARSET);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
	XmStringFree(message);
    }
    else if(iteration == FINISH)
    {
	iteration++;

/*
 * Replace the instruction message with test end message
 */

	summary_msg = summary(NUM_TESTS,
			      TEST_DESCRIP_LENGTH,
			      FetchSetValueInfo);

	fprintf (stdout, summary_msg);

	message = XmStringCreateLtoR(summary_msg, XmSTRING_DEFAULT_CHARSET);
	XtFree(summary_msg);

	nargs = 0;
	XtSetArg(args[nargs], XmNmessageString, message); nargs++;
	XtSetValues(widgetmain, args, nargs);
	XmStringFree(message);
    }
}
