/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
/*   $RCSfile: BrowseP.h,v $ $Revision: 1.4.2.2 $ $Date: 1992/04/08 15:54:54 $ */

/**********************************************************
 * BrowseP.h: Private header file for Browse Widget Class *
 **********************************************************/

#ifndef BROWSEP_H
#define BROWSEP_H

#include <Xm/BulletinBP.h>
#include <Xm/FormP.h>
#include <Xm/XmP.h>

#include "Browse.h"

/*
 * Browse widget part of class record
 */

typedef struct _BrowseClassPart
{
    int	empty;
} BrowseClassPart;

/*
 * Browse widget full class record
 */

typedef struct _BrowseClassRec
{
    CoreClassPart		core_class;
    CompositeClassPart		composite_class;
    ConstraintClassPart		constraint_class;
    XmManagerClassPart		manager_class;
    XmBulletinBoardClassPart	bulletin_board_class;
    XmFormClassPart		form_class;
    BrowseClassPart		browse_class;
} BrowseClassRec;

extern BrowseClassRec	browseClassRec;

/*
 * Browse widget part of instance record
 */

typedef struct _BrowsePart
{
    Pixmap		*images;		/* images to view	  */
    Cardinal		num_images;		/* number of images	  */
    Pixel		image_background;	/* image background color */
    Pixel		image_foreground;	/* image foreground color */
    Pixel		button_background;	/* image background color */
    Pixel		button_foreground;	/* image foreground color */
    XtCallbackList	quit_callback;		/* quit callback proc	  */

    int			current_image;		/* image being displayed  */
    Widget		prev;			/* prev button		  */
    Widget		next;			/* next button		  */
    Widget		help;			/* help button		  */
    Widget		quit;			/* quit button		  */
    Widget		image;			/* image display	  */
} BrowsePart;

/*
 * Browse widget full instance record
 */

typedef struct _BrowseRec
{
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    XmManagerPart	manager;
    XmBulletinBoardPart	bulletin_board;
    XmFormPart		form;
    BrowsePart		browse;
} BrowseRec;

#endif /* BROWSEP_H */
