/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
/*   $RCSfile: ABrowseP.h,v $ $Revision: 1.4 $ $Date: 92/03/13 16:51:24 $ */

/************************************************************
 * ABrowseP.h: Private header file for ABrowse Widget Class *
 ************************************************************/

#ifndef _ABrowseP_h
#define _ABrowseP_h

#include <X11/FormP.h>
#include <X11/ConstrainP.h>

#include "ABrowse.h"

/*
 * ABrowse widget part of class record
 */

typedef struct _ABrowseClassPart
{
    int	empty;
} ABrowseClassPart;

/*
 * ABrowse widget full class record
 */

typedef struct _ABrowseClassRec
{
    CoreClassPart		core_class;
    CompositeClassPart		composite_class;
    ConstraintClassPart		constraint_class;
    FormClassPart		form_class;
    ABrowseClassPart		abrowse_class;
} ABrowseClassRec;

extern ABrowseClassRec	abrowseClassRec;

/*
 * ABrowse widget part of instance record
 */

typedef struct _ABrowsePart
{
    Pixmap		*images;		/* images to view	  */
    Cardinal		num_images;		/* number of images	  */
    Pixel		image_background;	/* image background color */
    Pixel		image_foreground;	/* image foreground color */
    Pixel		button_background;	/* image background color */
    Pixel		button_foreground;	/* image foreground color */
    XtCallbackList	help_callback;		/* help callback proc	  */
    XtCallbackList	quit_callback;		/* quit callback proc	  */

    int			current_image;		/* image being displayed  */
    Widget		prev;			/* prev button		  */
    Widget		next;			/* next button		  */
    Widget		help;			/* help button		  */
    Widget		quit;			/* quit button		  */
    Widget		image;			/* image display	  */
} ABrowsePart;

/*
 * ABrowse widget full instance record
 */

typedef struct _ABrowseRec
{
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    FormPart		form;
    ABrowsePart		abrowse;
} ABrowseRec;

#endif _ABrowseP_h
