/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
/*   $RCSfile: testlib.h,v $ $Revision: 1.5 $ $Date: 92/03/13 18:32:40 $ */


/*  Standard C headers  */

#include <stdio.h>
#include <ctype.h>
#include <sys/signal.h>

/*  Xt headers  */

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

/*  Xm headers  */

#include <Xm/Xm.h>
#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/AtomMgr.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/Command.h>
#include <Xm/CutPaste.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
#include <Xm/MwmUtil.h>
#include <Xm/PanedW.h>
#include <Xm/Protocols.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/SeparatoG.h>
#include <Xm/Separator.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

/* definitions used in all test modules */

#define MAX_ARGS  	100
#define MAX_FILE        256
#define MAX_FONT_LEN    64

/*  Global Variables  */

extern XtAppContext  	app_context;
extern Display  	*display;
extern Window	  	rootWindow;
extern Screen		* screen;
extern Widget   	Shell1;
extern Widget		InstructionBox;

/* Private Functions */

#ifdef _NO_PROTO

extern void 		CommonUsage();
extern void  		CommonGenericCB();
extern void 		CommonGetOptions();
extern void           	CommonPause();
extern void		CommonTestInit();
extern void		CommonDumpHierarchy();
extern char 		*CommonCsToRs();
extern Pixel 		CommonGetColor();
extern XmFontList 	CommonGetFontList();
extern void             CommonExtraResources();

/* stubs for when NOT linking with malloc library */

extern void             MallocInit(); 
extern void             MallocExit();

#else /* _NO_PROTO */

extern void		CommonUsage(char *test_name);
extern void		CommonGenericCB(Widget w, XtPointer client_data,
			        	XtPointer call_data);
extern void		CommonGetOptions(int *argc, char **argv);
extern void		CommonPause();
extern void		CommonTestInit(int argc, char **argv);
extern void 		CommonDumpHierarchy(Widget w, FILE *file);
extern char		*CommonCsToRs(XmString cs);
extern Pixel		CommonGetColor(char *colorstr);
extern XmFontList	CommonGetFontList(char *fontstr);
extern void             CommonExtraResources(Arg args[], Cardinal n);

/* stubs for when NOT linking with malloc library */

extern void             MallocInit(); 
extern void             MallocExit();

#endif /* _NO_PROTO */

/* global variables - command line options */

extern FILE 		*output_file;
extern Boolean 		instructions;
extern char		*UserData;
extern char		*TestName;
extern char             *instruct_file_name;
extern char             *instruct_file_name_orig;
extern int		pause_len;
extern char		test_font[MAX_FONT_LEN];
extern char		default_font[MAX_FONT_LEN];
