/* 
 * (c) Copyright 1989, 1990, 1991, 1992 OPEN SOFTWARE FOUNDATION, INC. 
 * ALL RIGHTS RESERVED 
*/ 
/* 
 * Motif Release 1.2
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$RCSfile: DumpHier.c,v $ $Revision: 1.4 $ $Date: 92/03/13 18:32:10 $"
#endif
#endif

#include "testlib.h"
#include <X11/IntrinsicP.h>

#ifdef _NO_PROTO
void DumpHierarchy();
#else /* _NO_PROTO */
void DumpHierarchy(Widget w, FILE *file, int space);
#endif /* _NO_PROTO */

/*************************************************************************
*									 *
*	Name:		CommonDumpHierarchy()				 *
*									 *
*	Function:	This function will take a widget, and a FILE   	 *
*			pointer to indicate where to write the output.	 *
*			The function will print out all widgets names    *
*			underneath that widget.			 	 *
*									 *
*	Returns:	Nothing						 *
*									 *
*									 *
*************************************************************************/

#ifdef _NO_PROTO
void CommonDumpHierarchy(w, file)
Widget	w;
FILE	*file;
#else /* _NO_PROTO */
void CommonDumpHierarchy(Widget w, FILE *file)
#endif /* _NO_PROTO */

{
	DumpHierarchy(w, file, 0);
}


#ifdef _NO_PROTO
void DumpHierarchy(w, file, space)
Widget	w;
FILE	*file;
int	space;
#else /* _NO_PROTO */
void DumpHierarchy(Widget w, FILE *file, int space)
#endif /* _NO_PROTO */

{
	int		i, j;
	CompositeWidget	cw;

	for (j = 0 ; j < space ; j++)
		fprintf(file, " ");

	if (XtIsComposite(w))
	{
		cw = (CompositeWidget)w;
		fprintf(file, "%s(parent)\n",XtName((Widget)cw));
		for(i = 0; i < cw->composite.num_children; i++)
		{
			DumpHierarchy(cw->composite.children[i], file, 
				      (space + 2));
		}
	}
	else
	{
		fprintf(file, "%s(leaf)\n",XtName(w));
	}

}
