#!/bin/sh
#
# Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
#
# $Header: /project/docsrc/src/sml/RCS/sml_tran.sh,v 1.8 91/11/26 12:07:25 bowe Exp $
#
# shell to call sml_trans.bin
#
#	synopsis: sml_tran [-"type"] [-synt aaa] [-old bbb] [-out ccc] [-f] [-d] [-v] [-help] [fff]
#		type -  flag (must be the first option, can have the following values:
#			mm - translation from mm to sml,
#			man - translation from man to rsml,
#			mm_motif - translation from mm, as it is used 
#				in motif's documentation to sml,
#			man_motif - translation from man, as it is used 
#				in motif's documentation to rsml.
#		aaa - SML syntax description file name ( default sml.desc )
#		bbb - nonsemantic syntax file name ( default mm.desc)
#		ccc - output file name 
#		-f - force option (overwrite file, without confirmation )
#		-d - debuging option
#		-v - verbose option
#		-help  - help option ( to print this message )
#		fff - text file name
#
DEFAULT_DTE_LIBDIR=/project/tools/libdata

if [ -z "$DTE_LIBDIR" ] ; then DTE_LIBDIR=$DEFAULT_DTE_LIBDIR ; fi
if [ -z "$SML_DIR" ]    ; then SML_DIR=$DTE_LIBDIR/sml ; fi

if [ ! -d "$SML_DIR" ] ; then
    echo "Could not find sml data files.  $SML_DIR does not exist."
    exit 1
fi

EXEC=sml_trans.bin
ACCENT=""
type=mm
find_type=no
if [ "$#" != 0 ]; then
	if [ "$1" = "-man" ]; then
		type=man
		find_type=yes
	else
		if [ "$1" = "-mm" ]; then
			type=mm
			find_type=yes
		else
			if [ "$1" = "-man_motif" ]; then
				type=man_motif
				find_type=yes
			fi
		fi
	fi
	if [ "$1" = "-mm_motif" ]; then
			type=mm_motif
			find_type=yes
	fi
fi
if [ "$find_type" = "yes" ]; then
	shift
fi
if [ "$type" = "mm" ]; then
	SML_DESCR=$SML_DIR/sml.desc
	OLD_DESCR=$SML_DIR/mm.desc
fi
if [ "$type" = "man" ]; then
	SML_DESCR=$SML_DIR/rsml.desc
	OLD_DESCR=$SML_DIR/man.desc
fi
if [ "$type" = "mm_motif" ]; then
	SML_DESCR=$SML_DIR/sml.desc
	OLD_DESCR=$SML_DIR/mm.desc
	ACCENT="-accent $SML_DIR/motif_mm.desc"
fi
if [ "$type" = "man_motif" ]; then
	SML_DESCR=$SML_DIR/rsml.desc
	OLD_DESCR=$SML_DIR/man.desc
	ACCENT="-accent $SML_DIR/motif_acc.desc"
fi
exec $EXEC -synt $SML_DESCR $ACCENT -old $OLD_DESCR $*
