#!/bin/sh
#
# Copyright (c) 1991, OPEN SOFTWARE FOUNDATION, INC.
# ALL RIGHTS RESERVED
#
#  Changes DEFAULT_DTE_DTELIB string in the appropriate files.
#  Expects to be run from directory where the programs are installed
#  (i.e. /some/path/to/bin).

files="book-format dman dmm dsml format-gloss"

if [ $# -lt 1 ] ; then
    /bin/echo -n "Enter new root path for dte: "
    read r
else
    r=$1
fi

for f in $files ; do
    if [ ! -r $f ] ; then
	echo "Can not access $f."
	continue
    fi
    echo Doing $f
    chmod u+w $f
    sed -e 's:^DEFAULT_DTE_DTELIB.*$:DEFAULT_DTE_DTELIB='$r: $f > $f.$$
    mv $f.$$ $f
    chmod -w $f
done

