#!/bin/sh
#
#  Copyright (c) 1991, OPEN SOFTWARE FOUNDATION, INC.
#  ALL RIGHTS RESERVED
#
#  This make an EPS file "printable" - moves it away from the lower-left
#  corner and adds the file name.  The results are sent to stdout.
#
#  Puts the following text after %%EndProlog:
#	gsave
#	  /Times-Roman findfont 12 scalefont setfont
#	  72 72 moveto (<filename>) show
#	grestore
#	72 144 translate
#
#  J.Bowe, June 1991  (K.Flowers did the original PS part)
#
#  $Header: /project/docsrc/src/dte/RCS/print-eps.sh,v 1.1 91/07/03 08:52:01 bowe Exp $

help=false
files=""
xoff="1"
yoff="1"

while [ $# -gt 0 ] ; do
    case "$1" in
	-xoff*)		shift ; xoff="$1"		;;
	-yoff*)		shift ; yoff="$1"		;;
	-off*)		shift ; xoff="$1"; yoff="$1"	;;
	-help)		help=true			;;
	*)		files="$files $1"		;;
    esac
    shift
done

if $help ; then
    cmd=`basename $0`
    cat << E-O-F
Usage: $cmd file ...
    This make an EPS figure "printable" - it moves the figure away from
    the corner and adds the file name.  Useful for window dumps.  The
    results are sent to stdout.  Multiple input files will be sent to
    the output stream.  Use "-" for file name to read stdin.
Options:
    -xoff X	offset in X direction by X inches [ default 1 inch ]
    -yoff Y	offset in Y direction by Y inches [ default 1 inch ]
    -help	print this help message
Examples:
    $cmd file1.ps file2.ps > /tmp/PS-files
    $cmd figures/*.ps | lpr
E-O-F
    exit 0
fi

for file in $files ; do

    cat $file | sed "
    /%%EndComments/a\\
    gsave\\
    /Times-Roman findfont 12 scalefont setfont\\
    $xoff 72 mul $yoff 72 mul moveto ($file) show\\
    grestore\\
    $xoff 72 mul $yoff .5 add 72 mul translate"

done

