/****************************************************************
* Copyright (c) 1990,1991,1992 OPEN SOFTWARE FOUNDATION, INC.	*
* ALL RIGHTS RESERVED.						*
*****************************************************************/
#ifndef lint
static char *RCSid=
 "$Header: /project/docsrc/src/dte/RCS/indpresort.c,v 1.7 91/12/18 13:31:39 bowe Exp Locker: bowe $";
#endif

#define const

#include <stdio.h>
#include <string.h>
#include <ctype.h>

const char      err_usage[] = "Usage: indpresort [-p prep filespec]\n";
const char      err_prep_file[] = "Cant access Preposition File: ";
const char      err_prep_many[] = "Too many words in preposition file\n";
const char      err_flags[] = "Unknown flag\n";
const char      err_flags_comb[] = "Illegal flag combination\n";
const char      err_unterm_conceal[] = "unterminated concealed text\n";

#define KEYN   4
#define INPSZ  200
#define PREPN  20
#define PAGESZ 10
#define FLAGSZ 10
#define NAMESZ 100

/*
 int   get_args      (int, char* argv[]);
 void  load_prep     ();
 void  unload_prep   ();
 int   read_entry    (char [][INPSZ]);
 int   locate_fields ();
 void  show_entry    ();
 void  change_tabs   (char*);
 void  single_space  (char*);
 void  trim_space    (char*);
 char  convert_lower (char*);
 void  remove_prep   (char*);
 void  remove_concealed(char*);
 void  hide_quoted   (char*);
 void  reveal_quoted (char*);
 char  remove_format (char*);
 void  remove_commands (char*);
 char  rearrange_punct (char*, char*);
 void  write_entry   ();
 void  strupr (char*);
 void  strnset (char*, char, int);
 char *Strstr (char*, char*);   
 */

int             get_args();
void            load_prep();
void            unload_prep();
int             read_entry();
int             locate_fields();
void            show_entry();
void            change_tabs();
void            single_space();
void            trim_space();
char            convert_lower();
void            remove_prep();
void            remove_concealed();
void            hide_quoted();
void            reveal_quoted();
char            remove_format();
void            remove_commands();
char            rearrange_punct();
void            write_entry();
void            strupr();
void            strnset();
char           *Strstr();


char            inp[KEYN][INPSZ];
char            key[KEYN][INPSZ];
char            punct[KEYN][INPSZ];
char           *inp_p[KEYN];
char            alpha_flag[KEYN];
char            case_flag[KEYN];
char            font_flag[KEYN];
char            page[PAGESZ];
char            flags[FLAGSZ];
char            prep_filename[NAMESZ];

char            unused[] = "";
const char      valid_flags[] = "![];: ";
const char      quoted_chars[] = "\\{}~-";
char           *prep_tbl[PREPN];
int             prep_l[PREPN];
int             prep_n;

#define AlsoAlpha	"!@#$%^&*_+=|.,/;:\\?<>"
#define NotAlpha	"\\\"\'"

int IsAlpha(c)
char c;
{
    if (strchr(NotAlpha, c)) return 0;
    if (c < ' ') return 0;
    return 1;
/*    if (isalpha(c)) return 1;*/
/*    if (strchr(AlsoAlpha, c)) return 1;*/
/*    return 0;*/
}


int 
main(argc, argv)
    int             argc;
    char           *argv[];

{
    int             ret_code;
    int             i, j, k;

    if (i = get_args(argc, argv))
	return i;
    load_prep();
    while (read_entry(inp))
	if (locate_fields())
	    show_entry();
	else {
	    for (k = 0; k < KEYN; k++) {
		strcpy(key[k], inp_p[k]);

		hide_quoted(key[k]);
		change_tabs(key[k]);
		case_flag[k] = convert_lower(key[k]);
/*		remove_concealed(key[k]);*/
		remove_prep(key[k]);
		font_flag[k] = remove_format(key[k]);
		single_space(key[k]);
		trim_space(key[k]);
		alpha_flag[k] = rearrange_punct(key[k], punct[k]);
		reveal_quoted(key[k]);

		change_tabs(inp_p[k]);
		hide_quoted(inp_p[k]);
/*		remove_commands(inp_p[k]);*/
		reveal_quoted(inp_p[k]);
		single_space(inp_p[k]);
		trim_space(inp_p[k]);
	    }
	    write_entry();
	}

    unload_prep();
    return 0;
}

int 
get_args(argc, argv)
    int             argc;
    char           *argv[];
{
    int             i, errors;
    char           *cp;
    errors = 0;
    *prep_filename = '\0';
    for (i = 1; i < argc && *argv[i] == '-'; i++) {
	switch (*++argv[i]) {
	case 'p':
	    if (*++argv[i]) strcpy(prep_filename, argv[i]);
	    else if (++i < argc) strcpy(prep_filename, argv[i]);
	    break;
	default:
	    (void)fprintf(stderr, err_usage);
	    errors++;
	}
    }
    if (i != argc && !errors) {
	(void)fprintf(stderr, err_usage);
	errors++;
    }
    return errors;
}

void 
load_prep()
{
    int             i, j;
    char           *cp, *lp;
    FILE           *prep_file;
    char            buf[100];
    prep_n = 0;
    if (!*prep_filename) return;
    if ((prep_file = fopen(prep_filename, "r")) != NULL) {
	for (i = 0; (cp = fgets(buf, 100, prep_file)) && i < PREPN; i++) {
	    if (lp = strchr(cp, '\n')) *lp = '\0';
	    single_space(cp);
	    trim_space(cp);
	    if (*cp) {
		strupr(cp);
		(void)strcat(cp, " ");
		prep_l[i] = strlen(cp);
		if (prep_tbl[i] = (char *) malloc((unsigned int)(prep_l[i]+1)))
		    strcpy(prep_tbl[i], cp);
		else break;
		prep_n++;
	    }
	}
	if (i >= PREPN) (void)fprintf(stderr, err_prep_many);
	(void)fclose(prep_file);
    }
    else {
	(void)fprintf(stderr, err_prep_file);
	(void)fprintf(stderr, "%s\n", prep_filename);
    }
}

void 
unload_prep()
{
    int             i;
    for (i = 0; i < prep_n; i++) (void)free(prep_tbl[i]);
}

int 
read_entry(Inp)
    char            Inp[][INPSZ];
{
    int             i, j;
    i = 0;
    if (inp_p[0] = fgets(Inp[0], INPSZ, stdin)) {
	(void)sscanf(Inp[0], "%d %n", &i, &j);
	inp_p[0] += j;
	for (j = 1; j < i; j++) inp_p[j] = fgets(Inp[j], INPSZ, stdin);
	for (j = 0; j < i; j++) Inp[j][strlen(Inp[j]) - 1] = '\0';
	for (; j < KEYN; j++) inp_p[j] = unused;
    }
#ifdef DEBUG
    printf ("read "); for (j=0; j<KEYN; j++)  printf("%s/", inp_p[j]);
    printf ("\n"); 
#endif
    return i;
}


void 
write_entry()
{
    int             i;
    char            pf;

#ifdef DEBUG
    printf ("page %s flags %s \n", page, flags); for (i=0; i<KEYN; i++)
    printf ("input=%s     key=%s    punct=%s    ACF=%c%c%c\n",
    inp_p[i],key[i],punct[i],alpha_flag[i],case_flag[i],font_flag[i]);
    printf ("\n"); 
#endif
    for (i = 0; i < KEYN; i++) {
	printf("%c%s%c%c%s%c%c%c",
	       alpha_flag[i], key[i], 0x02, case_flag[i], punct[i], 0x02,
	       font_flag[i], 0x01);
    }
    pf = '2';
    if (strchr(flags, '[')) pf = '1';
    if (strchr(flags, ']')) pf = '3';
    printf("%s%c%c%s%c", page, 0x01, pf, flags, 0x01);
    for (i = 0; i < KEYN; i++) {
	printf("%s%c", inp_p[i], 0x01);
    }
    printf("\n");
    /**/
}


int 
locate_fields()
{
    int             i, j;
    char           *fp, *rp, *cp;
    fp = inp_p[0];
    i = (cp = strchr(fp, ' ')) - fp;
    (void)strncpy(page, fp, i);
    page[i] = '\0';
    *flags = '\0';
    fp = cp + strspn(cp, " ");
    if (*fp == '-' && *(fp + 1) != '-') {
	if (rp = strpbrk(fp, ":;")) i = rp - fp + 1;
	else i = strlen(fp);
	if (i >= FLAGSZ) {
	    (void)fprintf(stderr, err_flags);
	    return 1;
	}
	(void)strncpy(flags, fp, i);
	flags[i] = '\0';
	if (strspn(flags + 1, valid_flags) != strlen(flags + 1)) {
	    (void)fprintf(stderr, err_flags);
	    return 1;
	}
	if (strlen(flags) > ( strchr(flags, '!') &&
		(strchr(flags, ']') || strchr(flags, '[')) ? 3 : 2 ) )
	{
	    (void)fprintf(stderr, err_flags_comb);
	    return 1;
	}
	fp += i;
	for (i = 0; i < KEYN - 1; i++)
	    inp_p[i] = inp_p[i + 1];
	if (rp) {
	    inp_p[i] = fp;
	    strcpy(page, "zzzzzzz");
	}
	else inp_p[i] = unused;
    }
    else inp_p[0] = (*fp == '-') ? fp + 1 : fp;
#ifdef DEBUG
    printf ("inp field "); for (i=0; i<KEYN; i++) printf("%s/",inp_p[i]);
    printf ("\n"); 
#endif
    return 0;
}

void 
show_entry()
{
    int             i;
    (void)fprintf(stderr, "Entry: ");
    for (i = 0; i < KEYN; i++)
	if (inp_p[i] != unused) (void)fprintf(stderr, "\"%s\"   ", inp_p[i]);
    (void)fprintf(stderr, "page: \"%s\"   flags: \"%s\"\n", page, flags);
}



void 
change_tabs(str)
    char           *str;
{
    char           *cp;
    while (cp = strchr(str, '\t')) *cp = ' ';
}


void 
single_space(str)
    char           *str;
{
    char           *sp, *dp, prev;
    for (prev = 'x', sp = dp = str; prev; prev = *sp++)
	if (prev != ' ' || *sp != ' ') *dp++ = *sp;
}


void 
trim_space(str)
    char           *str;
{
    int             i;
    if (str[0] == ' ') strcpy(str, str + 1);
    if (str[i = strlen(str) - 1] == ' ' && i >= 0) str[i] = '\0';
}


char 
convert_lower(str)
    char           *str;
{
    char            c;
    int             i, upper, lower, len;
    for (upper = lower = i = 0, len = strlen(str); i < len; i++) {
	if (isalpha(str[i])) {
	    if (isupper(str[i])) upper++;
	    else lower++;
	}
    }
    if (lower == 0) c = '1';
    else if (upper == 0) c = '3';
    else if (upper == 1 && isupper(str[0])) c = '2';
    else c = '4';
    strupr(str);
    return c;
}


void 
remove_prep(str)
    char           *str;
{
    char           *cp;
    int             i;
    for (i = strlen(str) - 1; i >= 0 && str[i] == ' '; i--);
    str[++i] = '\0';
    cp = str;
    while (*cp) {
	cp += strspn(cp, " ");
	if (*cp == '~' && isalpha(*++cp)) {
	    *(cp - 1) = ' ';
	}
	else if (isalpha(*cp)) {
	    for (i = 0; i < prep_n; i++) {
		if (!strncmp(cp, prep_tbl[i], prep_l[i])) {
		    strnset(cp, ' ', prep_l[i]);
		    break;
		}
	    }
	    if (i == prep_n) break;
	}
	cp += strcspn(cp, " ");
    }
}


void 
hide_quoted(str)
    char           *str;
{
    char           *cp;
    int             span, i;
    char            string_quote[2];
    cp = str;
    while (*(cp += strcspn(cp, quoted_chars))) {
	string_quote[0] = *cp;
	string_quote[1] = '\0';
	span = strspn(cp, string_quote);
	cp += span % 2;
	for (i = 0; i < span / 2; i++)
	    *cp++ |= 0x80;
/*	    *cp++ |= '\x80';*/
	if (span > 1) strcpy(cp, cp + span / 2);
	cp += span / 2;
    }
}


void 
reveal_quoted(str)
    char           *str;
{
    char           *cp;
    for (cp = str; *cp; cp++)
	*cp &= 0x7F;
}

/*
void 
remove_concealed(str)
    char           *str;
{
    char           *sp, *ep;
    sp = str;
    while (sp = strchr(sp, '{')) {
	if (ep = strchr(sp, '}')) strcpy(sp, ep + 1);
	else {
	    (void)fprintf(stderr, err_unterm_conceal);
	    show_entry();
	    sp = 0;
	}
    }
}
*/

char 
remove_format(str)
    char           *str;
{
    char           *sp, flag;
char *cp;
    flag = '0';
    for (sp = str; sp;) {
	if (sp = Strstr(sp, "\\F")) {
	    flag = '1';
	    strcpy(sp, (*(sp + 2) == '(') ? sp + 5 : sp + 3);
	}
    }
    return flag;
}

/*
void 
remove_commands(str)
    char           *str;
{
    char           *cp;

    for (cp = str; *cp; cp++) {
	cp += strcspn(cp, "{}~");
	if (*cp) strcpy(cp, cp + 1);
    }
}
*/

char 
rearrange_punct(str, Punct)
    char           *str;
    char           *Punct;
{
    char           *sp, *dp, *pp, content;
    dp = sp = str;
    pp = Punct;
    if (isdigit(*sp)) content = '2';
    else {
	content = '3';
	for (content = '1'; *sp && content == '1'; sp++)
	    if (IsAlpha(*sp)) content = '3';
	for (sp = str; *sp; sp++) {
	    if (*sp == '~') *dp++ = *++sp;
	    else {
		if (content == '3' && !IsAlpha(*sp)) {
		    (void)sprintf(pp, "%02d", sp - str);
		    pp += 2;
		    *pp++ = *sp;
		}
		else *dp++ = *sp;
	    }
	}
	*dp = '\0';
    }
    *pp = '\0';
    return content;
}

void 
strupr(cp)
    char           *cp;
{
    for (; *cp; cp++) *cp = toupper(*cp);
}

void 
strnset(cp, c, len)
    char           *cp;
    char            c;
    int             len;
{
    for (; len-- > 0; *cp++ = c);
}

char           *
Strstr(src, pat)
    char           *src;
    char           *pat;
{
    char           *sp;
    int             l;

    sp = src;
    l = strlen(pat);
    while (sp) {
	if (sp = strchr(sp, *pat)) {
	    if (!strncmp(sp, pat, l)) break;
	    else sp++;
	}
    }
    return sp;
}
