/*
 *
 *	Copyright (c) 1990,1991, OPEN SOFTWARE FOUNDATION, INC.
 *	ALL RIGHTS RESERVED
 *
 */
/*  $Header: /project/docsrc/src/dte/RCS/fixVertMot.c,v 1.1 91/04/09 18:50:41 bowe Exp $ */

#include "stdio.h"

char line[1000];		/* input line */
char compensate[1000];	/* compensation */

main(argc, argv, envp)
int argc;
char ** argv;
char ** envp;
{
	register int i, j;

	j = ! EOF;

	while ( j != EOF ) {

		for (i=0; ((j = getchar()) != EOF) && ( j != '\n'); i++) {
			line[i] = j;
		}
		line[i] = compensate[0] = 0; 

		for (i=0; i < (strlen(line) - 3); i++) {

			if (line[i] != '\\')
				continue;

			switch ( line[++i] )	{
			case 'L':
			case 'v':	addDist(i+1);
						break;
			default:	break;
			}
		}

		/* line parsed -- output compensation, if necessary */

		if ( compensate[0] )	{
			printf("%s\\v'%s'\n", line, compensate);
		} else	{
			printf("%s\n",line);
		}
	}
}

/*	addDist() -- gather the movement value and save it
*
*/

addDist(offset)
int offset;
{
	register int i, j, terminate;

	if ( !line[offset] || !line[offset+1] )
		return;

	terminate = line[offset];

	j = strlen(compensate);

	i = offset + 1;			/* point at first part of number */

	if ((line[i] != '+') && (line[i] != '-')) {
		compensate[j++] = '-';
	}

	for ( ; line[i] && (line[i] != terminate); i++, j++)	{

		if ((line[i] == '\\') && line[i+1] && (line[i+1] == '(')) {
			i += 3;
			j--;
			continue;
		}

		if ( line[i] == '+' )
			compensate[j] = '-';
		else if ( line[i] == '-' ) {
				if ( j )
					compensate[j] = '+';
				else j--;
		} else 
			compensate[j] = line[i];
	}
	compensate[j] = 0;
}
