...\"*********************************************************************
...\"            Title of the Chapter
...\"*********************************************************************
.H 1 "Knowing Your Readers"
.iX "index entry"
.iX "another index entry"
.P
Sensitivity to your readers' needs is important to the success of
OSF's offerings. Documentation plays an important part in how well a
product is received by its users. When writing for our users, it is
important to start with a good understanding of who your readers are
likely to be. The way you write, the vocabulary you use, and the way
you organize information depend on the type of reader you plan to
address. Become familiar with the information in the following
sections as you plan your writing.
.H 2 "What Readers Want"
Most readers approach new product documentation with similar attitudes:
.in +.5
.BL
.LI
They are eager for action.
.LI
They are primed to do work with the product.
.LI
They are short of time.
.LI
They are motivated to succeed.
.LE
.in -.5
.P
You can help your readers learn quickly by writing for action. Where appropriate, introduce simple tasks or procedures very early, and make sure users are certain of success in performing those procedures.
.H 2 "How Readers Learn"
Research shows that readers approach learning about new products in two ways, with two different learning styles.
.P
.B Experimenters 
want to try things right away instead of taking the time to read the instructions. Experimenters share these characteristics:
.in +.5
.BL
.LI
They read written procedures only as a last resort.
.LI
They believe instructions are probably incomplete.
.LI
They rely heavily on tables of contents, section titles, and indexes when searching for information.
.LI
They consult examples more often than text for information.
.LE
.in -.5
.P
.B "Directed learners" 
read before they act. Directed learners share these characteristics:
.in +.5
.BL
.LI
They read procedures and explanations carefully.
.LI
They believe the documentation is correct.
.LI
They pause over tiny discrepancies.
.LI
They consult examples to confirm the correctness of their actions.
.LE
.in -.5
.P
Most documentation should provide information that works for both the experimenter and the directed learner. Where appropriate, you should include step-by-step teaching exercises (tutorials) for directed learners and easily accessible reference and procedural information for experimenters. Chapter 2 describes the structural elements of OSF documentation in which all of these types of information can be presented.
.H 2 "How Readers Find Information"
.P
Experimenters make heavy use of the table of contents, section titles, and the index to find information. Directed learners often read straight through a document and later return to the same elements for review. 
.P
A comprehensive index is the most useful aid you can provide a searching reader; a clear table of contents is almost as important. When you write section titles, make them lively and direct so that readers can tell exactly what a section
is about. The table of contents then becomes much more useful as a pointer to information.
.H 2 "Knowing the Product"
.P
Your knowledge of the product\(emits uses, benefits, and idiosyncrasies\(emis critical to developing useful documentation. Occasionally, writers try to develop documentation based solely on the developers' specifications. Even when the developers are very capable writers, the documentation suffers.
.P
Get your hands on the product and use it as much as time allows. When you work with the product you learn to use it effectively, and you can pass along to readers many tips and shortcuts you could not otherwise have provided.
.P
As you think about potential users of your documentation, keep in mind the product's market\(emwhat kind of individuals or businesses will use it, how they will use it, and what benefits the product can provide. Consider the internationalization and localization issues that must be addressed as you plan the development of your document. Questions like the following can be useful when examining potential users of your document:
.in +.5
.BL
.LI
Who are the users?
.LI
What does the product do for the users?
.LI
What are the product's benefits?
.LI
Where will the product be used?
.LE
.in -.5
.nP
