/* $Header:aedjournal.c 12.0$ */
/* $ACIS:aedjournal.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/aedjournal.c,v $ */

#ifndef lint
static char *rcsid = "$Header:aedjournal.c 12.0$";
#endif

#include "whim.h"
#define ABRT(F,S) {fprintf(stderr,F,S); exit();}
#define GET1INT   read(fn,&p1,2)
#define GET2INTS {read(fn,&p1,2);read(fn,&p2,2);}
#define GET3INTS {read(fn,&p1,2);read(fn,&p2,2);read(fn,&p3,2);}
#define GET4INTS {read(fn,&p1,2);read(fn,&p2,2);read(fn,&p3,2);read(fn,&p4,2);}
#define GET5INTS {read(fn,&p1,2);read(fn,&p2,2);read(fn,&p3,2);read(fn,&p4,2); \
		  read(fn,&p5,2);}
#define GET7INTS {read(fn,&p1,2);read(fn,&p2,2);read(fn,&p3,2);read(fn,&p4,2); \
		  read(fn,&p5,2);read(fn,&p6,2);read(fn,&p7,2);}
#define GET1STR  getstr(pstr,fn)

main(argc,argv)
INT_PURE argc;
char *argv[];

{
#include "whimdcl.h"
  extern unsigned char *malloc();
  INT_PURE  fn;
  unsigned char *block; 		/* for block or string parameters */
  unsigned char *block2;		/* for block or string parameters */
  char pstr[80];			/* for string parameters */
  unsigned INT16 p1,p2,p3,p4,p5,p6,p7;	/* for word parameters */
  INT16 job = 0;

	     fprintf(stderr,"\nIBM Viking Journal Reader\n");
	     fprintf(stderr,"Version 1.30 (C)Copyright IBM Corp 1984,1985\n\n");

  if ((fn = open(*++argv,BREAD)) < 0)
     { fprintf(stderr,"Error opening %s\n",*argv);
       return(TRUE);
     }

  while(job != ALLDONE)
     { GET1INT;  job = p1;		 /*  get command type  */
       switch(job)
	   { case V_FORCE:   printf("VI_Force()\n");
			     break;
	     case V_AMOVE:   GET2INTS;
			     printf("VI_AMove(%d,%d)\n",p1,p2);
			     break;
	     case V_SCROLL:  GET5INTS;
			     printf("VI_Scroll(%d,%d,%d,%d,%d)\n",
					p1,p2,p3,p4,p5);
			     break;
	     case V_RMOVE:   GET2INTS;
			     printf("VI_RMove(%d,%d)\n",p1,p2);
			     break;
	     case V_ALINE:   GET2INTS;
			     printf("VI_ALine(%d,%d)\n",p1,p2);
			     break;
	     case V_RLINE:   GET2INTS;
			     printf("VI_RLine(%d,%d)\n",p1,p2);
			     break;
	     case V_CIRC:    GET1INT;
			     printf("VI_Circle(%d)\n",p1);
			     break;
	     case V_MIMAGE:  GET3INTS;
/* allocate for image */     if ((block = malloc(p3)) == NULL)
				ABRT("Heap full. [Journal(%s): VI_MImage]\n",
				       *argv);
/* get image */ 	     if (p3 != read(fn,block,p3)) return(TRUE);
			     printf("VI_MImage(%d,%d,***)\n",p1,p2);
/* don't need anymore */     free(block);
			     break;
	     case V_FIMAGE:  GET1STR;
			     printf("VI_FImage('%s')\n",pstr);
			     break;
	     case V_TILE:    GET5INTS;
			     if ((block = malloc(p5)) == NULL)
				ABRT("Heap full. [Journal(%s): VI_Tile]\n",
				       *argv);
			     if (p5 != read(fn,block,p5)) return(TRUE);
			     printf("VI_Tile(%d,%d,%d,%d,***)\n",p1,p2,p3,p4);
			     free(block);
			     break;
	     case V_STRING:  GET1STR;
			     printf("VI_String('%s')\n",pstr);
			     break;
	     case V_COPY:    GET7INTS;
			     printf("VI_Copy(%d,%d,%d,%d,%d,%d,%d)\n",
				     p1,p2,p3,p4,p5,p6,p7);
			     break;
	     case V_FREAD:   GET4INTS;
			     GET1STR;
			     printf("VI_FRead(%d,%d,%d,%d,'%s')\n",
				     p1,p2,p3,p4,pstr);
			     break;
	     case V_COLOR:   GET1INT;
			     printf("VI_Color(%d)\n",p1);
			     break;
	     case V_CLIP:    GET4INTS;
			     printf("VI_Clip(%d,%d,%d,%d)\n",p1,p2,p3,p4);
			     break;
	     case V_MERGE:   GET1INT;
			     printf("VI_Merge(%d)\n",p1);
			     break;
	     case V_FONT:    GET1STR;
			     printf("VI_Font('%s')\n",pstr);
			     break;
	     case V_DASH:    GET2INTS;
			     printf("VI_Dash(%d,%d)\n",p1,p2);
			     break;
	     case V_WIDTH:   GET1INT;
			     printf("VI_Width(%d)\n",p1);
			     break;
	     case V_MDCUR:   GET2INTS;	/* cursor defn always 512x2    */
			     if (((block = malloc(512)) == NULL) ||
				((block2 = malloc(512)) == NULL))
				ABRT("Heap full. [Journal(%s): VI_MDefnCur]\n",
				       *argv);
			     if (512 != read(fn,block ,512)) return(TRUE);
			     if (512 != read(fn,block2,512)) return(TRUE);
			     printf("VI_MDefnCur(%d,%d,***,***)\n",p1,p2);
			     free(block2);	/* white */
			     free(block);	/* black */
			     break;
	     case V_FDCUR:   GET1STR;
			     printf("VI_FDefnCur('%s')\n",pstr);
			     break;
	     case V_ENCUR:   printf("VI_EnCur()\n");
			     break;
	     case V_DSCUR:   printf("VI_DisCur()\n");
			     break;
	     case V_PSCUR:   GET2INTS;
			     printf("VI_PosnCur(%d,%d)\n",p1,p2);
			     break;
	     case V_GETATFONT: GET1STR;
			     printf("VI_GetATFont('%s',***)\n",pstr);
			     break;
	     case V_GETFONT: GET1STR;
			     printf("VI_GetFont('%s',***)\n",pstr);
			     break;
	     case V_DROP:    GET1STR;
			     printf("VI_DropFont('%s')\n",pstr);
			     break;
	     case ALLDONE:   return(FALSE); /* no errors */
			     break;
	     default:	return(TRUE);
			break;
	   }
     }
  close(fn);
  return(FALSE);
}
