#!/bin/csh -f
#
# 5799-WZQ (C) COPYRIGHT = NONE
# LICENSED MATERIALS - PROPERTY OF IBM
#
# $Header:updatedb.csh 12.0$ 
# $ACIS:updatedb.csh 12.0$ 
# $Source: /ibm/acis/usr/src/usr.bin/find/RCS/updatedb.csh,v $ 
#
#	@(#)updatedb.csh	4.6	(Berkeley)	85/04/22
#
# This version has been modified to search only local filesystems
# SRCHPATHS is set based on /etc/fstab, the -xdev option to find
# is used to prevent crossing filesystem boundaries, and the -u
# option to sort is used to prevent duplicate entries for the
# filesystem mountpoints.
#
# set SRCHPATHS = "/"			# directories to be put in the database
#
#		look in /etc/fstab for filesystems that are normally mounted,
#		except for NFS filesystems.
#
set SRCHPATHS = `awk '((($4 == "rw") || ($4 == "ro")) && ($3 == "ufs")) {print $2}' /etc/fstab`
#
#	Use this instead if you really want to search nfs file systems:
#
# set SRCHPATHS = `awk '((($4 == "rw") || ($4 == "ro")) && (($3 == "ufs") || ($3 == "nfs"))) {print $2}' /etc/fstab`
#
#
#	Use this if you have an old-style fstab file:
#
# set SRCHPATHS = `awk -F: ($3 == "rw") {print $2}'` /etc/fstab
#
set LIBDIR = /usr/lib/find		# for subprograms
set TMPDIR = /usr/tmp			# for temporary files
set FINDHONCHO = root			# for error messages
set FCODES = /usr/lib/find/find.codes	# the database 

set path = ( $LIBDIR /usr/ucb /bin /usr/bin )
set bigrams = $TMPDIR/f.bigrams$$
set filelist = $TMPDIR/f.list$$
set errs = $TMPDIR/f.errs$$

# Make a file list and compute common bigrams.
# Alphabetize '/' before any other char with 'tr'.
# If the system is very short of sort space, 'bigram' can be made
# smarter to accumulate common bigrams directly without sorting
# ('awk', with its associative memory capacity, can do this in several
# lines, but is too slow, and runs out of string space on small machines).

nice +10
find ${SRCHPATHS} -xdev -print | tr '/' '\001' | \
   (sort -T $TMPDIR -fu; echo $status > $errs) | \
   tr '\001' '/' >$filelist
$LIBDIR/bigram <$filelist | \
   (sort -T $TMPDIR; echo $status >> $errs) | uniq -c | sort -nr | \
   awk '{ if (NR <= 128) print $2 }' | tr -d '\012' > $bigrams

# code the file list

if { grep -s -v 0 $errs } then
	echo 'squeeze error: out of sort space' | mail $FINDHONCHO
else
	$LIBDIR/code $bigrams < $filelist > $FCODES
	chmod 644 $FCODES
	rm $bigrams $filelist $errs
endif
