/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:screen.h 12.0$ */
/* $ACIS:screen.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ucb/tn3270/RCS/screen.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidscreen = "$Header:screen.h 12.0$";
#endif

/*
 *	@(#)screen.h	3.1  10/29/86
 */

#define	INCLUDED_SCREEN

/* defines and defines to describe how to deal with the screen */

#define	MAXNUMBERLINES		43		/* 3278-4 */
#define	MAXNUMBERCOLUMNS	132		/* 3278-5 */
#define	MAXSCREENSIZE		3564		/* (27*132) 3278-5 */
#define LowestScreen()	0
#define HighestScreen()	(ScreenSize-1)

#define ScreenLineOffset(x)	((x)%NumberColumns)
#define ScreenLine(x)	((int)((x)/NumberColumns))
#define ScreenInc(x)	(((x)==HighestScreen())? LowestScreen():x+1)
#define ScreenDec(x)	(((x)==LowestScreen())? HighestScreen():x-1)
#define ScreenUp(x)	(((x)+(ScreenSize-NumberColumns))%ScreenSize)
#define ScreenDown(x)	(((x)+NumberColumns)%ScreenSize)
#define	IsOrder(x)	(Orders[x])
#define BAIC(x)		((x)&0x3f)
#define CIAB(x)		(CIABuffer[(x)&0x3f])
#define BufferTo3270_0(x)	(CIABuffer[(int)((x)/0x40)])
#define BufferTo3270_1(x)	(CIABuffer[(x)&0x3f])
#define Addr3270(x,y)	(BAIC(x)*64+BAIC(y))
#define SetBufferAddress(x,y)	((x)*NumberColumns+(y))

/* These know how fields are implemented... */

#define	FieldInc(p)	FieldFind(FieldForward, p, LowestScreen())
#define	FieldDec(p)	(HighestScreen() - \
				FieldFind(FieldReverse, \
					HighestScreen()-p, HighestScreen()))
#define WhereAttrByte(p)	(IsStartField(p)? p: FieldDec(p))
#define	WhereHighByte(p)	ScreenDec(FieldInc(p))
#define WhereLowByte(p)		ScreenInc(WhereAttrByte(p))
#define FieldAttributes(x)	(IsStartField(x)? Host[x].field&0xff : \
				    Host[WhereAttrByte(x)].field&0xff)
#define TurnOffMdt(x)	(Host[WhereAttrByte(x)].field &= ~ATTR_MDT)
#define TurnOnMdt(x)	(Host[WhereAttrByte(x)].field |= ATTR_MDT)
#define HasMdt(x)	(Host[x].field&ATTR_MDT)	/* modified tag */

	/*
	 * Is the screen formatted?  Some algorithms change depending
	 * on whether there are any attribute bytes lying around.
	 */
#define	FormattedScreen() \
	    ((WhereAttrByte(0) != 0) || ((Host[0].field&ATTR_MASK) != 0))

#define IsStartField(x)	(Host[x].field&ATTR_MASK)	/* field starts here */
#define NewField(p,a)	(Host[p].field = (a)|ATTR_MASK, \
			    FieldForward[p] = FieldReverse[ScreenSize-p-1] = 1)
#define DeleteField(p)	(Host[p].field = 0, \
			    FieldForward[p] = FieldReverse[ScreenSize-p-1] = 0)
#define	DeleteAllFields()	(bzero(FieldForward, sizeof FieldForward), \
				    bzero(FieldReverse, sizeof FieldReverse))


/* The following are independent of the implementation of fields */
#define IsProtectedAttr(p,a)	(IsStartField(p) || ((a)&ATTR_PROT))
#define IsProtected(p)	IsProtectedAttr(p,FieldAttributes(p))

#define IsUnProtected(x)	(!IsProtected(x))

#define IsAutoSkip(x)	(FieldAttributes(x)&ATTR_AUTO_SKIP)

#define IsNonDisplayAttr(c)	(((c)&ATTR_DSPD_MASK) == ATTR_DSPD_NONDISPLAY)
#define	IsNonDisplay(p)	IsNonDisplayAttr(FieldAttributes(p))

#define IsHighlightedAttr(c) \
		(((c)&ATTR_DSPD_MASK) == ATTR_DSPD_HIGH)
#define	IsHighlighted(p) \
		(IsHighlightedAttr(FieldAttributes(p)) && !IsStartField(p))

#if	defined(SLOWSCREEN)

/*
 * In the situation where we have a copy of the terminal screen in front
 * of us, here are some macros to deal with them.
 */

#define TermAttributes(x)	(TermIsStartField(x)? Terminal[x].field&0xff : \
				    Terminal[WhereTermAttrByte(x)].field&0xff)
#define TermIsStartField(x)	(Terminal[x].field&ATTR_MASK)
#define TermNewField(p,a)	(Terminal[p].field = (a)|ATTR_MASK)
#define TermDeleteField(p)	(Terminal[p].field = 0)
#define TermIsNonDisplay(x)	\
		    ((TermAttributes(x)&ATTR_DSPD_MASK) == ATTR_DSPD_NONDISPLAY)
#define TermIsHighlighted(x) \
		(((TermAttributes(x)&ATTR_DSPD_MASK) == ATTR_DSPD_HIGH) \
				    && !TermIsStartField(x))

#define TerminalCharacterAttr(c,p,a)	(IsNonDisplayAttr(a) ? ' ':c)
#define TerminalCharacter(c,p)	TerminalCharacterAttr(c,p,FieldAttributes(p))

#define NeedToRedisplayFields(p) ((TermIsNonDisplay(p) != IsNonDisplay(p)) || \
				(TermIsHighlighted(p) != IsHighlighted(p)))
#define NeedToRedisplayFieldsAttr(p,c) ( \
			(TermIsNonDisplay(p) != IsNonDisplayAttr(c)) || \
			(TermIsHighlighted(p) != IsHighlightedAttr(c)))

#define NotVisuallyCompatibleAttributes(p,c,d) ( \
			(IsNonDisplayAttr(c) != IsNonDisplayAttr(d)) || \
			(IsHighlightedAttr(c) != IsHighlightedAttr(d)))

#define NeedToRedisplayAttr(c,p,a) \
			((c != GetTerminal(p)) || NeedToRedisplayFieldsAttr(p,a))
#define NeedToRedisplay(c,p)	NeedToRedisplayAttr(c,p,FieldAttributes(p))

#endif	/* defined(SLOWSCREEN) */

#define MAX(x,y)	((x)<(y)? (y):(x))
#define MIN(x,y)	((x)<(y)? x:(y))

typedef struct {
	unsigned char	data,	/* data at this position */
			field;	/* field attributes if ATTR_MASK */
} ScreenImage;

#define GetHost(i)	Host[i].data
#define SetHost(p,c)	(Host[p].data = c)

#if	defined(SLOWSCREEN)
#define GetTerminal(i)		Terminal[i].data
#define SetTerminal(i,c)	(Terminal[i].data = c)
#endif	/* defined(SLOWSCREEN) */
