/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:initvec.c 12.0$ */
/* $ACIS:initvec.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/initvec.c,v $ */

#ifndef lint
static char *rcsid = "$Header:initvec.c 12.0$";
#endif

#include "debug.h"

/*
 * generate trival C interface routine for each type of interrupt.
 * each routine will save the registers in low core and then call
 * trap with the trap number to do the
 * common processing.
 * NCS change: go to 'trapper' which in turn calls trap.
 */

extern char trapper;

#define LIS_R2	0xa420		       /* lis r2,0 */
#define BALAX	0x8b000000 + (char *) &trapper	/* balx absaddr */

#define INTERRUPT(lvl) { STM_R0,REGSAVE, \
	    CAL_R1, DEBUG_STACK,	\
	    BALAX,  (LIS_R2 + lvl), 0 }


struct interrupts {
	short stm, regsave;
	short cal, debugstack;
	char *balax;
	short lis, fill;
} interrupts[MAX_VEC] = {
	INTERRUPT(0),
	INTERRUPT(1),
	INTERRUPT(2),
	INTERRUPT(3),
	INTERRUPT(4),
	INTERRUPT(5),
	INTERRUPT(6),
	INTERRUPT(7),
	INTERRUPT(8),
	INTERRUPT(9),
	INTERRUPT(10)
};

struct svec save_vec[MAX_VEC] = {
	0
};

_init_vectors(flag)
	register int flag;
{
/* initialize the interrupt vectors for program trap and
 * machine check so that we get control, print a message
 * and start execution again.
 * only those vectors that have a bit in "flag" set to one are
 * set the bit corresponds to the bit in the IRB for that level.
 */
	register struct ivec *v;
	register short *q;
	register int i;
	register struct svec *s;

	for (i = 0; i < MAX_VEC; ++i)
		if (flag & (1 << (15 - i))) {
			v = i + (struct ivec *)INT0_VEC;
			s = &save_vec[i];
			if (s->new_iar == 0) {
				s->new_iar = v->new_iar;
				s->new_ics = v->new_ics;
				s->new_fill = v->new_fill;
			}
			v->new_iar = (short *) & interrupts[i];
			v->new_ics = 0x0180 + ((i > 6) ? 0 : i);
			/* set the priority etc. */
		}
}
