/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:installboot.h 12.0$ */
/* $ACIS:installboot.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/standatr/RCS/installboot.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidinstallboot = "$Header:installboot.h 12.0$";
#endif

/*
 * boot defines
 */

#define NBPS		512	/* sector size */

/* fdisk partition entry */
struct fdisk_entry {
	char	boot_ind;
#define	BOOT_ID	0x80
	char	starthead;
	char	startsect;
	char	startcyl;
	char	system_ind;
#define	DOSID	0x01
#define	DOS4	0x04
	char	endhead;
	char	endsect;
#define HIGHCYL(cyl)	(((cyl) & 0x300) >> 2)
#define GETHIGH(sect)	(((sect) & 0xc0) << 2)
#define GETSECTOR(sect)	((sect) & 0x3f)
	char	endcyl;
#define LOWCYL(cyl)	((cyl) & 0xff)
	short	rel_start[2];
	short	part_len[2];
};

#define MAX_ENTRIES	4
#define BOOT_BLK_SIZE (NBPS - (sizeof(struct fdisk_entry)*MAX_ENTRIES+sizeof(short)))
/* hard disk master boot record */
struct fdisk_tab {
	char	boot_block[BOOT_BLK_SIZE];
	struct	fdisk_entry	entry[MAX_ENTRIES];
	short	magic;
#define	FMAGIC	0xaa55
};

struct dos_boot {
	char	jump[3];	/* jump to start of boot */
	char	oem[8];		/* OEM name */
	char	block_size[2];	/* bytes/sector */
	char	cluster_size;	/* sectors/cluster */
	char	reserved[2];	/* reserver for dos */
	char	fat_copies;	/* number of fat's */
	char	dir_entries[2]; /* number of entries in the directory */
	char	device_size[2]; /* total size of dos part of device */
	char	media_descriptor; /* media type */
	char	fat_size[2];	/* size of the FAT (in sectors) */
	char	sectors[2];	/* sector size */
	char	tracks[2];	/* # heads */
	char	hidden[2];	/* number of hidden sectors */
};

#define	BOOT_REC	0x00	/* location of master boot record */
#define DOS_BOOT_REC	0x00	/* location of dos boot record */
#define	BOOT_SIZE	NBPS	/* size of dos boot record */
/*
 * defines dealing with the dos directory structure
 */

#define DIR_NAME_SIZE 11
#define MAX_FAT_COUNT	9
#define FAT_SIZE	NBPS	/* hd only */
#define FAT_COUNT	2	/* hd only */
#define FAT_SIG1	0xff8	/* hd only */
#define FAT_SIG2	0xfff	/* hd only */
#define FAT		1
#define FAT_ENTRY_SIZE	12	/* bits per fat entry */
#define NBITPBYTE	8	/* bits per byte */
#define FIRST_CLUST	2	/* first useable cluster */
#define NUMBER_FAT_ENTRIES ((FAT_SIZE*NBITPBYTE)/FAT_ENTRY_SIZE)
#define UNALLOCATED	0	/* unallocated cluster */
#define BADBLOCK	0xff7	/* bad block in cluster */
#define DOS_EOF_W	0xfff	/* last cluster in file */
#define DOS_EOF_R	0xff8 /* significant bits of eof */
#define HD_DIRECTORY   (FAT+(FAT_SIZE/NBPS)*FAT_COUNT)
#define DIR_SIZE	NBPS	/* hd only */
#define HD_START	(HD_DIRECTORY+(DIR_SIZE/NBPS)) /* start of cluster 2 on HD */
	

/* dos dir */
struct dos_entry {
	char	name[DIR_NAME_SIZE];
#define	DIR_ERASED	0xe5
#define	dend	name[0]
#define	DIR_END		0x00
	char	file_attribute;
#define	DIR_READONLY	0x01
#define	DIR_HIDDEN	0x02
#define DIR_SYSTEM	0x04
#define DIR_VOL_LABEL	0x08
#define DIR_SUBDIR	0x10
#define DIR_ARCHIVE	0x20
	char	reserved[10];
	unsigned short	file_time;
	unsigned short	file_date;
	unsigned short  file_start;
	long	file_size;
};
#define NUMBER_ENTRIES	(DIR_SIZE/sizeof(struct dos_entry)) /* number of entries in the first sector
							     * of a directory */

struct filelist {
	char	*name;
	char	attribute;
	struct	dos_entry *dep;
};

#define LOBYTE(x)	((x) & 0xff)
#define HIBYTE(x)	(((x) >> 8) & 0xff)
#define LOWORD(x)	((x) & 0xffff)
#define HIWORD(x)	(((x) >> 16) & 0xffff)
#define MKHIGH(x)	(((x) & 0xff) << 8)
#define MKLOW(x)	((x) & 0xff)
#define UPPER(x)	((x) >= 'a' && (x) <= 'z' ? (x) - 'a' + 'A' : (x))

/* 
 * maximum block number for a root DOS partition
 * XXX this number needs to be checked...
 */
#define DOS_MAX		(64*1024/(nspc))	/* 32 Meg */

/* returns from getfreepart */
#define OK		0
#define DOS_EXISTS	1
#define NO_SPACE	2

/* exit codes */
#define E_OK		0	/* copy was completed */
#define	E_PARTITION_OK	1	/* partion was ok, but nothing was copied */
#define E_NO_SPACE	2	/* no space on the disk */
#define E_PANIC		3	/* internal state error */
#define E_MISS_FILE	4	/* expected file was missing from diskette */
#define E_CANTOPEN	5	/* can't open floppy or harddisk device */
#define	E_NOINFO	6	/* can't get info on floppy or harddirsk device */
#define E_BAD_DISK	7	/* can't read or write critical data from disk */
#define E_BAD_FLOPPY	8	/* can't read or write critical data from floppy */
#define E_MARGIN_DISK	9 	/* marginal block found on the disk */
#define E_BAD_PARAM	10	/* bad command line parameter/switch */

/* other dos defined */
#define ABSOLUTE_READ	0x25
#define ABSOLUTE_WRITE	0x26
#define BIOS_DISK	0x13
#define GETINFO		0x08

#ifdef USEBADBLOCK
/* these is definately not right */
#define MAX_BAD_BLOCKS	1
#define BAD_BLOCK_LOC	0

/* this may not be right */
struct	bad_block	{
	short	blockno;
};
#endif
