/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:vga.h 12.0$ */
/* $ACIS:vga.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/pc_code/RCS/vga.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidvgadefs = "$Header:vga.h 12.0$";
#endif

/* structure of the interface between UNIX and OS/2 */
union vga_pc_parameters {
	unsigned long	vga_screen_addr;
};

struct vga_params {
	short	pc_opcode;		/* pc command to unix */
	short	unix_opcode;		/* unix command to pc */
	short	write_status;		/* screen write status */
	short	mode;
	union	vga_pc_parameters u;	/* parameters */
};


/* defines for the pc_opcode field */
#define	VGA_SAVE		1
#define	VGA_RESTORE		2

/* defines for the unix_opcode field */
#define	VGA_HKEY_REQ	1
#define	VGA_SET_MODE	2
#define	VGA_GET_MODE	3

/* defines for the write status field */
#define VGA_WRITE_DISABLED	0
#define VGA_WRITE_OK		1

/* text mode defaults */
#define	VGA_ROWS	25
#define	VGA_COLUMNS	80
#define VGA_CELL_SIZE	2		/* bytes */
#define	VGA_BUF_LEN	(VGA_ROWS*VGA_COLUMNS*VGA_CELL_SIZE)

#define	VGA_BACKGROUND	0
#define	VGA_FOREGROUND	1

/*
 * must match /sys/cacons/vgaio.h
 */
#define VGA_MAX_MODES	24
#define MODE_039	11
