#! /bin/awk -f
#$Header:genassym.awk 12.0$
#$ACIS:genassym.awk 12.0$
#$Source: /ibm/acis/usr/sys/ca/RCS/genassym.awk,v $
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# awk script to take a driver file that specifies entries in the 
# following format:
# struct proc	p_p0br	P_P0BR
# define NAME	expression
# format format-item (e.g. %d, 0x%x)
# lines beginning '"' appear in the assym.s file
# lines beginning '##' are comments (deleted)
# all other lines are just passed thru as-is
# the 'data' files contains the C program as well

BEGIN { format = "%d" }

$1 ~ /^##/ { next }

# struct proc p_p0br P_P0BR
#   1     2     3      4
$1 == "struct" {
	printf "printf(\"#define %-16s %s\t/* struct %s offset of %s */\\n\",&((struct %s *)0)->%s);\n",$4,format,$2,$3,$2,$3
	next
}
# generate defines e.g.
# define USIZE sizeof (struct user)
#   1      2    3 ...
# yields: #define USIZE nnn
$1 == "define" {
	string=$3
	comment=$3
	for (i=4; i<= NF; ++i) {
		if ($i != "/*" && $i != "*/")
			comment = comment " " $i
		string = string " " $i
		}
	printf("printf(\"#define %-16s %s\t/* %s */\\n\",%s);\n",$2,format,comment,string)
	next
}
$1 == "format" { format = $2 ; next }
$1 ~ /^"/ { print "printf(\"%s\\n\",",$0,"\");\n" ; next }
# normal C lines
{ print $0; next
}

