/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:ibm8514.h 12.0$ */
/* $ACIS:ibm8514.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca_atr/RCS/ibm8514.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidibm8514 = "$Header:ibm8514.h 12.0$";
#endif

/*
 * defines to determine 8514 display type
 */
#define	IBM8514_CONFIG		0x42e8
#define	IBM8514_DISPLAY_BITS	0x7000
#define	IBM8514_COLOR1		0x2000
#define	IBM8514_COLOR2		0x6000
#define	IBM8514_GRAY1		0x1000
#define	IBM8514_GRAY2		0x5000
#define IBM8514_GRAY19		0x0000	/* 19" gray scale display */

/*
 * use vga emulation mode
 */
#define	IBM8514_RESET		0x4ae8

/*
 * used in probe
 */
#define IBM8514_PROBE_OUT	0xffff

/*
 * color masks and counts
 */
#define IBM8514_MAX_COLORS	256
#define IBM8514_COLOR_MASK	0x3f
#define IBM8514_COLOR_SHIFT	26
#define IBM8514_CURSOR_MASK	0x1
#define IBM8514_MAX_COLUMN	80
#define IBM8514_MAX_ROW		42

struct ibm8514_color {
	char	red,green,blue;
};

/*
 * save buffer so we can restore the screen after a screen switch.
 */
struct ibm8514_save_buf {
	u_char	ch;	/* character value */
	u_char	attr;	/* attributes of the character */
	u_char  fg;	/* forground color */
	u_char	bg	/* background color */
};

/*
 * defines to control screen switching 
 */
#define IBM8514_LOCK(s)   (s=KLSSPL(),ibm8514_lock++,splx(s))
#define IBM8514_UNLOCK(s) (s=KLSSPL(),ibm8514_lock--,splx(s))
#define IBM8514_FOREGROUND	1
#define IBM8514_BACKGROUND	0
#define IBM8514_IN_FOREGROUND	(ibm8514_fgbg)
