/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:loslih.h 12.0$ */
/* $ACIS:loslih.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/loslih.h,v $ */

	.data
#if !defined(NO_RCS_HDRS)
rcsidloslih:	.asciz "$Header:loslih.h 12.0$"
#endif
	.text

 #
 # table defining the SLIH's for each interrupt level
 # in some cases the SLIH will determine the source of an interrupt
 # and then call the appropriate SLIH for that particular source
 # this allows the SLIH to service serveral requests at that level before
 # returning to the FLIH.
 #
#define IOSLICS	4	/* ICS value */
#define DEVSLIH 0	/* the SLIH address */
#define DEVDEP	8	/* the INFO */


#define SLIH_TABLE(level,routine,ics,info) .globl slih_/**/level; \
	.align	2; \
slih_/**/level: .int routine; \
	.short ics, 0; \
	.int	info


SLIH_TABLE(0,_intzero,TRANS_ICS+INT_PRI0,0)			/* level 0 */
#ifdef GPROF
SLIH_TABLE(1,_physclock,TRANS_ICS+INT_PRI1,0)			/* level 1 */
#else
SLIH_TABLE(1,_hardclock,TRANS_ICS+INT_PRI1,0)			/* level 1 */
#endif GPROF
SLIH_TABLE(2,_inttwo,TRANS_ICS+INT_PRI2,0)		/* level 2 */
SLIH_TABLE(3,_int_8259,TRANS_ICS+INT_PRI3,_int3table)		/* level 3 */
SLIH_TABLE(4,_int_8259,TRANS_ICS+INT_PRI4,_int4table)		/* level 4 */
SLIH_TABLE(5,_devunk,TRANS_ICS+INT_PRI5,0)			/* level 5 */
SLIH_TABLE(6,_panic,TRANS_ICS+INT_PRI6,INT6MSG)			/* level 6 */
SLIH_TABLE(6soft,_slih6,TRANS_ICS+INT_PRI6,0)			/* level 6 */

 # INT6MSG: .ascil "Illegal External Interrupt SIX"
 # INT2MSG: .ascii "Illegal Interrupt two\0"
INT6MSG: .ascii "Illegal External Interrupt SIX\0"
