/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:rvaux.c 12.0$ */
/* $ACIS:rvaux.c 12.0$ */
/* $Source: /ibm/acis/usr/sys/afsint/RCS/rvaux.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvaux.c 12.0$";
#endif

#include "../h/types.h"
#include "../h/socket.h"
#include "../h/file.h"
#include "../h/stat.h"
#include "../netinet/in.h"
#include "../h/time.h"
#include "../rpc/types.h"
#include "../rpc/xdr.h"

#define R_INTERNALS	1
#include "../afs/osi.h"
#include "../afs/r.h"
#undef R_INTERNALS

#include "../afsint/rvaux.h"
#include "../afsint/rvice.h"


#define MAXBS	2048		/* try to avoid horrible allocs */
static long bslosers = 0;


/*
 * XDR chars; from user mode xdr package.
 */
bool_t
xdr_char(xdrs, sp)
	register XDR *xdrs;
	char *sp;
{
	long l;

	switch (xdrs->x_op) {

	case XDR_ENCODE:
		l = (long) *sp;
		return (XDR_PUTLONG(xdrs, &l));

	case XDR_DECODE:
		if (!XDR_GETLONG(xdrs, &l)) {
			return (FALSE);
		}
		*sp = (char) l;
		return (TRUE);

	case XDR_FREE:
		return (TRUE);
	}
	return (FALSE);
}

/* 
 * Wrapper for xdr_string that can be called directly from 
 * routines like clnt_call; from user-mode xdr package.
 */
bool_t
xdr_wrapstring(xdrs, cpp)
	XDR *xdrs;
	char **cpp;
{
	if (xdr_string(xdrs, cpp, 1024)) {
		return(TRUE);
	}
	return(FALSE);
}


xdr_CBS(x, abbs)
    XDR *x;
    struct CBS *abbs; {
    long len;
    if (x->x_op == XDR_FREE) {
	osi_Free(abbs->SeqBody, abbs->SeqLen); 
	return TRUE;
    }

    if (x->x_op == XDR_ENCODE) {
	xdr_long(x, &abbs->SeqLen);
	xdr_opaque(x, abbs->SeqBody, abbs->SeqLen);
	return TRUE;
    }
    else {
	xdr_long(x, &len);
	if (len < 0 || len > MAXBS) {bslosers++; return FALSE;}
	if (!abbs->SeqBody) abbs->SeqBody = (char *) osi_Alloc(len);
	abbs->SeqLen = len;
	xdr_opaque(x, abbs->SeqBody, len);
	return TRUE;
    }
}

xdr_BBS(x, abbs)
    XDR *x;
    struct BBS *abbs; {
    long maxLen, len;
    if (x->x_op == XDR_FREE) {
	osi_Free(abbs->SeqBody, abbs->SeqLen); 
	return TRUE;
    }

    if (x->x_op == XDR_ENCODE) {
	xdr_long(x, &abbs->MaxSeqLen);
	xdr_long(x, &abbs->SeqLen);
	xdr_opaque(x, abbs->SeqBody, abbs->SeqLen);
	return TRUE;
    }
    else {
	xdr_long(x, &maxLen);
	xdr_long(x, &len);
	if (len < 0 || len > MAXBS || len > maxLen) {bslosers++; return FALSE;}
	if (!abbs->SeqBody) abbs->SeqBody = (char *) osi_Alloc (maxLen);
	abbs->MaxSeqLen = maxLen;
	abbs->SeqLen = len;
	xdr_opaque(x, abbs->SeqBody, len);
	return TRUE;
    }
}


xdr_AFSAccessList(x, abbs)
    XDR *x;
    struct BBS *abbs; {
    long maxLen, len;
    if (x->x_op == XDR_FREE) {
	osi_Free(abbs->SeqBody, abbs->SeqLen);
	return TRUE;
    }

    if (x->x_op == XDR_ENCODE) {
	xdr_long(x, &abbs->MaxSeqLen);
	xdr_long(x, &abbs->SeqLen);
	xdr_opaque(x, abbs->SeqBody, abbs->SeqLen);
	return TRUE;
    }
    else {
	xdr_long(x, &maxLen);
	xdr_long(x, &len);
	if (len < 0 || len > MAXBS || len > maxLen) {bslosers++; return FALSE;}
	if (!abbs->SeqBody) abbs->SeqBody = (char *) osi_Alloc(maxLen);
	abbs->MaxSeqLen = maxLen;
	abbs->SeqLen = len;
	xdr_opaque(x, abbs->SeqBody, len);
	return TRUE;
    }
}
