static char rcsid[] = "$Header:seekdir.c 12.0$";
#ifndef lint
static char sccsid[] = "@(#)seekdir.c	4.10 (Berkeley) 7/1/83";
#endif

#include <sys/nfs_defines.h>

#ifdef VFS
/* @(#)seekdir.c	1.2 87/07/22 3.2/4.3NFSSRC */
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)seekdir.c	5.2 (Berkeley) 3/9/86";
#endif LIBC_SCCS and not lint
#endif VFS

#include <sys/param.h>
#include <sys/dir.h>

/*
 * seek to an entry in a directory.
 * Only values returned by "telldir" should be passed to seekdir.
 */
void
seekdir(dirp, loc)
	register DIR *dirp;
	long loc;
{
#ifndef VFS
	long curloc, base, offset;
#else !VFS
	long curloc, base, entno;
#endif !VFS
	struct direct *dp;
	extern long lseek();

	curloc = telldir(dirp);
	if (loc == curloc)
		return;
#ifndef VFS
	base = loc & ~(DIRBLKSIZ - 1);
	offset = loc & (DIRBLKSIZ - 1);
#else !VFS
	base = loc / dirp->dd_bsize;
	entno = loc % dirp->dd_bsize;
#endif !VFS
	(void) lseek(dirp->dd_fd, base, 0);
#ifndef VFS
	dirp->dd_loc = dirp->dd_size = 0;
	while (dirp->dd_loc < offset) {
#else !VFS
	dirp->dd_loc = 0;
	dirp->dd_entno = 0;
	while (dirp->dd_entno < entno) {
#endif !VFS
		dp = readdir(dirp);
		if (dp == NULL)
			return;
	}
}
