/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:opendir.c 12.0$ */
/* $ACIS:opendir.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/gen/RCS/opendir.c,v $ */

#ifndef lint
static char *rcsid = "$Header:opendir.c 12.0$";
#endif

#include <sys/nfs_defines.h>

/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)opendir.c	5.2 (Berkeley) 3/9/86";
#endif LIBC_SCCS and not lint

#ifdef VFS
/* @(#)opendir.c	1.2 87/07/22 3.2/4.3NFSSRC */
#endif VFS

#include <sys/param.h>
#ifdef VFS
#include <sys/stat.h>
#endif VFS
#include <sys/dir.h>
#ifdef VFS
#include <errno.h>
#endif VFS

/*
 * open a directory.
 */
DIR *
opendir(name)
	char *name;
{
	register DIR *dirp;
	register int fd;
#ifdef VFS
	struct stat sb;
	extern int errno;
	extern char *malloc();
	extern int open(), close(), fstat();
#endif VFS

	if ((fd = open(name, 0)) == -1)
#ifndef VFS
		return NULL;
	if ((dirp = (DIR *)malloc(sizeof(DIR))) == NULL) {
		close (fd);
		return NULL;
#else !VFS
		return (NULL);
	if (fstat(fd, &sb) == -1) {
		(void) close(fd);
		return (NULL);
#endif !VFS
	}
#ifdef VFS
	if ((sb.st_mode & S_IFMT) != S_IFDIR) {
		errno = ENOTDIR;
		(void) close(fd);
		return (NULL);
	}
	if (((dirp = (DIR *)malloc(sizeof(DIR))) == NULL) ||
	    ((dirp->dd_buf = malloc((int)sb.st_blksize)) == NULL)) {
		if (dirp)
			free(dirp);
		close(fd);
		return NULL;
	}
	dirp->dd_bsize = sb.st_blksize;
	dirp->dd_bbase = 0;
	dirp->dd_entno = 0;
#endif VFS
	dirp->dd_fd = fd;
	dirp->dd_loc = 0;
	return dirp;
}
