/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:packet.h 12.0$ */
/* $ACIS:packet.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/server/RCS/packet.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidpacket = "$Header:packet.h 12.0$";
#endif

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* Data structure definitions and constants for RVD packets. */

#define	SLOPSIZE	(RVDDSIZE * (RVDMXBPP - 1))
#define	MAXPKTSIZE	(sizeof(struct ip) + sizeof(struct rvd) + SLOPSIZE)
#define	BLOCKOFF \
(sizeof(struct rvd_pkt *) + sizeof(struct rvd_pkt *) + sizeof(obj_type) + \
sizeof(int) + sizeof(struct in_addr) + sizeof(struct ip) + sizeof(struct rvdb))

struct	rvd_pkt	{			/* an RVD packet buffer */
	struct	rvd_pkt	*rp_forw;	/* forward link */
	struct	rvd_pkt	*rp_back;	/* backward link */
	obj_type	rp_type;	/* object type code */
	int		rp_len;		/* len of rvd part of packet (bytes) */
	struct	in_addr	rp_fhost;	/* foreign host address */

	struct	ip	rp_ip;		/* ip header */
	struct	rvd	rp_rvd;		/* rvd header */
	u_char		rp_slop[SLOPSIZE]; /* data and slop */
};

struct	pkt_q	{			/* queue of rvd packets */
	struct	rvd_pkt	*pq_forw;	/* forward link */
	struct	rvd_pkt	*pq_back;	/* backward link */
};
