#!/bin/sh -
#
# 5799-WZQ (C) COPYRIGHT = NONE
# LICENSED MATERIALS - PROPERTY OF IBM
#
# This file is part of the Project Athena Remote Virtual Disk (RVD) server.
#
#  $Source: /ibm/acis/usr/src/ibm/rvd/server/RCS/newvers.sh,v $
#  $Author: root $
#  $Header:newvers.sh 12.0$
#  $ACIS:newvers.sh 12.0$


# The RVD server version number has the form #.#.#, where the first
# and second numbers are specified by the release number below, and
# the last one represents the number of times the server has been
# built.  It is generated automatically.
#
release=3.0
if [ ! -r version ]; then
	echo 0 > version;
fi
touch version
minor=`cat version`

# Create the file, vers.c, with the version string, incrementing
# the number in the "version" file.
#
pwd=`pwd`
echo $release $minor $USER $pwd `date` `hostname` | \
awk ' {
	release = $1; minor = $2 + 1; user = $3; host = $11; dir = $4; \
	date = $5 " " $6 " " $7 " " $8 " " $9 " " $10;

}\
END {
	printf "char version_s1[] = \"Athena RVD Server Version %s.%d\";\n", \
		release, minor;
	printf "char version_s2[] = \"(%s@%s:%s) %s\\n\";\n", \
		user, host, dir, date;
	printf "%d\n", minor > "version";
}' > vers.c
