/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:tmpnam.c 12.0$ */
/* $ACIS:tmpnam.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/misc/RCS/tmpnam.c,v $ */

#ifndef lint
static char *rcsid = "$Header:tmpnam.c 12.0$";
#endif


#ifndef lint
static char rcsid_tmpnam_c[] = "$Header:tmpnam.c 12.0$";
#endif lint

/*  Copyright 1984 by the Massachusetts Institute of Technology  */
/*  See permission and disclaimer notice in file "notice.h"  */
#include	"notice.h"


/* Generate a unique temporary name.  Stolen from stdio, but changed to
 * generate shorter variable names so extensions can be added.
 */

char *tmpnam(s)
char *s;
{
	static seed;

	sprintf(s, "t%d.%d", getpid(), seed++);
	return(s);
}


char *
temp_in_dir(fname)

/* Create a temporary file name in the same directory as the specified file
 * (in the current directory if the specified file has no directory spec).
 * Return a pointer to a static string containing the file name.
 */

register char	*fname;
{
	static	char	buf[1024];
	char	buf2[64];
	extern	char	*tmpnam();

	copydir(fname, buf);
	strcat(buf, tmpnam(buf2));
	return(buf);
}


copydir(from, to)

/* Copy the directory part of the file name in from to the buffer in to.
 * Leave the to buffer null-terminated.
 */

register char	*from;
register char	*to;
{
	register char	*p;
	register char	*last;
	register int	len;

	for (last = p = from; *p != '\0';) {
		if (*p++ == '/')
			last = p;
	}

	len = last-from;
	strncpy(to, from, len);
	to[len] = '\0';
}
