/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:fhostname.c 12.0$ */
/* $ACIS:fhostname.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/fhostname.c,v $ */

#ifndef lint
static char *rcsid = "$Header:fhostname.c 12.0$";
#endif


#ifndef lint
static char rcsid_fhostname_c[] = "$Header:fhostname.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define	NOHOST		"(unclaimed)"

#ifndef	SHIFTNAME
#define	SHIFTNAME	1
#endif	SHIFTNAME
#ifndef	DROPDOMAIN
#define	DROPDOMAIN	1
#endif	DROPDOMAIN

#define	tolower(c)	(('A' <= (c) && (c) <= 'Z') ? (c) + ' ' : (c))

/*
 *	get host name and pretty it up for dave.
 */

char *
fhostname(a)

struct in_addr a;

{
	static char	buf[16];
	char	*p, *s, shift;
	struct hostent	*hp;

	if(! (hp = gethostbyaddr(& a, sizeof(struct in_addr), AF_INET))) {
		sprintf(buf, "[%s]", inet_ntoa(a.s_addr));
		return(buf);
	}

	p = hp->h_name;

	s = buf;
	shift = 1&SHIFTNAME;

	for(; *p; ++p) {
#if	DROPDOMAIN
		if(*p == '.')
			break;
#endif	DROPDOMAIN
		if(shift)
			*(s++) = tolower(*p);
		else
			*(s++) = *p;
		shift = 2&SHIFTNAME;
	}
	*s = '\0';
	return(buf);
}
