/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:clnt_ctl.h 12.0$ */
/* $ACIS:clnt_ctl.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/clnt_ctl.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidclnt_ctl = "$Header:clnt_ctl.h 12.0$";
#endif


/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


#include	<sys/types.h>
#include	"canon.h"

#define	NHOST		32
#define	NMSG		500

#define	NITEM(x)	(sizeof(x)/sizeof(x[0]))

#define	B(x)		(1 << (x))

#define	F_PW		"%13s"
#define	F_HS		"%32s"
#define	F_PK		"%16s"
#define	F_PT		"%32s"
#define	F_NM		"%u"
#define	F_MS		"%500s"
#define	F_OW		"%16s"
#define	F_LN		"%80s"
#define	F_BL		"%5s"		/* true/false */

char	*s_keyword,
	*s_error,
	*s_connect,
	*s_more,
	*s_number,
	*s_time,
	*s_oldmode,
	*s_message;

/*
 *	If this table is modified, remember to update ../h/canon.h
 */

tag	tag_tbl[] = {
{"activity",	F_LN,	NULL,	&s_connect,	0,	0,	B(_ACTIVITY)},
{"connections",	F_MS,	NULL,	&s_connect,	0,	0,	B(_CONNECT)},
{"error",	F_LN,	NULL,	&s_error,	0,	0,	B(_ERROR)},
{"message",	F_MS,	NULL,	&s_message,	0,	0,	B(_MESSAGE)},
{"more",	F_BL,	NULL,	&s_more,	0,	0,	B(_MORE)},
{"number",	F_NM,	NULL,	&s_number,	0,	0,	B(_NUMBER)},
{"oldmode",	F_NM,	NULL,	&s_oldmode,	0,	0,	B(_OLDMODE)},
{"time",	F_NM,	NULL,	&s_time,	0,	0,	B(_TIME)}
};

#define	NTAG		NITEM(tag_tbl)

/*
 * The search code depends on the operation strings being in alphabetical order.
 */
op	op_tbl[] = {
{"error",		REQ_ERROR,	OPT_ERROR},
{"add_physical",	REQ_ADD_PHYS,	OPT_ADD_PHYS},
{"add_virtual",		REQ_ADD_VIRT,	OPT_ADD_VIRT},
{"allow_spinups",	REQ_ALW_SPIN,	OPT_ALW_SPIN},
{"delete_virtual",	REQ_DEL_VIRT,	OPT_DEL_VIRT},
{"display_active",	REQ_DSP_ACT,	OPT_DSP_ACT},
{"display_virtual",	REQ_DSP_VIRT,	OPT_DSP_VIRT},
{"disuse_physical",	REQ_DUSE_PHYS,	OPT_DUSE_PHYS},
{"exchange_names",	REQ_XCH_VIRT,	OPT_XCH_VIRT},
{"get_message",		REQ_GET_MSG,	OPT_GET_MSG},
{"log_all_statistics",	REQ_LOG_ALL,	OPT_LOG_ALL},
{"log_external_statistics", REQ_LOG_XTRN, OPT_LOG_XTRN},
{"log_level",		REQ_LOG_LVL,	OPT_LOG_LVL},
{"log_truncate",	REQ_LOG_LVL,	OPT_LOG_LVL},
{"modify_virtual",	REQ_MOD_VIRT,	OPT_MOD_VIRT},
{"require_authorization", REQ_REQ_AUTH,	OPT_REQ_AUTH},
{"set_message",		REQ_SET_MSG,	OPT_SET_MSG},
{"shutdown",		REQ_SHT_SRVR,	OPT_SHT_SRVR},
{"spindown_client",	REQ_SHT_HOST,	OPT_SHT_HOST},
{"spindown_host",	REQ_SHT_HOST,	OPT_SHT_HOST},
{"spindown_virtual",	REQ_SPN_VIRT,	OPT_SPN_VIRT},
{"test_enter",		REQ_TEST_ENTER,	OPT_TEST_ENTER},
{"test_exit",		REQ_TEST_EXIT,	OPT_TEST_EXIT},
{"use_physical",	REQ_USE_PHYS,	OPT_USE_PHYS},
};

#define	NOP		NITEM(op_tbl)
