/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:utils.h 12.0$ */
/* $ACIS:utils.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/tools/RCS/utils.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidutils = "$Header:utils.h 12.0$";
#endif

#include <machdep.h>

#ifndef TRUE
#define TRUE  1
#endif
#ifndef FALSE
#define FALSE 0
#endif


#define  when       break;case
#define  or	    case
#define  otherwise  break;default
#define max(i1,i2)	(i1>i2?i1:i2)
#define min(i1,i2)	(i1<i2?i1:i2)

extern	char	*u_Date();
extern	char	*u_get_hostname();

extern int u_debug;

#define StrMatch(s1,s2) (!strcmp(s1,s2))
#define StrDup(s)	(strcpy(u_malloc(strlen(s)+1),(s)))
#ifdef STRING_UTILS
extern u_strappend();
#endif /* STRING_UTILS */

#ifdef ERROR_UTILS
/*VARARGS*/
extern _errmsg();
extern FILE *u_error_fil;
extern int (*u_exitfunc)();
extern int u_error_level;
#define  U_ACTION	0x00
#define  U_INFO		0x01
#define  U_WARNING	0x02
#define  U_ERROR	0x04
#define  U_FATAL	0x08
#define  U_WSGO		0x10
#define  error_file(f)	   (u_error_fil=(f))
#define  error_func(f)	   (u_exitfunc=(f))
#define  action(m)		_errmsg(U_ACTION,m)
#define  action1(m,a)		_errmsg(U_ACTION,m,a)
#define  action2(m,a,b)		_errmsg(U_ACTION,m,a,b)
#define  action3(m,a,b,c)	_errmsg(U_ACTION,m,a,b,c)
#define  information(m)		_errmsg(U_INFO,m)
#define  information1(m,a)	_errmsg(U_INFO,m,a)
#define  information2(m,a,b)	_errmsg(U_INFO,m,a,b)
#define  information3(m,a,b,c)	_errmsg(U_INFO,m,a,b,c)
#define  warning(m)		_errmsg(U_WARNING,m)
#define  warning1(m,a)		_errmsg(U_WARNING,m,a)
#define  warning2(m,a,b)	_errmsg(U_WARNING,m,a,b)
#define  warning3(m,a,b,c)	_errmsg(U_WARNING,m,a,b,c)
#define  error(m)		_errmsg(U_ERROR,m)
#define  error1(m,a)		_errmsg(U_ERROR,m,a)
#define  error2(m,a,b)		_errmsg(U_ERROR,m,a,b)
#define  error3(m,a,b,c)	_errmsg(U_ERROR,m,a,b,c)
#define  fatal(m)		_errmsg(U_FATAL,m)
#define  fatal1(m,a)		_errmsg(U_FATAL,m,a)
#define  fatal2(m,a,b)		_errmsg(U_FATAL,m,a,b)
#define  fatal3(m,a,b,c)	_errmsg(U_FATAL,m,a,b,c)
#define  WSGO(m)		_errmsg(U_WSGO,m)
#define  WSGO1(m,a)		_errmsg(U_WSGO,m,a)
#define  WSGO2(m,a,b)		_errmsg(U_WSGO,m,a,b)
#define  WSGO3(m,a,b,c)		_errmsg(U_WSGO,m,a,b,c)
#endif /* ERROR_UTILS */

#ifdef DEBUG_UTILS
typedef struct UDARG {
    			char *u_name;
			int  *u_arg;
		    } u_debug_arg;

#define ENTRY_LEVEL 5

/*VARARGS*/
extern int _DEBUG;
extern FILE *u_debug_fil;

#define DEBUG_ON()		(_DEBUG=1)
#define DEBUG_OFF()		(_DEBUG=0)
#define DEBUG_FILE(f)		(u_debug_fil=(f))
#define DPRINTF(s)		(_DEBUG_MSG(s))
#define DPRINTF1(s,a)		(_DEBUG_MSG(s,a))
#define DPRINTF2(s,a,b) 	(_DEBUG_MSG(s,a,b))
#define DPRINTF3(s,a,b,c)	(_DEBUG_MSG(s,a,b,c))
#define DPRINTF4(s,a,b,c,d)	(_DEBUG_MSG(s,a,b,c,d))
#define DPRINTF5(s,a,b,c,d,e)	(_DEBUG_MSG(s,a,b,c,d,e))
#define DEBUG(f,l,s)            (((f)>=(l))?_DEBUG_MSG(s):NULL)
#define DEBUG1(f,l,s,a)         (((f)>=(l))?_DEBUG_MSG(s,a):NULL)
#define DEBUG2(f,l,s,a,b)       (((f)>=(l))?_DEBUG_MSG(s,a,b):NULL)
#define DEBUG3(f,l,s,a,b,c)     (((f)>=(l))?_DEBUG_MSG(s,a,b,c):NULL)
#define DEBUG4(f,l,s,a,b,c,d)   (((f)>=(l))?_DEBUG_MSG(s,a,b,c,d):NULL)
#define DEBUG5(f,l,s,a,b,c,d,e) (((f)>=(l))?_DEBUG_MSG(s,a,b,c,d,e):NULL)
#define D_ENTRY(f,n)		(DEBUG(f,ENTRY_LEVEL,n))
#define D_ENTRY1(f,n,a)		(DEBUG1(f,ENTRY_LEVEL,n,a))
#define D_ENTRY2(f,n,a,b)	(DEBUG2(f,ENTRY_LEVEL,n,a,b))
#define D_ENTRY3(f,n,a,b,c)	(DEBUG3(f,ENTRY_LEVEL,n,a,b,c))
#define D_ENTRY4(f,n,a,b,c,d)	(DEBUG4(f,ENTRY_LEVEL,n,a,b,c,d))
#define D_ENTRY5(f,n,a,b,c,d,e)	(DEBUG5(f,ENTRY_LEVEL,n,a,b,c,d,e))
#define RETURN(v)		return(v)
#else
#define DEBUG_ON()
#define DEBUG_OFF()
#define DEBUG_FILE(f)
#define DPRINTF(f,l,s)
#define DPRINTF1(f,l,s,a)
#define DPRINTF2(f,l,s,a,b)
#define DPRINTF3(f,l,s,a,b,c)
#define DPRINTF4(f,l,s,a,b,c,d)
#define DPRINTF5(f,l,s,a,b,c,d,e)
#define DEBUG(f,l,s)
#define DEBUG1(f,l,s,a)
#define DEBUG2(f,l,s,a,b)
#define DEBUG3(f,l,s,a,b,c)
#define DEBUG4(f,l,s,a,b,c,d)
#define DEBUG5(f,l,s,a,b,c,d,e)
#define D_ENTRY(f,n)
#define D_ENTRY1(f,n,a)
#define D_ENTRY2(f,n,a,b)
#define D_ENTRY3(f,n,a,b,c)
#define D_ENTRY4(f,n,a,b,c,d)
#define D_ENTRY5(f,n,a,b,c,d,e)
#define RETURN(v)		return(v)
#endif /* DEBUG_UTILS */

extern char *malloc();
extern char *calloc();
extern char *realloc();

extern FILE *fopen(),*freopen(),*fdopen(),*popen();
extern int   fclose(),fflush();
extern FILE *popen();

#ifdef FILE_UTILS
extern int   u_fdebug;
extern FILE *_u_fopen();
extern FILE *_u_freopen();
extern FILE *_u_fdopen();
extern FILE *_u_popen();
extern int   _u_fclose();
#define u_fopen(f,m)		_u_fopen(f,m,WHERE_AM_I)
#define u_freopen(f,m,s)	_u_freopen(f,m,s,WHERE_AM_I)
#define u_fdopen(d,m)		_u_fdopen(d,m,WHERE_AM_I)
#define u_popen(c,m)		_u_popen(c,m,WHERE_AM_I)
#define u_fclose(f)		_u_fclose(f,WHERE_AM_I)
#else
#define u_fopen(f,m)		fopen(f,m)
#define u_freopen(f,m,s)	freopen(f,m,s)
#define u_fdopen(d,m)		fdopen(d,m)
#define u_popen(c,m)		popen(c,m)
#define u_fclose(f)		fclose(f)
#endif /* FILE_UTILS */

#ifdef ALLOC_UTILS
extern FILE	 *u_alloc_fil;
extern int	(*u_alloc_fix)();
extern char *_u_malloc(),*_u_calloc(),*_u_realloc();

#define u_free(p)      _u_free((char *)p,WHERE_AM_I)
#define u_malloc(p)    _u_malloc(p,WHERE_AM_I)
#define u_calloc(n,s)  _u_calloc(n,s,WHERE_AM_I)
#define u_realloc(p,s) _u_realloc((char *)p,s,WHERE_AM_I)
#else /* ifndef ALLOC_UTILS */
#define u_free(p) free((char *)p)
#define u_malloc(p) malloc((unsigned)p)
#define u_calloc(n,s) calloc((unsigned)n,(unsigned)s)
#define u_realloc(p,s) realloc((char *)p,(unsigned)s)
#endif /* ALLOC_UTILS */

#ifdef OPT_UTILS
#ifdef BSD42
extern int getopt();
#endif /* ifdef BSD42 */
#endif /* ifdef OPT_UTILS */

/*** declare string operations to make lint happy ***/

extern char *strcat(),*strncat(),*strcpy();
extern char *strncpy(),*index(),*rindex();
extern int   strlen(),strcmp(),strncmp();

#ifdef LATTICE

   /*\
   |*  NOTE:  The "realloc" provided for LATTICE will only work reliably
   |*         for strings or other NULL terminated arrays.
   \*/

extern int   _fmode;   /* LATTICE FILE BRAIN DAMAGE */
#endif /* def LATTICE */
