/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:vtest.c 12.0$ */
/* $ACIS:vtest.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/aedtest/RCS/vtest.c,v $ */

#ifndef lint
static char *rcsid = "$Header:vtest.c 12.0$";
#endif

#include "vikst.h"
#include <machinecons/screen_conf.h>

FILE *fopen();
#ifdef BSD
FILE *out,*spool;
int v_control;
#ifdef BUS
int iaed = E_AED;	/* use to switch input emulator */
int busres;		/* results from opening /dev/bus */
#endif BUS
char *fn,*spoolfn;
char prtbuf[80];
#endif
UINT16 zero;
INT16 iteration; /* loop counter for timeout messages */

INT32 ledstatus;	/* used in BSD, else ignored */


#ifdef BSD
void SHOWLEDS(arg) /* done by vtime */
	int arg;
{
}
#else
#define SHOWLEDS(A) DISPLAY(*A)
#endif

#ifdef BSD
#undef main
#endif

/****************** here is the main!!! *******************/
main(argc,argv)
INT16 argc;
char *argv[];
{
#ifdef BSD
  extern FILE *out;
	extern int reload();
#endif
  extern UINT16 zero;
  INT16 t,errs;


  PRINTF("\nIBM, ACIS Experimental Display Test/Diagnostic\n");
  PRINTF("Version 1.60 (C)Copyright IBM Corp 1985\n\n");

  errs = false;
  zero = 0;

#ifdef BSD	
	signal(SIGHUP,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGPIPE,SIG_IGN);
	signal(SIGSYS,SIG_IGN);
	signal(SIGALRM,SIG_IGN);
	signal(SIGTERM,SIG_IGN);
#endif
#ifdef BSD
	  fn = "aederrs.lst";
	spoolfn = "diagnostic.lst";

 	 if (argc > 2) 
		{
		PRINTF("Usage: viktest [fn[.ext]]           (fn = report file)");
		exit();
		}
  	if (argc == 2)   fn = *++argv;
  	if ((out = fopen(fn,"w")) == NULL) 
		{
		FPRINTF(stderr,"Cannot open %s\n",fn);
		exit();
		}
  	PRINTF("Diagnostic output going to %s\n\n",fn);
	PRINTF("***** Display will freeze for about a minute -- watch the panel leds ******\n");
  	setbuf(out,NULL);	/* force no buffering */
#endif

  	iteration = 0; /* initialize loop counter */
#ifdef INFINITE
	for (;;)
#endif
		 {	/* infinite loop for hardware group */
#ifdef BSD
		if((spool = fopen(spoolfn,"w")) == NULL)
			{
			FPRINTF(stderr,"Unable to open %s\n",spoolfn);
			exit();
			}
		setbuf(spool,NULL); /* force no buffering */
#ifdef BUS
		busres = open("/dev/bus",2);
		if (busres < 0)
			{
			FPRINTF(stderr,"Error opening /dev/bus\n\n");
			exit();
			}
#endif BUS
		v_control = open("/dev/aed",2);
		if (v_control < 0)
			{
			FPRINTF(stderr,"Error opening /dev/aed\n\n");
			exit();
			}
#ifdef BUS
		if (ioctl(v_control,EOSETD,&iaed) < 0) {
				fprintf(stderr,"Error set output emulator\n");
				exit(); }
#endif BUS
#endif BSD
  		p2m("Beginning test series #%d\n",iteration)
#if(0)	/* don't want black display for now */
  		load("blck.vkt"); 
  		wseconds(1);	/* wait -- make sure the screen is painted black! */
#endif
  		ledstatus = 9; SHOWLEDS(&ledstatus);
  		if (vikmem())       abortb("PC-side memory tests fail.\n")
     		else	      p1b("PC-side memory tests pass.\n")
  		ledstatus = 8; SHOWLEDS(&ledstatus);
  		if (t29116())       abortb("Processor tests fail.\n")
     		else	      p1b("Processor tests pass.\n")
  		ledstatus = 7; SHOWLEDS(&ledstatus);
  		if (sram())	      abortb("Shared RAM tests fail.\n")
     		else	      p1b("Shared RAM tests pass.\n")
  		ledstatus = 6; SHOWLEDS(&ledstatus);
  		if (t=spram())      p1d("Scratchpad RAM tests fail.\n")
     		else	      p1b("Scratchpad RAM tests pass.\n")
   		errs |= t;
  		ledstatus = 5; SHOWLEDS(&ledstatus);
  		if (t=t2910())      p1d("2910 test fails.\n")
     		else	      p1b("2910 test passes.\n")
     	errs |= t;
  		ledstatus = 4; SHOWLEDS(&ledstatus);
  		if (t=bufn())       p1d("Bufn (29118) tests fail.\n")
     		else	      p1b("Bufn (29118) tests pass.\n")
     	errs |= t;
  		ledstatus = 3; SHOWLEDS(&ledstatus);
  		if (t=ybus())       p1d("Y-Bus tests fail.\n")
    	 	else	      p1b("Y-Bus tests pass.\n")
     	errs |= t;
  		ledstatus = 2; SHOWLEDS(&ledstatus);
  		if (t=buffer())     p1d("Display Buffer tests fail.\n")
     		else	      p1b("Display Buffer tests pass.\n")
     	errs |= t;
  		if (errs)
			{
			load("blck.vkt");
	    	p1d("\nExperimental Display self-tests fail.\n")
	     	exit();
	    	}
  		ledstatus = 1; SHOWLEDS(&ledstatus);
  		if (errs=longtst()) p1d("Long test fails.\n")
      		else	      p1b("Long test passes.\n")
  		if (errs) 
			{
			load("blck.vkt");
			p1d("\nExperimental Display self-tests fail.\n")
	     	exit();
			}
      	else
			{
			ledstatus=0; SHOWLEDS(&ledstatus);
#ifndef BSD
			bootvt();	/* load terminal microcode and tell success */
#endif
			p1b("\nExperimental Display self-tests succeed.\n")
#ifdef BSD
			dumpspool();
#endif
#ifdef INFINITE
			wseconds(10);
#endif
			}
  		iteration++;
		}	/* end of infinite loop */
}


swap(x)
UINT16 *x;
{
  UINT16 t;
  t = ((*x & 0x00ff) << 8) | ((*x & 0xff00) >> 8);
  *x = t; 
}

#ifdef BSD
dumpspool()
{
		p2b("(above messages are in file %s\n",spoolfn);
		p2b("Look for any error messages in file %s)\n",fn);
		close(v_control);
		PRINTF(" \008");	/* space-backspace to jump-start device aed */
		fclose(spool);
		if((spool = fopen(spoolfn,"r")) == NULL)
			{
			FPRINTF(stderr,"Unable to open %s\n",spoolfn);
			exit();
			}
		while (!(feof(spool)) && (!ferror(spool)))
			/* dump the contents of the print spool file */
			if ((fgets(prtbuf,80,spool)) != NULL)
				{
				if (prtbuf[strlen(prtbuf)-1] == '\n')
					prtbuf[strlen(prtbuf)-1] = '\0';
				puts(prtbuf);
				}	
		fclose(spool);
}
#endif
