/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

/* $Header:delay.h 12.0$ */
/* $ACIS:delay.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/aedtest/RCS/delay.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsiddelay = "$Header:delay.h 12.0$";
#endif

/* use this only for stand-alone (no BSD) */
/* Hardware I/O delay.  At F00080E0 is a pseudo-register. A (approximately)
   one microsecond delay is imposed on the I/O bus for each byte written
   to this register.  It is write-only.   See pp 93-4 in Sailboat HW manual */

#define DELAY_ADDR	0xf00080E0		/* IOCC delay location   | */
#define DELAY()		*((char *) DELAY_ADDR) = 0xff
#define delay(X) { register i; for(i=0; i<X; i++) DELAY(); }
