/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved. The Berkeley Software License Agreement
 * specifies the terms and conditions for redistribution.
 */
/* $Header:main.c 12.0$ */
/* $ACIS:main.c 12.0$ */
/* $Source: /ibm/acis/usr/src/etc/config/RCS/main.c,v $ */

#ifndef lint
static char *rcsid = "$Header:main.c 12.0$";
#endif

#ifndef lint
static char sccsid[] = "@(#)main.c	1.10 (Berkeley) 8/11/83";
#endif

#include <stdio.h>
#include <ctype.h>
#include "y.tab.h"
#include "config.h"
#include <sys/stat.h>
#include <errno.h>

/*
 * Config builds a set of files for building a UNIX
 * system given a description of the desired system.
 */
main(argc, argv)
	int argc;
	char **argv;
{
        char    *objname = "OBJ";
        char    *opts;
        char    buf[80];
        char    dir[80];
        int     no_makedepend = 0;
        int     fastmake = 0;
        extern int getfromsccs;
        struct  stat stat_buf;

	if (argc > 1 && eq("-p", argv[1])) {
		profiling++;
		argc--, argv++;
	}
	if (argc != 2) {
		fprintf(stderr, "usage: config [ -p ] sysname\n");
		exit(1);
	}
	PREFIX = argv[1];
	if (freopen(argv[1], "r", stdin) == NULL) {
		perror(argv[1]);
		exit(2);
	}
	/* Fix for not making directory */
        (void) sprintf(dir, "../%s", argv[1]);
        if (stat(dir, &stat_buf)) {
                extern int errno;

                if (errno == ENOENT) {
                        if (mkdir(dir, 0777)) {
                                perror(dir);
                                exit(2);
                        }
                } else {
                        perror(dir);
                        exit(2);
                }
        } else if ((stat_buf.st_mode & S_IFMT) != S_IFDIR) {
                fprintf(stderr, "config: %s is not a directory\n", dir);
                exit(2);
        }
	/* End fix */
	dtab = NULL;
	confp = &conf_list;
	if (yyparse())
		exit(3);
	switch (machine) {

	case MACHINE_VAX:
		vax_ioconf();		/* Print ioconf.c */
		ubglue();		/* Create ubglue.s */
		break;

	case MACHINE_SUN:
		sun_ioconf();
		break;

	case MACHINE_IBM370:
		ibm370_ioconf();
		break;

	case MACHINE_IBM032:
		ibm032_ioconf();
		break;

	default:
		printf("Specify machine type, e.g. ``machine vax''\n");
		exit(1);
	}
	makefile();			/* build Makefile */
	headers();			/* make a lot of .h files */
	swapconf();			/* swap config files */
	printf("Don't forget to run \"make depend\"\n");
}

/*
 * get_word
 *	returns EOF on end of file
 *	NULL on end of line
 *	pointer to the word otherwise
 */
char *
get_word(fp)
	register FILE *fp;
{
	static char line[80];
	register int ch;
	register char *cp;

	while ((ch = getc(fp)) != EOF)
		if (ch != ' ' && ch != '\t')
			break;
	if (ch == EOF)
		return ((char *)EOF);
	if (ch == '\n')
		return (NULL);
	cp = line;
	*cp++ = ch;
	while ((ch = getc(fp)) != EOF) {
		if (isspace(ch))
			break;
		*cp++ = ch;
	}
	*cp = 0;
	if (ch == EOF)
		return ((char *)EOF);
	(void) ungetc(ch, fp);
	return (line);
}

/*
 * prepend the path to a filename
 */
char *
path(file)
	char *file;
{
	register char *cp;

	cp = malloc((unsigned)(strlen(PREFIX)+strlen(file)+5));
	(void) strcpy(cp, "../");
	(void) strcat(cp, PREFIX);
	(void) strcat(cp, "/");
	(void) strcat(cp, file);
	return (cp);
}
