/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:com.h 12.0$ */
/* $ACIS:com.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/com.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidcom = "$Header:com.h 12.0$";
#endif

/* Async Register definition and address locations */
struct asydevice {
	unsigned char txb;	       /* Transmit Buffer at 0xf00003f8 */
#define RXB txb			       /* Receive Buffer */
#define LSB txb			       /* Divisor Latch Least Significant Byte */
#define TXB txb
	unsigned char ier;	       /* Interupt Enable Register at 0xf00003f9 */
#define MSB ier			       /* Divisor Latch Most Significant Byte */
#define IER ier
	unsigned char iir;	       /* Interupt Identificaton Reg. at 0xf00003fa */
#define IIR iir
	unsigned char lcr;	       /* Line Control Register at 0xf00003fb */
#define LCR lcr
	unsigned char mcr;	       /* Modem Control Register at 0xf00003fc */
#define MCR mcr
	unsigned char lsr;	       /* Line Status Register at 0xf00003fd */
#define LSR lsr
	unsigned char msr;	       /* Modem Status Register at 0xf00003fe */
#define MSR msr
};
typedef struct asydevice *ASYDEVICE;

#define PC_COM1	0x3f8
#define PC_COM2	0x2f8
#define QUAD_COM1	0x1230
#define QUAD_COM2	0x1234
#define QUAD_COM3	0x1238
#define QUAD_COM4	0x123c


#ifdef IBMRTPC
#define COM1	QUAD_COM1
#endif

#ifdef ATR
#define	COM1	PC_COM1
#endif

#define COM1_LSR	COM1+5
#define COM1_RXB	COM1+0
#define COM1_TXB	COM1+0
#define COM1_LCR	COM1+3
#define COM1_LSB	COM1+0
#define COM1_MSB	COM1+1
#define COM1_IER	COM1+1

#define	COM1_MCR	COM1+4

#define COM_50		0x0900
#define COM_75		0x0600
#define COM_110		0x0417
#define COM_134_5	0x0359
#define COM_150		0x0300
#define COM_300		0x0600
#define COM_600		0x00c0
#define COM_1200	0x0060
#define COM_1800	0x0040
#define COM_2000	0x003A
#define COM_2400	0x0030
#define COM_3600	0x0020
#define COM_4800	0x0018	       /* 4800 baud */
#define COM_9600	0x000c	       /* 9600 baud */
#define COM_19200	0x0006	       /* 19200 baud */


/* following are in the LCR */
#define CHAR_5	0		       /* 5 bits */
#define CHAR_6	1		       /* 6 bits */
#define CHAR_7	2		       /* 7 bits */
#define CHAR_8	3		       /* 8 bits */
#define STOP_1	0		       /* default */
#define STOP_2	4		       /* 2 stop bits */
#define PARITY_DISABLE 0	       /* disable parity */
#define PARITY_ENABLE 8		       /* enable parity */
#define PARITY_EVEN	0x10	       /* even parity */
#define PARITY_ODD	0x00	       /* odd parity */
#define PARITY_STICK	0x20
#define SET_BREAK	0x40
#define COM_DLAB	0x80
