/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986,1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:softint.h 12.0$ */
/* $ACIS:softint.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/softint.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsoftint = "$Header:softint.h 12.0$";
#endif

/*	softint.h	*/

/*
 * CPU level 6 is used for software interrupts.
 *
 * The softlevel word contains one bit representing which software
 * interrupt routine is requested.
 *
 * SOFT_ALL is the OR of all the valid bits and
 * is used for defensive programming.
 */

/*
 * Bit positions for softlevel
 */

#define SOFT_CLOCK	0x01
#define SOFT_NET	0x02
#define SOFT_TTY	0x04
#define SOFT_KLS	0x08
#define SOFT_ASY	0x10
#define SOFT_PSP	0x20
#ifndef ATR
#define SOFT_ALL	(SOFT_CLOCK | SOFT_NET | SOFT_TTY | SOFT_KLS |SOFT_ASY | SOFT_PSP)
#else 
#define SOFT_ALL	(SOFT_CLOCK | SOFT_NET | SOFT_TTY)
#endif


#if defined(KERNEL) && !defined(LOCORE)
int	softlevel;

#define setsoftTTY() { softlevel |= SOFT_TTY; setsoftint(); }
#define setsoftKLS() { softlevel |= SOFT_KLS; setsoftint(); }
#define setsoftASY() { softlevel |= SOFT_ASY; setsoftint(); }
#define setsoftPSP() { softlevel |= SOFT_PSP; setsoftint(); }
#define setsoftclock() { softlevel |= SOFT_CLOCK;	\
	setsoftint();}/* set bit 22 in scr 12 (ie set the bit in the IRB */

#endif
