/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:sari.h 12.0$ */
/* $ACIS:sari.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/standca/RCS/sari.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidsari = "$Header:sari.h 12.0$";
#endif

/* sari.h -- standalone constants for the IBM RI */

#define CTL(x) ('x'&037)	/* get a control character */
#define min(x,y) x < y ? x : y
#define max(x,y) x > y ? x : y

#define IO_BASE 0xf0000000	       /* I/O base address */

#define in(port) * (( char *) (IO_BASE + (port)))
#define out(port,value) in(port) = value
 /* output a PC word (= short) */
#define inw(port) * (( short *) (IO_BASE + (port)))
#define outw(port,value) inw(port) = value

#define CRT_1 0x3b8		       /* crt port 1 */
#define PUT_SCR_REG(reg,value) out(0x3b4,reg); out(0x3b5,value);

#ifdef DEBUG
#define LOCAL			       /* make it external */
#else
#define LOCAL	static		       /* make it local */
#endif

#define    _CDB        0x8ce0	       /* Hex Display Register  */
