/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION  1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:fd.h 11.0$ */
/* $ACIS:fd.h 11.0$ */
/* $Source: /ibm/acis/usr/sys/standatr/RCS/fd.h,v $ */

#ifndef lint
static char *rcsidfd_atr = "$Header:fd.h 11.0$";
#endif

#define NFD	2
#define NFDST	4

#define	BSIZE	DEV_BSIZE
#define MAXTRANS (32 * 1024)	/* 32K max tranfser	*/

/* drive_status defines */	

#define	FD5LO	0x0000
#define	FD5HI	0x0001
#define	FD3LO	0x0002
#define	FD3HI	0x0003
#define FDWP    0x0100

struct partab {
	daddr_t len;		       	/* # of blocks in partition */
	int start;		       	/* starting cylinder of partition */
} fdinit_sizes[8] = {			/* default minimum drive */
	100, 0,		       		/* scratch area  */
	0, 0,		       		/* spare */
	0, 0,		       		/* spare */
	0, 0,		       		/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
},fd120_sizes[8] = {			/* 1.2 meg Diskette (5.25 inch) */
	2400, 0,		       	/* whole disk cyl   0 - 79 on (1.2M) */
	600, 19,		       	/* play area  cyl 601 - 1200 */
	600, 39,		       	/* play area  cyl 1201 - 1800 */
	600, 59,		       	/* play area  cyl 1801 - 2400 */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
},fd140_sizes[8] = {			/* 1.4 meg Diskette (3.5 inch) */
	2880, 0,		       	/* whole disk cyl   0 - 79 on (1.4M) */
	600, 19,		       	/* play area  cyl 601 - 1200 */
	600, 39,		       	/* play area  cyl 1201 - 1800 */
	600, 59,		       	/* play area  cyl 1801 - 2400 */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
},fd72_sizes[8] = {			/* 720K Diskette (3.5 inch) */
	1440, 0,		       	/* whole disk cyl   0 - 79 on (720K) */
	360, 19,		       	/* play area  cyl 361 - 720 */
	360, 39,		       	/* play area  cyl 721 - 1080 */
	360, 59,		       	/* play area  cyl 1081 - 1440 */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
},fd36_sizes[8] = {			/* 360K Diskette (5.25 inch) */
	720, 0,		       		/* whole disk cyl   0 - 40 on (360K) */
	90, 9,		       		/* play area  cyl 91 - 180 */
	90, 19,		       		/* play area  cyl 181 - 270 */
	90, 29,		       		/* play area  cyl 271 - 360 */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
	0, 0,			       	/* spare */
};

/*
 * Drive description table.
 * Returned from SAIODEVDATA call.
 */
struct fdst {
	short nsect;		       /* # sectors/track */
	short ntrak;		       /* # surfaces or heads */
	short nspc;		       /* # sectors/cylinder */
	short ncyl;		       /* # cylinders */
	short steprate;		       /* Minimum stepping rate */
	short precompcyl;	       /* Cylinder at which to start precomp */
	struct partab *off;	       /* partition offset table (cylinders) */
	char eot;		       /* End of Track */
	char gpl;		       /* Gap length */
	char step;		       /* Stepping rate and head unload time */
	char xfer;		       /* Data transfer rate */
} fdst[NFDST] = {
	/* 360K diskette in 1.2M drive */
	{ 9, 2, 2 * 9, 40, 0, 0, fd36_sizes, 0x09, 0x23, 0xe0, 0x01 },
	/* 1.2M diskette */
	{ 15, 2, 2 * 15, 80, 0, 0, fd120_sizes, 0x0f, 0x1b, 0x10, 0x00 },
	/* 720K diskette */
	{ 9, 2, 2 * 9, 80, 0, 0, fd72_sizes, 0x0f, 0x1b, 0x10, 0x00 },
	/* 1.4M diskette */
	{ 18, 2, 2 * 18, 80, 0, 0, fd140_sizes, 0x0f, 0x1b, 0x10, 0x00 },
};


struct pc_dpl fd_dpl[NFD];


