/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/*
 * $Header:kbd.h 12.0$
 * $ACIS:kbd.h 12.0$
 * $Source: /ibm/acis/usr/sys/os2code/RCS/kbd.h,v $
 * Copyright University of Southern California, 1988
 */

#define KBDIOCTL	0x04
#define KBD_INPUT_MODE	0x51
#define KBD_RAW_MODE	0x80
#define KBD_COOKED_MODE 0x00
#define KBD_GET_STATE	0x73
#define KBD_SET_STATE	0x53
#define KBD_SET_LED	0xed
#define KBD_PUT_LIGHTS(x,y)	(((x) & ~0x70) | (((y) & 7) << 4))
#define KBD_WAIT	0
#define KBD_NOWAIT	1


/* Quit Key sequence - detecting this causes a return from kbd_scan */
#define QUIT_SEQ_KEY	0x2e		/* C		*/

#define KBD_SLEEP	50L		/* milliseconds to wait between
					 * keystrokes. Must be a long.
					 */

/*  Keyboard Monitor Definitions */

#define KBD_DEVICE	"KBD$"

/* buffer for the keyboard monitor */

struct kbd_mon_buffer {
  struct kmonbuf {
	u_int	kbuf_mon_flag;
	struct KeyData kbuf_kd;
	u_int	kbuf_kbdDD_flag;
  }	kbuf;
  char	pad[30];	/* must provide a minimum buffer size */
};

#define mon_flag	kbuf.kbuf_mon_flag
#define key_data	kbuf.kbuf_kd
#define kbdDD_flag	kbuf.kbuf_kbdDD_flag

#define MON_BUF_SIZE	sizeof(struct kmonbuf)

/* masks for the mon_flag field */

#define MON_FLUSH	0x0004
#define MON_CLOSE	0x0002		/* not used */
#define MON_OPEN	0x0001		/* not used */

/* masks for the kbdDD_flag field */

#define MON_ACCENTED_MASK	0x0200
#define MON_MULTIMAKE_MASK	0x0100
#define MON_SECONDARY_MASK	0x0080
#define MON_KEY_BREAK_MASK	0x0040
#define MON_ACTION_MASK		0x003f


/* action field meanings */

#define MON_SHIFT_KEY	0x07
#define MON_PAUSE	0x08
#define MON_PSEUDO_P	0x09
#define MON_BREAK	0x11
#define MON_PSEUDO_BRK	0x12
#define MON_PRT_SCR	0x13
#define MON_PRT_ECHO	0x14
#define MON_PSEUDO_PRTE	0x15
#define MON_SYS_REQ	0x17	/* undefined in IBM OS/2 1.0 Technical 
				 * Reference manual (Vol 1) but
				 * used by IBM 0S/2 1.0 all the same
				 */
struct kbd_shift_state {
	u_int	shift_state;
	char	NLS;
};
