/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:ibm9332scsi.h 12.0$ */
/* $ACIS:ibm9332scsi.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/caio/RCS/ibm9332scsi.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidibm9332scsi = "$Header:ibm9332scsi.h 12.0$";
#endif

/* Completion codes sent in SCSI status byte (scsi_status) in scsidevice */
#define SCSI9332_GOOD	0x00	/* The target successfully completed the cmd */
#define SCSI9332_CHECK	0x02	/* Check Condition, abnormal condition */
				/* Sense data will then be available   */
#define SCSI9332_BUSY	0x08	/* Target is busy, can not accept command */
#define SCSI9332_INTER	0x14	/* Intermediate Interrupt */
#define SCSI9332_RESCFT	0x18	/* Reserve Conflict, reserved by another dev */

/* Number of Blocks Per Logical Unit on ibm9332 scsi drive */
#define SCSI9332_BPLUN	391182

/* Structure defines the format of the INQUIRY data returned from
 * a CMD_INQUIRY scsi cmd to the 9332.
 */
typedef struct SCSI_INQINFO {
	u_char inq_pdt;		/* Peripheral Device type */
	u_char inq_rmb:1;	/* Removal Media bit (1 == removable) */
	u_char inq_dtq:7;	/* Device Type Qualifier */
	u_char rsvd1:5;
	u_char inq_ansi:3;	/* Level of ANSI standard supported */
	u_char rsvd2:4;
	u_char inq_rdf:4;	/* Response Data Format */
	u_char inq_len;		/* Additional length of report */
	u_char pad[3];
	u_char inq_vid[8];	/* Vendor ID */
	u_char inq_pid[4];	/* Product ID */
	u_char inq_model[4];	/* Model number (See table in scsi.c) */
	u_char rsvd3[12];
	u_char inq_roslid[2];	/* ROS Load ID */
	u_char inq_rospl[2];	/* ROS Patch Level */
	u_char inq_rampl[2];	/* RAM Patch Level */
	u_char inq_ramuid[2];	/* RAM Ucode ID */
} scsi_inqinfo;

#define SCSI_INQLEN	((int)sizeof(struct SCSI_INQINFO))

/*
 * 9332 error codes
 */
#define	SCSI_9332_SERVO_LUN0	0x20
#define	SCSI_9332_SERVO_LUN1	0x40
#define	SCSI_9332_FILE_LUN0	0x10
#define	SCSI_9332_FILE_LUN1	0x11
#define	SCSI_9332_IP_PROC	0x08
