/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:nvram.h 12.0$ */
/* $ACIS:nvram.h 12.0$ */
/* $Source: /ibm/acis/usr/sys/ca/RCS/nvram.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidnvram = "$Header:nvram.h 12.0$";
#endif

#define NVR_ERROR_LOG	16
#define NVR_USAGE_LOG	10
#define NVR_IPL_SOURCE_TABLE 5
#define NVR_CONFIGURATION_DATA 10
#define NVR_DIALOG_STATUS	 1
#define NVR_SHUTDOWN_STATUS	 1
#define NVR_TIME_DATA	 2
#define NVR_VRM_IODNSZ	 2
#define NVR_ACIS	 1
#define NVR_CRC_CHECK_BYTES	 2

struct nvram {
	char	Error_log[NVR_ERROR_LOG];
	char	Usage_log[NVR_USAGE_LOG];
	char	IPL_source_table[NVR_IPL_SOURCE_TABLE];
	char	Configuration_data[NVR_CONFIGURATION_DATA];
	char	Dialog_status[NVR_DIALOG_STATUS];
	char	Shutdown_status[NVR_SHUTDOWN_STATUS];
	char	Time_data[NVR_TIME_DATA];
	char	VRM_IODN[NVR_VRM_IODNSZ];
	char	ACIS[NVR_ACIS];
	char	CRC_check_bytes[NVR_CRC_CHECK_BYTES];
};

#define NVR_ADDR	0xf000880e
#define _nvr		((struct nvram *) NVR_ADDR)

/* IPL source table codes */
#define NVR_FD0	0xf0
#define NVR_FD1	0xf1
#define NVR_FD2	0xf2
#define NVR_FD3	0xf3
#define NVR_HD0	0xd0
#define NVR_HD1	0xd1
#define NVR_HD2	0xd2
#define NVR_HD3	0xd3

/* Configuration data location defines */
#define NVR_SECURE	(_nvr->ACIS[0])

/* macros */
#define nvr_secure(type) /*set secure statuses in NVRAM */	\
	(( (! nvr_crc_ok()) ? (\
	_nvr->IPL_source_table[0]=NVR_FD0, \
	_nvr->IPL_source_table[1]=NVR_FD1, \
	_nvr->IPL_source_table[2]=NVR_HD0, \
	_nvr->IPL_source_table[3]=NVR_HD1, \
	_nvr->IPL_source_table[4]=NVR_HD2): 0), \
	NVR_SECURE=_nvr->IPL_source_table[1],\
	_nvr->IPL_source_table[1]=_nvr->IPL_source_table[0],\
	_nvr->IPL_source_table[0]= (char) type)
#define nvr_is_secure()	((NVR_SECURE) && (nvr_crc_ok())) 
#define nvr_release()	 /*clear secure statuses in NVRAM */	\
	( (NVR_SECURE) ? ( \
	_nvr->IPL_source_table[0]=_nvr->IPL_source_table[1], \
	_nvr->IPL_source_table[1]=NVR_SECURE, \
	NVR_SECURE=0 ) \
	: 0 )
#define nvr_set_crc(x)  /* set crc bits */	\
	 (_nvr->CRC_check_bytes[1] = x & 0xff, \
	  _nvr->CRC_check_bytes[0] = x >> 8 )
#define nvr_crc_ok()  /* check for valid crc bytes */ \
	(((_nvr->CRC_check_bytes[0] << 8) | \
            _nvr->CRC_check_bytes[1] ) == \
	    (crc_gen(_nvr,sizeof(struct nvram)-NVR_CRC_CHECK_BYTES) & 0xffff))

