/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS SPECIFIC TO THE
 * INTEL 80286 CPU AND MAY REQUIRE MODIFICATION
 * WHEN ADAPTING XENIX TO NEW HARDWARE.
 */

/*
**	MODIFICATION HISTORY
**	M000	09/05/85	lees
**	- Changed CLKONLY and PS_PRIMASK in line with change to
**	  special fully nested mode for interrupt handling.
**
*/

/*
 * Adjustable parameters
 */
#define	SSIZE	4096		/* initial stack size (bytes) */
#define	SINCR	1024		/* increment of stack (bytes) (not used)*/
#define	NOFILE	20		/* max open files per process */
#define	CANBSIZ	256		/* max size of typewriter line */
#define	HZ	50		/* Ticks/second of the clock */
#define	MSGBUFS	128		/* Characters saved from error messages */
#define	NCARGS	5120		/* # characters in exec arglist */
#define	MAXTTYS	16		/* Max # open ttys */
#define	NIOSTAT	50		/* max number of bufs to keep stats for */
#define	MAXPID	30000		/* max process id */
#define	MAXUID	60000		/* max user id */
#define	MAXLINK	1000		/* max links */
#define	CDLIMIT	(1L<<11)	/* default max write address */

#define MINBUF	40		/* minimum # of buffers */
#define KSSIZE	1024		/* kernel stack size */
#define OFFUSRPG 0		/* address of U page (for fpsup.s) */

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define	PSWP	0
#define	PINOD	10
#define	PRIBIO	20
#define	PZERO	25
#define	NZERO	20
#define PCATCH  0400
#define PMASK	0177	
#define	PPIPE	26
#define	PWAIT	30
#define	PSLEP	40
#define	PUSER	50
#define	PIDLE	127

/*
 * signals
 * dont change
 */

#define	NSIG	20
/*
 * No more than 32 signals (1-32) because they are
 * stored in bits in a long.
 */
#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (FS) */
#define	SIGILL	4	/* illegal instruction */
#define	SIGTRAP	5	/* trace or breakpoint */
#define	SIGIOT	6	/* iot */
#define	SIGEMT	7	/* emt */
#define	SIGFPE	8	/* floating exception */
#define	SIGKILL	9	/* kill, uncatchable termination */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad system call */
#define	SIGPIPE	13	/* end of pipe */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* Catchable termination */
#define	SIGUSR1	16	/* user defined signal 1 */
#define	SIGUSR2	17	/* user defined signal 2 */
#define	SIGCLD	18	/* child death */
#define	SIGPWR	19	/* power-fail restart */

#define	FSIG_DFL	((faddr_t) 0)
#define	FSIG_IGN	((faddr_t) 1)

/*
 * fundamental constants of the implementation--
 * cannot be changed easily
 */

#define	NBPW	sizeof(int)	/* number of bytes in an integer */
	/*
	 *      *** WARNING ***
	 * Some io devices may have a problem 
	 * if BSIZE is greater than MMPGSZ	
	 * If BSIZE changes, so must NSBFILL, BSHIFT,
	 * NSHIFT, LINOPB
         */
#define	BSIZE	1024		/* size of secondary block (bytes) */
#define	BSHIFT	10		/* LOG2(BSIZE) */
#define	BMASK	(BSIZE - 1)	/* BSIZE-1 */
#define	BSLOP	0		/* must be 0 for current copyio implemtation*/
#define	NINDIR	(BSIZE/sizeof(daddr_t))
#define	NSHIFT	8		/* LOG2(NINDIR) */
#define	NMASK	(NINDIR - 1)	/* NINDIR-1 */
#define	INOPB	(BSIZE/sizeof(struct dinode))	/* # inodes per block */
#define	LINOPB	4		/* LOG2(INOPB) */
#ifdef M_KERNEL
#define	NULL	0
#endif
#define	NODEV	(dev_t)(-1)
#define	ROOTINO	((ino_t)2)	/* i number of all roots */
#define	SUPERB	((daddr_t)1)	/* block number of the super block */
#define	DIRSIZ	14		/* max characters per directory */
#define	NICINOD	100		/* number of superblock inodes */
#define	NICFREE	100		/* number of superblock free blocks */
#define	NSBFILL	370		/* aligns s_magic & s_type at end of SB blk */

/*
 * MMU parameters.
 */

#define	MMPGSZ	512		/* bytes/page in the MMU */
#define	LMMPGSZ	9		/* log2(MMPGSZ) */
#define NPAGEPS	128		/* 64k/MMPGSZ = number of pages per segment */
#define MAXPAGES  32768L

/*
 * Some macros for units conversion
 */

/*
 * mem size to disk blocks and disk blocks to mem size.
 *	Assumes BSIZE and MMPGSZ are both powers of 2.
 */
/* #if BSIZE > MMPGSZ */
#define 	mstod(x)	( ((x) + ((BSIZE/MMPGSZ)-1)) / (BSIZE/MMPGSZ))
#define 	dtoms(x)	((x)*(BSIZE/MMPGSZ))
/* #else 
 * #define	mstod(x)	((x)*(MMPGSZ/BSIZE))
 * #define 	dtoms(x)	( ((x) + ((MMPGSZ/BSIZE)-1)) / (MMPGSZ/BSIZE))
 * #endif
 */

/* inumber to disk address */
#define	itod(x)	(daddr_t)(((unsigned)(x)+(INOPB+INOPB-1))>>LINOPB)

/* inumber to disk offset */
#define	itoo(x)	(int)(((x)+(INOPB+INOPB-1))&(INOPB-1))

/* mem size to bytes */
#define	mstob(x)	((x)<<LMMPGSZ)

/* bytes to mem size */
#define	btoms(x)      ((unsigned) (((long)(x) + (MMPGSZ-1)) >> LMMPGSZ))

/* address (long (32 bit)) to page number (int)*/
#define	atomlt(x)	((int)(((paddr_t)(x))>>LMMPGSZ))

/* address (long (32 bit)) to page count (int)*/
#define	atoml(x)	((int)(((paddr_t)(x)+(MMPGSZ-1))>>LMMPGSZ))

/* address (long (32 bit)) to offset (int) get bits LMMPGSZ-1 - 0 */
#define	atoo(x)		((int)((x)&(MMPGSZ-1)))

/* far pointer (faddr_t) to segment (int) (get high 16 bits of faddr_t) */
#define	ftoseg(x)		((unsigned) ((long) (x) >> 16))

/* far pointer (faddr_t) to offset (int) (get low 16 bits of faddr_t) */
#define	ftooff(x)		((unsigned) (x))

/* seg off to far pointer (faddr_t) */
#define sotofar(seg, off) \
	(((faddr_t) (((long)(unsigned) (seg)) << 16)) + (unsigned) (off))

/* when sotofar() is used to set up an (faddr_t) parameter to a function call */
#define FADDR(seg, off)		off, seg

/* real mode far pointer to physical address */
#define ftop(f) \
	((paddr_t) ((((long) (f) >> 12) & 0x000ffff0L) + (ushort) (f)))

/* real mode seg, off to physical address */
#define sotop(seg, off) \
	((((paddr_t) (ushort) (seg)) << 4) + (ushort) (off))

/* physical address to real mode seg, off */
#define ptoseg(p)	((ushort) ((p) >> 4))
#define ptooff(p)	((ushort) (p) & 0x000f)

/* physical address to real mode far pointer */
#define ptofar(p) \
	(((faddr_t) (((long) (p) << 12) & 0xffff0000L)) + ptooff(p))

/* selector number to table index */
#define stoi(sel)		((sel)/SELSZ)

/* Memory location to logical address */
#define mltoa(x) ((paddr_t) (x) << LMMPGSZ)

/* High word of a long */
#define HIGHWORD(x)	((int)((long)x >> 16))

/* low word of a long */
#define LOWWORD(x)	((int)x)

/* physical to kernel logical (only the low 16 bits count) */
#define ptok(x) ((caddr_t)((unsigned) x - (unsigned) kmemstart))

/* kernel logical to physical */
#define ktop(x) ((paddr_t)(unsigned) x + kmemstart)

/* true if bp is not mapped out */
#define issabuf(bp)	(bp->b_paddr<=(paddr_t)ktop((unsigned)sabuf[v.v_sabuf]))

#define lobyte(X)	(((unsigned char *)&X)[0])
#define hibyte(X)	(((unsigned char *)&X)[1])

#ifdef M_KERNEL
#include	"types.h"
#endif

extern paddr_t kmemstart;	/* set by init code, passed in from /boot */


/*
 * Machine-dependent bits and macros
 */

#define SPL0MASK        0x00            
#define USERMODE(ps)	((ps)&PS_USER)
						/* M000 */
#define CLKONLY(ps)     ((ps)&PS_PRIMASK)
#define copypsize(rpp,rip)	rpp->p_usize = rip->p_usize; \
				rpp->p_lsize = rip->p_lsize

#define	USRSTACK	u.u_stkbot
#define	URSBC		0		/* User stk Reg Save area Byte Cnt */
#define SHWDSZ          (sizeof(int)+6) /* space on user stack for shell word */
#define PTRSIZE(f)	((f)? sizeof(faddr_t) : sizeof(caddr_t))

/*
 * 286 simulated "state" definitions.
 */

#define	PS_USER		0x01		/* "user" mode */
						/* M000 */
#define	PS_PRIMASK	0x0100		/* last priority was not spl0 */

/* Conditional compilation */
#define	PAGEMMU				/* mmu is divided in pages */
#define	SHORTINT			/* sizeof(int)==sizeof(short) */
/*#define	BYTESWAP*/		/* byte ordering is opposite that of pdp11
/*#define       OLDFORK*/               /* return to parent by bumping pc by 2 */
#define       FIXEDSTACK                /* stack cannot grow */
#define       BUFMAPOUT                 /* buffers are mapped out */
/*#define LARGECODE*/                   /* kernel supports multisegment code */

#define UNOTMAPPED			/* upage copied in on context switch */
