/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * mmu.h
 *	Memory Management Definitions
 *
 * used by mmu.c
 * param.h has basic page-size/etc definitions.
 *
 * definitions for 286 memory managment model
 */

/*
 *	MODIFICATION HISTORY
 *	M000	07/31/85	lees
 *	- Added LT_CONTIG for proctl().
 *	M001	10/31/85	lees
 *	- Added LT_FCONTIG for proctl().
 */
/*
 * descriptor table defines
 * NOTE: the RPL in USEG_SEL and ULDT_SEL is 0. This
 *	 does not ENFORCE protection
 */
#define	NULL_SEL	0	/* 'invalid' selector */
/* 
 * portable gdt defines
 * WARNING - these must agree with the layout of the gdt in oem.c
 */
#define	GDT_SEL		0x8	/* selector for GDT alias */
#define	IDT_SEL		0x10	/* selector for IDT alias */
#define KDS_SEL		0x18	/* Kernel data seg selector */
#define	KCS_SEL		0x28	/* Kernel code seg selector for SEG 1 */
#define	KSS_SEL		0x48	/* Kernel stack seg selector */
#define	KTSS		0x50	/* Kernel TSS selector */
#define	KTSS_SEL	0x58	/* Kernel TSS alias selector */
#define	KWORK0		0x60	/* work segment selector */
#define	KWORK1		0x68	/* work segment selector */
#define	KWORK2		0x70	/* work segment selector */
#define	MAPWKSEL	0x78	/* selector for map work */
#define COPY_SEL	0x80	/* selector for copyio */
#define	CLDT_SEL	0x88	/* current process' ldt selector */
#define	KENTRY		0x90	/* kernel entry selector (call gate) */
#define BUF_SEL		0x98	/* selector for mapped out bufers */
#define BUF2_SEL	0xA0	/* selector for mapped out bufers */
#define BUF3_SEL	0xA8	/* selector for mapped out bufers */
#define	SWAP1_SEL	0xB0	/* work segment selector - swap */
#define	SWAP2_SEL	0xB8	/* work segment selector - swap */
#define	SWAP3_SEL	0xC0	/* work segment selector - swap */
#define	SWAP4_SEL	0xC8	/* work segment selector - swap */
#define FREE_SEL	0xD0	/* first selector in the pool of oem selectors*/

/* 
 * ldt defines 
 * These selector definitions should not be touched - they are chip
 * and linker defined
 */
#define	USEG_SEL	0x04	/* LDT based U seg selector */
#define	ULDT_SEL	0x0C	/* ldt based, ldt alias */
#define	ULINFO_SEL	0x14	/* used for ldt info array */
#define UEXEC_SEL	0x1C	/* used during an exec */
#define	ULDTTMP_SEL	0x24	/* used for execing and in mmu routines */
#define	UTEMP_SEL	0x2C	/* used for swapping, etc */
#define	UOVRLY_SEL	0x34	/* used with overlay files */
#define	FIRSTU_SEL	0x3F	/* user's initial selector */

#define NCSEGS		5	/* number of text segments the kernel may have*/
#define LDTPAD		10	/* number extra ldt slots allocated per proc */					/* size of an ldt entry in bytes (8) */
#define SELSZ		sizeof(struct desctab)
#define MAXLDT		8192	/* maximum number of entries in an ldt */
#define KERNLDT	 	7	/* number of kernel reserved ldts */

#define IDTSZ		256			/* number of entries in idt */
#define TSSSZ		22			/* number of entries in tss */
#define IDTLIM		(IDTSZ * SELSZ) -1	/* idt limit */
#define TSSLIM		(TSSSZ * SELSZ) -1 	/* tss limit */

/*
 * Descriptor Types
 */
#define	DST_ATASK	0x1	/* avail task */
#define	DST_TABLE	0x2	/* descriptor table */
#define	DST_BTASK	0x3	/* busy task */
#define	DST_CGATE	0x4	/* call gate */
#define	DST_TAGATE	0x5	/* task context gate */
#define	DST_IGATE	0x6	/* interrupt gate */
#define	DST_TRGATE	0x7	/* trap gate */


#include "relsym86.h"

/*
 * access byte fields (DSA_*) are defined in relsym86.h
 */

/*
 * flag register bits
 */
#define	FL_NCX		0x4000	/* nested context */
#define	FL_IOPL		0x3000	/* I/O priv level */
#define	FL_OFLOW	0x800	/* overflow bit */
#define	FL_DIR		0x400	/* direction of string ops */
#define	FL_INTEN	0x200	/* interrupt enable */
#define	FL_TRAP		0x100	/* single step flag */
#define	FL_SIGN		0x80	/* sign bit */
#define	FL_ZERO		0x40	/* zero bit */
#define	FL_AUXCARRY	0x10	/* auxillary carry */
#define	FL_PARITY	0x4	/* parity bit */
#define	FL_CARRY	0x1	/* carry bit */

/*
 * parts of a selector see relsym86.h
 */
#define	SEL_TI		SEL_LDT	/* table indicator (0-gdt,1-ldt) */

/*
 * descriptor table structure: see relsym86.h
 */
#define NPSEGM	0		/* no segments */

/*
 * Misc constants.
 */
#define OFFMASK	(MMPGSZ-1)	/* develop offset within page from addr */

#define RO (DSA_CODE|DSA_RING3) /* tells mmuset to setup code to make */
#define RW (DSA_DATA|DSA_RING3) /* kernel access read-only, or rd/wr */

#define	MMUOK	((mloc_t) 0)
#define	MMUERR	((mloc_t) -1)

struct ldtinf {
	unsigned short flag;
	union {
		unsigned short psize;	/* used for exec */
		unsigned short swapbn;	/* block # on swapper */
		unsigned short dupsel;	/* sel this sel is dup of, if LT_DUP */
	} si;
};

/* 
 * ldtinf flag values indicating the type of segment represented
 */

#define LT_OWN		0x0001		/* maps user-owned, private memory */
#define LT_ALLOC	0x0002		/* swapper must allocate mem for exec */
#define LT_EXPAND	0x0004		/* expanding segment -used by swapper */
#define LT_ITER		0x0008		/* iterated data or text segment */
#define LT_SD		0x0010		/* shared data segment */
#define LT_ABS		0x0020		/* maps fixed location (i.e. screen) */
					/*  or maps contiguous memory which  */
					/*  was allocated via proctl().      */
#define LT_DUP		0x0040		/* duplicate mapping */
#define LT_EXEC		0x0080		/* executable segment */
#define LT_RO		0x0100		/* read-only segment */
#define LT_HUGE		0x0200		/* allocated as HUGE seg by brkctl */
#define LT_CONTIG	0x0400		/* maps a segment in a series */
					/*  of physically contiguous segments */
#define LT_FCONTIG	0x0800		/* first in a series of physically */
					/* contiguous segments */

extern fdesc_t *ldt;			/* ULDT_SEL:0 */
#define	flinf_t		struct ldtinf far	/* far ldt info array entry */
extern flinf_t *ldtinfo;		/* ULINFO_SEL:0 */
#ifndef NOEXTGDT			/* see comment in oem.c */
extern struct desctab gdt[];
#endif

extern mloc_t mmupget();
extern mloc_t mmuget();

/*
 * LDTDESCR initializes an ldt entry
 */
#define LDTDESCR(sel, addr, limit, access)	\
if (1) {					\
	int xacc = access;			\
	fdesc_t *_p = &ldt[sel/SELSZ];		\
	_p->d_limit = limit;			\
	_p->d_paddr = addr;			\
	_p->d_acc = xacc;			\
} else

/*
 * GDTDESCR initializes a gdt entry
 */
#define GDTDESCR(sel, addr, limit, access)	\
if (1) {					\
	int xacc = access;			\
	struct desctab *_p = &gdt[sel/SELSZ];	\
	_p->d_limit = limit;			\
	_p->d_paddr = addr;			\
	_p->d_acc = xacc;			\
} else
