/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 *	%Z% %M% %I% %D% %Q%
 */




/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */


/*
 *	MODIFICATION HISTORY
 *
 *	M000	03/26/85	lees
 *	- Added support for System V fcntl and lockf (V2).
 *
 */

/*
 *   Flag values for locking system call (sys/sys/locking.c)
 */

#include "lockcmn.h"

#define LK_UNLCK  CMN_UNLCK	/* unlock request */
#define LK_LOCK   CMN_WRLCK	/* lock request */
#define LK_NBLCK  2		/* non-blocking lock request */
#define LK_RLCK   CMN_RDLCK	/* read permitted only lock request */
#define LK_NBRLCK 4		/* non-blocking read only lock request */
					/* M000 */
#define LK_GETLK  5		/* V2 request to find first blocking lock */
#define LK_SETLK  6		/* V2 non-blocking lock request */
#define LK_SETLKW 7		/* V2 blocking lock request */
#define LK_TESTLK 8		/* V2 request to test for locks */

#ifdef M_KERNEL

struct locklist {
	    /* NOTE: ll_link must be first in struct */
	struct locklist	*ll_link;	/* link to next lock region */
	ushort  	ll_flags;	/* misc flags ** sleeping */
	struct proc	*ll_proc;	/* process which owns region */
	off_t		ll_start;	/* starting offset */
	off_t		ll_end;		/* ending offset, zero is eof */
};

extern struct locklist locklist[]; /* The lock table itself */

/* ll_flags */
#define LROLOCK   01	/* record is locked & is read only */

#define	MAXLOCKSZ ((off_t) (1L << 30))

/* flags for the locked() routine. */
#define BLOCK		0	/* M007 */
#define RDLOCK  	1	/* M007 */
#define NBLOCK  	2	/* M007 */
#define NBRDLOCK	3	/* M007 */
#define TESTLK  	4	/* M007 */
#define GETLK		5	/* M007 */

#endif
