/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/***	errno.h
 *
 *	Error codes
 *
 *	MODIFICATION HISTORY
 *	M000	07 Apr 83	andyp	3.0 upgrade
 *	- Merged XENIX and 3.0 errors.
 *	M001	17 Aug 83	andyp
 *	- Added EISNAM.
 *	M002	12 Nov 84	lees
 *	- Added ENOMSG and EIDRM.
 */

#define	EPERM	1	/* Not super-user			*/
#define	ENOENT	2	/* No such file or directory		*/
#define	ESRCH	3	/* No such process			*/
#define	EINTR	4	/* interrupted system call		*/
#define	EIO	5	/* I/O error				*/
#define	ENXIO	6	/* No such device or address		*/
#define	E2BIG	7	/* Arg list too long			*/
#define	ENOEXEC	8	/* Exec format error			*/
#define	EBADF	9	/* Bad file number			*/
#define	ECHILD	10	/* No children				*/
#define	EAGAIN	11	/* No more processes			*/
#define	ENOMEM	12	/* Not enough core			*/
#define	EACCES	13	/* Permission denied			*/
#define	EFAULT	14	/* Bad address				*/
#define	ENOTBLK	15	/* Block device required		*/
#define	EBUSY	16	/* Mount device busy			*/
#define	EEXIST	17	/* File exists				*/
#define	EXDEV	18	/* Cross-device link			*/
#define	ENODEV	19	/* No such device			*/
#define	ENOTDIR	20	/* Not a directory			*/
#define	EISDIR	21	/* Is a directory			*/
#define	EINVAL	22	/* Invalid argument			*/
#define	ENFILE	23	/* File table overflow			*/
#define	EMFILE	24	/* Too many open files			*/
#define	ENOTTY	25	/* Not a typewriter			*/
#define	ETXTBSY	26	/* Text file busy			*/
#define	EFBIG	27	/* File too large			*/
#define	ENOSPC	28	/* No space left on device		*/
#define	ESPIPE	29	/* Illegal seek				*/
#define	EROFS	30	/* Read only file system		*/
#define	EMLINK	31	/* Too many links			*/
#define	EPIPE	32	/* Broken pipe				*/

/* math software */
#define	EDOM	33	/* Math arg out of domain of func	*/
#define	ERANGE	34	/* Math result not representable	*/

#define	EUCLEAN	35	/* File system needs cleaning		*//*M000*/
#define	EDEADLOCK	36	/* Would deadlock		*//*M000*/
#define	EDEADLK	EDEADLOCK	/* Would deadlock		*//*M000*/
#define	ENOTNAM	37	/* Not a name file			*//*M000*/
#define	ENAVAIL	38	/* Not available			*//*M000*/
#define	EISNAM	39	/* Is a name file			*//*M001*/
#define EREMOTEIO 40
#define EINIT	41
#define EREMDEV 42
#define ENOMSG  43	/* M000 */
#define EIDRM   44	/* M000 */
#define ENOLCK  45	/* M001 */
