/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/***	stdio.h
 *
 *	MODIFICATION HISTORY
 *	M000	07 Apr 83	andyp	3.0 upgrade
 *	- Changed getc(), putc() to deal with sign extension problems.
 *	  Added documentation headers.
 *	- Propagated () to macro args to avoid precedence problems.
 *	- Removed 3.0 vax-specific code.
 *	M001	14 Mar 85	ncm	5.0 upgrade
 *	- Added line buffering defines. 
 */

#define	BUFSIZ	512
#define	_NFILE	20
#ifndef	FILE
extern	struct _iobuf {
	unsigned char	*_ptr;
	int	_cnt;
	unsigned char	*_base;
	char	_flag;
	char	_file;
} _iob[_NFILE];
#endif

/* Buffer size for multi-character output to unbuffered files */
#define _SBFSIZ 8

/*
 * _IOLBF means that a file's output will be buffered line by line
 * In addition to being flags, _IONBF, _IOLBF and _IOFBF are possible
 * values for "type" in setvbuf.
 */
#define _IOFBF		0000
#define	_IOREAD		01
#define	_IOWRT		02
#define	_IONBF		04
#define	_IOMYBUF	010
#define	_IOEOF		020
#define	_IOERR		040
#define _IOLBF		0100
#define	_IORW		0200

#define	NULL	(char *) 0
#define	FILE	struct _iobuf
#define	EOF	(-1)

#define	stdin	(&_iob[0])
#define	stdout	(&_iob[1])
#define	stderr	(&_iob[2])

#define _bufend(p)	_bufendtab[(p)->_file]
#define _bufsiz(p)	(_bufend(p) - (p)->_base)

/***	getc -- get character from a stream.
 *
 *	return character on success.  return EOF on end of file or
 *	error.
 *
 *	int getc(stream)
 *	FILE  *stream;
 */
#ifndef	M_LINT

#define	getc(p)		(			\
	--(p)->_cnt >= 0 ?			\
	(0xff & (int) (*(p)->_ptr++)) :		\
	_filbuf(p)				\
)
#define	getchar()	getc(stdin)

/***	putc -- put character on a stream.
 *
 *	return character on success.  return EOF on error.
 *
 *	int putc(ch, stream)
 *	char  ch;
 *	FILE  *stream;
 */
#define	putc(c, p)	(			\
	--(p)->_cnt >= 0 ?			\
	(0xff & (int) (*(p)->_ptr++ = (c))) :	\
	_flsbuf((c), (p))			\
)
#define	putchar(c)	putc(c, stdout)

#define clearerr(p)	((void) ((p)->_flag &= ~(_IOERR | _IOEOF)))
#define	feof(p)		(((p)->_flag&_IOEOF)!=0)
#define	ferror(p)	(((p)->_flag&_IOERR)!=0)
#define	fileno(p)	(p)->_file

#endif	/* M_LINT */

extern	FILE	*fopen(), *fdopen(), *freopen(), *popen(), *tmpfile();
extern	char	*fgets(), *gets(), *ctermid(), *cuserid();
extern	char	*tempnam(), *tmpnam();
extern	void	rewind(), setbuf();
extern	long	ftell();
extern	unsigned char	*_bufendtab[];

#define	L_ctermid	9
#define	L_cuserid	9
#define P_tmpdir	"/usr/tmp/"
#define L_tmpnam	(sizeof(P_tmpdir) + 15)
#define	LFNMAX		15		/* max len for filename */
#define	LPNMAX		128		/* (practical) max len for pathname */
