  Syntax10.Scn.Fnt  u ]  ParcElems Alloc     
 +6      ևԒҝШϳ;    Syntax10i.Scn.Fnt         StampElems Alloc 7 Jun 94                  2                c   Y    8  FoldElems New     8       8   9    8   2    8   )    8       8   %    8       8   4    8       8   )    8   3    8   t   8   $    8      8   &    8      8       8       8   h    8      8   H    8   o   8   ?    8      8   %    8      8   .    8      8   *    8      8   D    8      8   .    8      8      Syntax10b.Scn.Fnt          8   x   8               8      8               8      8       8   *    8       >T  MODULE CLChecker;	(* sg 11. Oct 93,  *)
(* 28.Oct: removed bus parameters from Generate and Input since always NIL *)
(* 5.Nov: changed ShowForm to show shared subcircuits repeatedly *)
(* 5.Nov: changed Reorder to detect loops *)
(* 8.Nov: Reorder/ShowForm check for dummy variables (introduced through cycle) *)
(* 6.Dec: New error message interface *)
(* 24.Dec: OR can be now implemented with a MUX *)
(* 3.Jan: CheckAll calls Extractor.Init inside loop, since nodes are rearranged in Reorder *)
(* 20.Jan: Added constant and unused variable removing (Reduce) *)
(* 20.Jan: AND can be now implemented with a MUX *)
(* 25.Jan: added Simplify *)
(* 7.Apr: adaption to new Lola *)
(* 8.Apr: removed Simplify. Now done by LSD *)
(* 14.Apr: added LSD.org as parameter to LSD.This, changed LSD.Bus to LSD.TS, shml *)
(* 3.May: variables = NIL, = LSD.zero, = LSD.one are ignored during checking *)
(* 4.May: sr nodes are now checked *)
(* 18.May: variable xxx' is considered equal to ~xxx and vice-versa *)

IMPORT Texts, Viewers, Oberon, CLFramesD, Extractor := CLExtractor, LSD, CLLola;

CONST
	(* constants defined in LSD *)
	or = LSD.or; xor = LSD.xor; and = LSD.and; not = LSD.not; mux = LSD.mux; mux1 = LSD.mux1;
	reg = LSD.reg; latch = LSD.lch; tsc = LSD.tsc; ts = LSD.ts; sr = LSD.sr; sr1 = LSD.sr1; occ = LSD.occ;

	(* error codes *)
	NoViewer = 21; NoSpecVar = 22; NoImplVar = 23; UndefVar = 24; Cycle = 25; Names = 26;
	NotEnd = 27; End = 28; VarExp = 29; ZeroExp = 30; OneExp = 31;

	Version = "CLChecker sg 18. May 94";

VAR
	errU, errV : INTEGER;
	ok : BOOLEAN;
	W : Texts.Writer;

(* output *)

PROCEDURE Str (s : ARRAY OF CHAR);
BEGIN
	Texts.WriteString (W, s)
END Str;

PROCEDURE Char (ch : CHAR);
BEGIN
	Texts.Write (W, ch)
END Char;

PROCEDURE Append;
BEGIN
	Texts.Append (Oberon.Log, W.buf)
END Append;

PROCEDURE Ln;
BEGIN
	Texts.WriteLn (W); Append
END Ln;

PROCEDURE Err (errNo : SHORTINT; s : LSD.Signal);
VAR u, v, sig : SHORTINT;
BEGIN
	IF (s = LSD.zero) OR (s = LSD.one) THEN u := -1; v := -1; sig := -1
	ELSE u := s.u; v := s.v; sig := s.val
	END;
	IF ok THEN
		ok := FALSE; errU := u; errV := v;
		Append; (* flush buffer before extractor writes to log *)
		CASE errNo OF
			not				:	Extractor.ErrMsg ("negation mismatch", u, v, sig)
		|	and				:	Extractor.ErrMsg ("AND expected", u, v, sig)
		|	or				:	Extractor.ErrMsg ("OR expected", u, v, sig)
		|	xor				:	Extractor.ErrMsg ("XOR expected", u, v, sig)
		|	mux				:	Extractor.ErrMsg ("MUX expected", u, v, sig)
		|	reg				:	Extractor.ErrMsg ("REG expected", u, v, sig)
		|	latch				:	Extractor.ErrMsg ("LATCH expected", u, v, sig)
		|	sr				:	Extractor.ErrMsg ("SR expected", u, v, sig)
		|	tsc				:	Extractor.ErrMsg ("tristate expected", u, v, sig)
		|	NoViewer		:	Extractor.ErrMsg ("no or wrong viewer selected", u, v, sig)
		|	NoSpecVar		:	Extractor.ErrMsg ("no such variable in LSD structure", u, v, sig)
		|	NoImplVar		:	Extractor.ErrMsg ("no such variable in design", u, v, sig)
		|	UndefVar		:	Extractor.ErrMsg ("variable has no assigned function in LSD structure", u, v, sig);
		|	Cycle				:	Extractor.ErrMsg ("cycle detected (break cycle with variable)", u, v, sig)
		|	Names			:	Extractor.ErrMsg ("variable names do not match", u, v, sig)
		|	NotEnd			:	Extractor.ErrMsg ("unexpected end of formula", u, v, sig)
		|	End				:	Extractor.ErrMsg ("end of formula expected here", u, v, sig)
		|	VarExp			:	Extractor.ErrMsg ("variable expected", u, v, sig)
		|	ZeroExp			:	Extractor.ErrMsg ("'0 expected", u, v, sig)
		|	OneExp			:	Extractor.ErrMsg ("'1 expected", u, v, sig)
		END
	END
END Err;

PROCEDURE ShowOp (s : LSD.Signal);
BEGIN
	IF s IS LSD.Variable THEN LSD.WriteName (W, s(LSD.Variable))
	ELSE
		CASE s.fct OF
			not		:	Char ("~")
		|	and		:	Char ("*")
		|	or		:	Char ("+")
		|	xor		:	Char ("-")
		|	mux		:	Char (":")
		|	mux1	:	Char (",")
		|	reg		:	Char ("^")
		|	latch		:	Char ("$")
		|	sr		:	Char ("%")
		|	sr1		:	Char ("~")
		|	ts		:	Char ("|")
		|	tsc		:	Char (".")
		|	occ		:	Char (".")
		END
	END
END ShowOp;

PROCEDURE ShowForm (s : LSD.Signal);
CONST Flag = 50;
BEGIN
	IF s # NIL THEN
		IF s.val >= 0 THEN
			DEC (s.val, Flag);
			IF s IS LSD.Variable THEN ShowOp (s)
			ELSE (* omit parantheses around mux1 and tsc *)
				IF (s.fct # mux1) & (s.fct # tsc) THEN Char ("(") END;
				ShowForm (s.x);
				ShowOp (s);
				ShowForm (s.y);
				IF (s.fct # mux1) & (s.fct # tsc) THEN Char (")") END
			END;
			INC (s.val, Flag)
		ELSE Char ("@")
		END
	END
END ShowForm;

(* formula matching *)

PROCEDURE Transform (s, x, y : LSD.Signal; f : INTEGER) : LSD.Signal; (* transform a mux into "or_and" tree *)
VAR n : LSD.Signal;
BEGIN
	n := CLLola.Or (CLLola.And (x, CLLola.Not (s)), CLLola.And (s, y));
	IF f = xor THEN n.fct := xor END;
	RETURN n
END Transform;

PROCEDURE NameMatch (var1, var2 : LSD.Variable; negMatch : BOOLEAN; VAR inverted : BOOLEAN) : BOOLEAN;
VAR name1, name2 : ARRAY 32 OF CHAR; i : INTEGER;
BEGIN
	CLLola.Lookup (var1, name1); CLLola.Lookup (var2, name2);
	IF name1 = name2 THEN inverted := ~negMatch; RETURN negMatch
	ELSE
		i := 0;
		WHILE (name1[i] # 0X) & (name1[i] = name2[i]) DO INC (i) END;
		IF (name1[i] = 0X) & (name2[i] = "'") THEN inverted := negMatch; RETURN ~negMatch
		ELSIF (name1[i] = "'") & (name2[i] = 0X) THEN inverted := negMatch; RETURN ~negMatch
		ELSE inverted := FALSE; RETURN FALSE
		END
	END
END NameMatch;

PROCEDURE Compare (n1, n2 : LSD.Signal; negmatch : BOOLEAN) : BOOLEAN;
VAR
	res, r : BOOLEAN;
	s, t, sub1, sub2 : LSD.Signal;
BEGIN
	res := FALSE;
	IF n1.fct IN {not, sr1} THEN negmatch := ~negmatch; n1 := n1.y END; (* skip negations *)
	IF n2.fct IN {not, sr1} THEN negmatch := ~negmatch; n2 := n2.y END;
	IF (n1 IS LSD.Variable) & (n2 IS LSD.Variable) THEN
		res := NameMatch (n1(LSD.Variable), n2(LSD.Variable), negmatch, r)
	ELSIF ~(n1 IS LSD.Variable) & ~(n2 IS LSD.Variable) THEN
		IF n1.fct = n2.fct THEN
			IF n1.fct = sr THEN
				IF negmatch THEN RETURN Compare (n1.x, n2.x, TRUE) & Compare (n1.y, n2.y, TRUE)
				ELSE RETURN Compare (n1.x, n2.y, TRUE) & Compare (n1.y, n2.x, TRUE)
				END
			ELSIF ~negmatch THEN
				RETURN FALSE
			ELSIF n1.fct IN {and, or, xor} THEN
				s := n2;
				REPEAT (* n1.fct = s.fct *)						(* search as if in a linear list *)
					res := Compare (n1.x, s.x, TRUE);
					IF ~res THEN s := s.y END					(* no problem, since graph has no cycles *)
				UNTIL res OR (s.fct # n1.fct);
				IF res THEN
					t := n2.x; n2.x := s.x; s.x := t;				 (* put matching nodes at same place in trees *)
					IF (n1.y # NIL) & (n2.y # NIL) THEN RETURN Compare (n1.y, n2.y, TRUE)
					ELSE RETURN ((n1.y = NIL) & (n2.y = NIL))
					END
				ELSIF Compare (n1.x, s, TRUE) THEN
					t := s; s := n2; WHILE s.y # t DO s := s.y END;
					t := n2.x; n2.x := s.y; s.y := t;				 (* put matching nodes at same place in trees *)
					RETURN Compare (n1.y, n2.y, TRUE)
				END
			ELSIF n1.fct = tsc THEN
				res := TRUE; sub1 := n1; sub2 := n2; (* sub1/sub2: insertion location for matching trees *)
				REPEAT (* n1 # NIL, n2 # NIL *)
					REPEAT (* find a matching subtree *)
						r := Compare (n1.x, n2.x, TRUE);
						IF ~r THEN n2 := n2.y END
					UNTIL r OR (n2 = NIL);
					IF r THEN (* match: put matching subtrees at same place in trees *)
						t := sub1.x; sub1.x := n1.x; n1.x := t; sub1 := sub1.y;
						t := sub2.x; sub2.x := n2.x; n2.x := t; sub2 := sub2.y
					ELSE res := FALSE (* at least one n1 subtree did not match *)
					END;
					n1 := n1.y; n2 := sub2
				UNTIL (n1 = NIL) OR (n2 = NIL);
				RETURN res
			ELSIF n1.fct = mux THEN
				IF Compare (n1.x, n2.x, TRUE) THEN
					res := Compare (n1.y.x, n2.y.x, TRUE) & Compare (n1.y.y, n2.y.y, TRUE)
				ELSIF Compare (n1.x, n2.x, FALSE) THEN (* negated mux selector *)
					res := Compare (n1.y.x, n2.y.y, TRUE) & Compare (n1.y.y, n2.y.x, TRUE);
					IF res THEN
						n2.x := CLLola.Not (n2.x); (* negate selector *)
						t := n2.y.x; n2.y.x := n2.y.y; n2.y.y := t; (* swap inputs *)
					END
				END;
				RETURN res
			END (* ELSE compare sub-trees (see below) *)
		ELSIF (n1.fct = mux) & (n2.fct IN {or, xor, and}) THEN (* mux as or-and *)
			RETURN Compare (Transform (n1.x, n1.y.x, n1.y.y, n2.fct), n2, negmatch)
		ELSIF n1.fct = or THEN
			IF negmatch THEN
				IF n2.fct = mux THEN (* OR with mux *)
					IF n2.y.y = LSD.one THEN
						IF Compare (n1.x, n2.x, TRUE) THEN RETURN Compare (n1.y, n2.y.x, TRUE)
						ELSIF Compare (n1.x, n2.y.x, TRUE) THEN
							t := n2.x; n2.x := n2.y.x; n2.y.x := t; (* not very clean... *)
							RETURN Compare (n1.y, n2.y.x, TRUE)
						ELSE RETURN FALSE
						END
					ELSIF n2.y.x = LSD.one THEN (* inverted selector *)
						IF Compare (n1.x, n2.x, FALSE) THEN RETURN Compare (n1.y, n2.y.y, TRUE)
						ELSIF Compare (n1.x, n2.y.y, TRUE) THEN
							t := CLLola.Not (n2.x); n2.x := CLLola.Not (n2.y.y); n2.y.y := t; (* not very clean... *)
							RETURN Compare (n1.y, n2.y.y, TRUE)
						ELSE RETURN FALSE
						END
					END
				ELSE RETURN FALSE
				END;
			ELSIF n2.fct # and THEN RETURN FALSE (* DeMorgan does not apply *)
			END
		ELSIF n1.fct = and THEN
			IF negmatch THEN
				IF n2.fct = mux THEN (* AND with mux *)
					IF n2.y.x = LSD.zero THEN
						IF Compare (n1.x, n2.x, TRUE) THEN RETURN Compare (n1.y, n2.y.y, TRUE)
						ELSIF Compare (n1.x, n2.y.y, TRUE) THEN
							t := n2.x; n2.x := n2.y.y; n2.y.y := t; (* not very clean... *)
							RETURN Compare (n1.y, n2.y.y, TRUE)
						ELSE RETURN FALSE
						END
					ELSIF n2.y.y = LSD.zero THEN
						IF Compare (n1.x, n2.x, FALSE) THEN RETURN Compare (n1.y, n2.y.x, TRUE)
						ELSIF Compare (n1.x, n2.y.x, TRUE) THEN
							t := CLLola.Not (n2.x); n2.x := CLLola.Not (n2.y.x); n2.y.x := t; (* not very clean... *)
							RETURN Compare (n1.y, n2.y.x, TRUE)
						ELSE RETURN FALSE
						END
					END
				ELSE RETURN FALSE
				END;
			ELSIF n2.fct # or THEN RETURN FALSE (* DeMorgan does not apply *)
			END
		ELSE
			RETURN FALSE
		END;
		IF Compare (n1.x, n2.x, negmatch) THEN RETURN Compare (n1.y, n2.y, negmatch)
		ELSIF (n1.fct IN {and, or, xor}) & ~Compare (n1.y, n2.y, negmatch) THEN (* commutativity *)
			IF Compare (n1.x, n2.y, negmatch) THEN (* put maching side to the right *)
				t := n2.x; n2.x := n2.y; n2.y := t;
				RETURN Compare (n1.y, n2.y, negmatch)
			ELSIF Compare (n1.y, n2.x, negmatch) THEN (* put maching side to the right *)
				t := n2.x; n2.x := n2.y; n2.y := t;
				RETURN FALSE
			END
		END
	END;
	RETURN res
END Compare;

PROCEDURE Compare1 (n1, n2 : LSD.Signal; negmatch : BOOLEAN);
VAR inverted : BOOLEAN;
BEGIN
	IF ok THEN (* catch only first error *)
		IF n1.fct IN {not, sr1} THEN negmatch := ~negmatch; n1 := n1.y END; (* skip negations *)
		IF n2.fct IN {not, sr1} THEN (* show negations in second formula *)
			Char ("("); ShowOp (n2); Compare1 (n1, n2.y, ~negmatch);
			IF ok THEN Char (")") END
		ELSIF n1 IS LSD.Variable THEN
			IF ~(n2 IS LSD.Variable) THEN
				IF n1 = LSD.zero THEN Err (ZeroExp, n2)
				ELSIF n1 = LSD.one THEN Err (OneExp, n2)
				ELSE Err (VarExp, n2)
				END
			ELSIF ~NameMatch (n1(LSD.Variable), n2(LSD.Variable), negmatch, inverted) THEN
				IF inverted THEN ShowOp (n2); Err (not, n2)
				ELSE
					ShowOp (n2);
					IF n1 = LSD.zero THEN Err (ZeroExp, n2)
					ELSIF n1 = LSD.one THEN Err (OneExp, n2)
					ELSIF (n2 = LSD.one) OR (n2 = LSD.zero) THEN Err (VarExp, n2)
					ELSE Err (Names, n2)
					END
				END
			ELSE ShowOp (n2)
			END
		ELSIF (n2 IS LSD.Variable) THEN
			ShowOp (n2);
			Err (n1.fct, n2)
		ELSIF (n1.fct = mux) & (n2.fct IN {or, xor, and}) THEN
			IF n2.fct IN {or, xor} THEN
				IF ~(n2.x IS LSD.Variable) & (n2.x.fct # and) THEN
					Char ("("); ShowForm (n2.x.x); ShowOp (n2.x); Err (and, n2)
				ELSIF ~(n2.y IS LSD.Variable) & (n2.y.fct # and) THEN
					Char ("("); ShowForm (n2.x); ShowOp (n2); Char ("(");
					ShowForm (n2.y.x); ShowOp (n2.y); Err (and, n2)
				ELSIF ~(n2.x.y IS LSD.Variable) & (n2.x.y.fct # not) THEN
					Char ("("); ShowForm (n2.x.x); ShowOp (n2.x); Err (not, n2)
				END;
				IF ok THEN
					Str ("((");
					Compare1 (n1.y.x, n2.x.x, TRUE);
					IF ok THEN ShowOp (n2.x); Compare1 (n1.x, n2.x.y, FALSE);
						IF ok THEN Char (")"); ShowOp (n2); Char ("("); Compare1 (n1.x, n2.y.x, TRUE);
							IF ok THEN
								ShowOp (n2.y); Compare1 (n1.y.y, n2.y.y, TRUE);
								IF ok THEN Str ("))") END
							END
						END
					END
				END
			ELSE (* n2.fct = and, apply DeMorgan rule *)
				IF negmatch THEN Err (not, n2) END;
				IF ~(n2.x IS LSD.Variable) & (n2.x.fct # not) THEN Err (not, n2)
				ELSIF ~(n2.x.y IS LSD.Variable) & (n2.x.y.fct # and) THEN
					Char ("("); ShowForm (n2.x.x); ShowOp (n2.x); Err (and, n2)
				ELSIF ~(n2.y IS LSD.Variable) & (n2.y.fct # not) THEN
					Char ("("); ShowForm (n2.x); ShowOp (n2); Char ("("); Char (" ");
					Err (not, n2)
				ELSIF ~(n2.y.y IS LSD.Variable) & (n2.y.y.fct # and) THEN
					Char ("("); ShowForm (n2.x); ShowOp (n2); Char ("(");
					ShowForm (n2.y.x); ShowOp (n2.y); Err (and, n2)
				END;
				IF ok THEN
					Str ("(("); ShowOp (n2.x); Char ("(");
					Compare1 (n1.y.x, n2.x.y.x, TRUE);
					IF ok THEN ShowOp (n2.x.y); Compare1 (n1.x, n2.x.y.y, FALSE);
						IF ok THEN Str ("))"); ShowOp (n2); Char ("("); ShowOp (n2.y); Char ("(");
							Compare1 (n1.x, n2.y.y.x, TRUE);
							IF ok THEN
								ShowOp (n2.y.y); Compare1 (n1.y.y, n2.y.y.y, TRUE);
								IF ok THEN Str (")))") END
							END
						END
					END
				END
			END
		ELSE
			IF (n2.fct # mux1) & (n2.fct # tsc) THEN Char ("(") END;
			IF n1.fct = n2.fct THEN
				IF n1.fct = sr THEN
					IF negmatch THEN
						Compare1 (n1.x, n2.x, TRUE);
						IF ok THEN ShowOp (n2) END;
						Compare1 (n1.y, n2.y, TRUE);
						IF ok THEN Char (")") END
					ELSE
						Compare1 (n1.x, n2.y, TRUE);
						IF ok THEN ShowOp (n2) END;
						Compare1 (n1.y, n2.x, TRUE);
						IF ok THEN Char (")") END
					END;
					RETURN
				ELSIF ~negmatch THEN Err (not, n2)
				ELSIF n2.fct = tsc THEN
					IF (n1.y # NIL) & (n2.y = NIL) THEN ShowForm (n2.x); Err (NotEnd, n2)
					ELSIF (n1.y = NIL) & (n2.y # NIL) THEN ShowForm (n2.x); Err (End, n2)
					END
				END
			ELSIF n1.fct = or THEN			 (* comparing DeMorgan rule *)
				IF negmatch THEN
					IF (n2.fct = mux) & ((n2.y.x = LSD.one) OR (n2.y.y = LSD.one)) THEN
						IF n2.y.y = LSD.one THEN 
							Compare1 (n1.x, n2.x, TRUE);
							IF ok THEN ShowOp (n2) END;
							Compare1 (n1.y, n2.y.x, TRUE);
							IF ok THEN ShowOp (n2.y); ShowForm (n2.y.y); Char (")"); RETURN END
						ELSE (* n2.y.x = LSD.one *)
							Compare1 (n1.x, n2.x, FALSE);
							IF ok THEN ShowOp (n2); ShowForm (n2.y.x); ShowOp (n2.y)END;
							Compare1 (n1.y, n2.y.y, TRUE);
							IF ok THEN Char (")"); RETURN END
						END
					ELSE ShowForm (n2.x); ShowOp (n2); Err (or, n2)
					END
				ELSIF n2.fct # and THEN ShowForm (n2.x); ShowOp (n2); Err (not, n2)
				END
			ELSIF n1.fct = and THEN
				IF negmatch THEN
					IF (n2.fct = mux) & ((n2.y.x = LSD.zero) OR (n2.y.y = LSD.zero)) THEN
						IF n2.y.x = LSD.zero THEN 
							Compare1 (n1.x, n2.x, TRUE);
							IF ok THEN ShowOp (n2); ShowForm (n2.y.x); ShowOp (n2.y)END;
							Compare1 (n1.y, n2.y.y, TRUE);
							IF ok THEN Char (")"); RETURN END
						ELSE (* n2.y.y = LSD.zero *)
							Compare1 (n1.x, n2.x, FALSE);
							IF ok THEN ShowOp (n2) END;
							Compare1 (n1.y, n2.y.x, TRUE);
							IF ok THEN ShowOp (n2.y); ShowForm (n2.y.y); Char (")"); RETURN END
						END
					ELSE ShowForm (n2.x); ShowOp (n2); Err (and, n2)
					END
				ELSIF n2.fct # or THEN ShowForm (n2.x); ShowOp (n2); Err (not, n2)
				END
			ELSE
				ShowForm (n2.x); ShowOp (n2); Err (n1.fct, n2)
			END;
			Compare1 (n1.x, n2.x, negmatch);
			 IF ok THEN ShowOp (n2) END;
			Compare1 (n1.y, n2.y, negmatch);
			IF ok & (n2.fct # mux1) & (n2.fct # tsc) THEN Char (")") END
		END
	END
END Compare1;

PROCEDURE Reorder (s : LSD.Signal);
(* only left/right subtrees may be exchanged. Moving a left subtree above a right one should not be done
because of DAGs: might change the meaning of other trees. Moving could have been useful for linearizing
AND or OR structures for dealing with the associativity problem *)
VAR t : LSD.Signal;
BEGIN
	IF s # NIL THEN
		IF s.fct IN {or, xor, and} THEN
			IF s.x.fct = s.fct THEN (* put same operators to the right *)
				IF s.y.fct # s.fct THEN t := s.x; s.x := s.y; s.y := t END
			ELSIF s.y IS LSD.Variable THEN (* put variables to the left *)
				IF ~(s.x IS LSD.Variable) THEN t := s.x; s.x := s.y; s.y := t END
			END
		END;
		IF ~(s IS LSD.Variable) THEN Reorder (s.x); Reorder (s.y) END
	END
END Reorder;

PROCEDURE Match (var1, var2 : LSD.Variable);
VAR name1, name2 : ARRAY 32 OF CHAR; negmatch : BOOLEAN;
BEGIN
	CLLola.Lookup (var1, name1); CLLola.Lookup (var2, name2);
	negmatch := (name1 = name2); (* if the implementation is negation of specification (i.e. var = var') *)
	Reorder (var1.x); Reorder (var2.x);
	IF ok THEN
		IF Compare (var1.x, var2.x, negmatch) THEN
			Str ("-> matches"); Ln
		ELSE
			Str ("-> error"); Ln;
			ok := TRUE;
			Str ("spec: "); LSD.WriteName (W, var1(LSD.Variable)); Str (" := "); ShowForm (var1.x); Ln;
			Str ("impl: "); LSD.WriteName (W, var2(LSD.Variable)); Str (" := "); ShowForm (var2.x); Ln;
			Str ("         "); LSD.WriteName (W, var2(LSD.Variable)); Str (" := ");
			Compare1 (var1.x, var2.x, negmatch); (* show error location *)
		END
	END
END Match;

PROCEDURE DetectCycles (s : LSD.Signal);
CONST Flag = 50;
BEGIN
	IF s # NIL THEN
		IF s.val >= 0 THEN
			DEC (s.val, Flag);
			IF s IS LSD.Variable THEN
				IF s(LSD.Variable).name[0] = "#" THEN
					INC (s.val, Flag);
					Err (Cycle, s);
					DEC (s.val, Flag)
				END (* left-over dummy variables *)
			ELSE DetectCycles (s.x); DetectCycles (s.y) END;
			INC (s.val, Flag)
		ELSE
			INC (s.val, Flag);
			Err (Cycle, s);
			DEC (s.val, Flag)
		END
	END
END DetectCycles;

(* formula input *)

PROCEDURE GetName (VAR name : ARRAY OF CHAR);
VAR S : Texts.Scanner; T : Texts.Text; beg, end, time : LONGINT; i : INTEGER;
BEGIN
	COPY ("", name);
	Texts.OpenScanner (S, Oberon.Par.text, Oberon.Par.pos);
	Texts.Scan (S);
	IF (S.class = Texts.Char) & (S.c = "^") THEN
		Oberon.GetSelection (T, beg, end, time);
		IF time >= 0 THEN Texts.OpenScanner (S, T, beg); Texts.Scan (S) END
	END;
	IF S.class = Texts.Name THEN
		COPY (S.s, name);
		IF S.nextCh = "'" THEN
			i := 0;
			WHILE name[i] # 0X DO INC (i) END;
			name[i] := "'"; name[i+1] := 0X
		END
	END
END GetName;

PROCEDURE GetFrame(VAR F : CLFramesD.Frame);
VAR V : Viewers.Viewer;
BEGIN
	IF (Oberon.Par.frame = Oberon.Par.vwr.dsc) & (Oberon.Par.frame.next # NIL) &
			(Oberon.Par.frame.next IS CLFramesD.Frame) THEN
		F := Oberon.Par.frame.next(CLFramesD.Frame)
	ELSE
		V := Oberon.MarkedViewer();
		IF (V.dsc # NIL) & (V.dsc.next # NIL) & (V.dsc.next IS CLFramesD.Frame) THEN F := V.dsc.next(CLFramesD.Frame)
		ELSE F := CLFramesD.Selected()
		END
	END
END GetFrame;

PROCEDURE Check*;
VAR F : CLFramesD.Frame; var, var2 : LSD.Variable; name : ARRAY 32 OF CHAR;
BEGIN
	ok := TRUE;
	GetFrame (F);
	IF F # NIL THEN
		GetName (name);
		IF name # "" THEN
			var := CLLola.This (LSD.org, name);
			Str (name); Char (" "); Append;
			IF var # NIL THEN
				IF var.x # NIL THEN
					Extractor.Init; (* because we reorder nodes in Reorder *)
					Extractor.Extract (F.a, name, var2);
					ok := Extractor.ok; errU := Extractor.errU; errV := Extractor.errV;
					IF ok THEN DetectCycles (var2.x) END;
					IF ok THEN
						LSD.state := {0}; LSD.Simplify (Extractor.topScope);
						Match (var, var2)
					END;
					IF ~ok & ((errU >= 0) OR (errV >= 0)) THEN
						CLFramesD.Select (F, errU, errV);
						CLFramesD.Position (F, errU, errV)
					END
				ELSE Err (UndefVar, LSD.zero)
				END
			ELSE Err (NoSpecVar, LSD.zero)
			END
		END
	ELSE Err (NoViewer, LSD.zero)
	END
END Check;

PROCEDURE CheckAll*;
VAR F : CLFramesD.Frame; var2 : LSD.Variable;

	PROCEDURE CheckScope (var : LSD.Variable);
	VAR name : ARRAY 32 OF CHAR;
	BEGIN
		WHILE (var # NIL) & ok DO
			IF (var.fct IN {LSD.Bit, LSD.TS, LSD.OC}) & (var.x # NIL) THEN
				CLLola.Lookup (var, name);
				Str (name); Char (" "); Append;
				Extractor.Init; (* called here, because nodes are reordered (see Reorder) *)
				Extractor.Extract (F.a, name, var2);
				ok := Extractor.ok; errU := Extractor.errU; errV := Extractor.errV;
				IF ok THEN DetectCycles (var2.x) END;
				IF ok THEN LSD.state := {0}; LSD.Simplify (Extractor.topScope); Match (var, var2) END;
				IF ~ok & ((errU >= 0) OR (errV >= 0)) THEN
					CLFramesD.Select (F, errU, errV);
					CLFramesD.Position (F, errU, errV)
				END
			ELSIF var.fct IN {LSD.Array, LSD.Record} THEN CheckScope (var.dsc)
			END;
			var := var.next
		END
	END CheckScope;

BEGIN
	ok := TRUE;
	GetFrame (F);
	IF F # NIL THEN
		CheckScope (LSD.org);
		IF ok THEN Str ("all variables match"); Ln END
	ELSE Err (NoViewer, LSD.zero)
	END
END CheckAll;

PROCEDURE Show*;
VAR F : CLFramesD.Frame; var : LSD.Variable; name : ARRAY 32 OF CHAR;
BEGIN
	ok := TRUE;
	GetFrame (F);
	IF F # NIL THEN
		GetName (name);
		IF name # "" THEN
			Str (name); Char (" "); Append;
			Extractor.Init;
			Extractor.Extract (F.a, name, var);
			ok := Extractor.ok; errU := Extractor.errU; errV := Extractor.errV;
			IF ok THEN DetectCycles (var.x) END;
			IF ok THEN LSD.state := {0}; LSD.Simplify (Extractor.topScope); Str (":= "); ShowForm (var.x); Ln
			ELSIF (errU >= 0) OR (errV >= 0) THEN
				CLFramesD.Select (F, errU, errV);
				CLFramesD.Position (F, errU, errV)
			END
		END
	ELSE Err (NoViewer, LSD.one)
	END
END Show;

BEGIN
	Texts.OpenWriter (W); Str (Version); Ln;
END CLChecker.
