B	  Syntax10.Scn.Fnt  u ParcElems Alloc     
 +6      ևԒҝШϳ;    Syntax10i.Scn.Fnt      A  StampElems Alloc 4 Nov 93  >    %    8  FoldElems New  L  Syntax10b.Scn.Fnt                                  8       8               8       8              8       8   %    8   $    8   )    8   !    8   )    8       8   C    8   6    8   <   8   J    8   d    8   1    8   -    8   3    8   Y    8   f    8   .   8   A    8           %                                W                )                k                            8   R    8      8   O    8   w   8   +    8   P    8       8   n	   8   D   8   -	   8   X    8   -   8   I    8   &   8   ?    8      8   +    8   3    8   6    8   i    8       8   
   8   "   8    	   8   G    8      8   L    8   %   8   B    8      8   '    8      8   g    8      8           X    8   a    8           X    8   a    8           N    8       8           N    8   <   8           N    8      8       8   ,   8          MODULE CLAnalyze;	(* sg 15. Jun 93,  *)
(* changes: 4.Nov 93: Phase 2 is executed iff dMax >= 0 *)

IMPORT CLGAs, Texts, Oberon;

CONST
	(* delays (0.1 ns) *)
	Wire = 10; Nand = 20; XorAB = 27; XorL = 28; And = 20; (* MuxAB = XorAB; MuxL = XorL; *)
	RegSet = 21; RegOut = 20; RegRes = 16; BusDrv = 30; RepE = 16; RepL = 23; BusEn = 26;
	Clk = 18; Res = 18; ClkBuf = 20; ResBuf = 20;
	IOIn = 10; IOOut = 100; IOEn = 100;
	Local = 0; Express = 1; Left = 0; Right = 1;
	Constant* = -10000;

	(* constants defined in CLGAs *)
	Dim = CLGAs.Dim; Sector = CLGAs.Sector;
	None = CLGAs.None; North = CLGAs.North; South = CLGAs.South; West = CLGAs.West; East = CLGAs.East;
	Write = CLGAs.Write; TS = CLGAs.TS; Read = CLGAs.Read; Mux = CLGAs.Mux; (* internal cell routing *)
	TurnB = CLGAs.TurnB; Turn0 = CLGAs.Turn0;
	State0 = CLGAs.State0; State1 = CLGAs.State1; State2 = CLGAs.State2; State3 = CLGAs.State3; (* cell states *)
	EEWE = CLGAs.EEWE; LEWE = CLGAs.LEWE; LLWE = CLGAs.LLWE; ELWE = CLGAs.ELWE;
	EEEW = CLGAs.EEEW; LEEW = CLGAs.LEEW; LLEW = CLGAs.LLEW; ELEW = CLGAs.ELEW;
	ClkOne = CLGAs.ClkOne; ClkAout = CLGAs.ClkAout; ClkGlobal = CLGAs.ClkGlobal; ClkExpress = CLGAs.ClkExpress;
	TSOff = CLGAs.TSOff; TSSerial = CLGAs.TSSerial; TSParallel = CLGAs.TSParallel; TSOn = CLGAs.TSOn;

	AOut = CLGAs.AOut; BOut = CLGAs.BOut; LOut = CLGAs.LOut;
	LBusN = CLGAs.LBusN; LBusS = CLGAs.LBusS; LBusW = CLGAs.LBusW; LBusE = CLGAs.LBusE;
	EBusN = CLGAs.EBusN; EBusS = CLGAs.EBusS; EBusW = CLGAs.EBusW; EBusE = CLGAs.EBusE;
	FF = EBusE + 1;

	Cell* = 0; IO* = 1; Repeater* = 2; (* kind *)

	Deb = FALSE;

TYPE
	Handler* = PROCEDURE (ga : CLGAs.GA; u, v, sig, kind, d : INTEGER);
	Delay = RECORD delay, pass : INTEGER; onPath, onMaxPath : BOOLEAN END;
	RepDelay = ARRAY 2 OF RECORD (Delay) input, dir : SHORTINT END;

VAR
	showErr* : BOOLEAN;
	perform : Handler;
	W : Texts.Writer;
	cDelay : ARRAY Dim, Dim, 3 OF Delay;
	ioDelay : ARRAY 4, (Dim DIV 2) - 1 OF Delay;
	wrDelay : ARRAY Dim, (Dim DIV Sector) - 1 OF RepDelay;
	erDelay : ARRAY Dim, (Dim DIV Sector) - 1 OF RepDelay;
	nrDelay : ARRAY (Dim DIV Sector) - 1, Dim OF RepDelay;
	srDelay : ARRAY (Dim DIV Sector) - 1, Dim OF RepDelay;
	pass, destU, destV, destSig, i, j : INTEGER;
	rep : ARRAY 2, 2, 2 OF INTEGER; (* input, output, direction *)
	dMax : INTEGER;
	allPaths : BOOLEAN;

PROCEDURE Char (ch : CHAR);
BEGIN
	Texts.Write (W, ch)
END Char;

PROCEDURE Str (s : ARRAY OF CHAR);
BEGIN
	Texts.WriteString (W, s)
END Str;

PROCEDURE Int (i, w : LONGINT);
BEGIN
	Texts.WriteInt (W, i, w)
END Int;

PROCEDURE Ln;
BEGIN
	Texts.WriteLn (W); Texts.Append (Oberon.Log, W.buf)
END Ln;

PROCEDURE Show (ga : CLGAs.GA; u, v, sig : INTEGER);
VAR L : CLGAs.Label;
BEGIN
	IF sig = FF THEN L := CLGAs.LabelAt (ga, u, v, AOut) ELSE L := CLGAs.LabelAt (ga, u, v, sig) END;
	IF L # NIL THEN Str (L.name)
	ELSE
		Char ("("); Int (u, 0); Char (" "); Int (v, 0);
		CASE sig OF
			AOut	:	Str (" AOut")
		|	BOut	:	Str (" BOut")
		|	LBusN	:	Str (" LBusN")
		|	LBusS	:	Str (" LBusS")
		|	LBusW	:	Str (" LBusW")
		|	LBusE	:	Str (" LBusE")
		|	EBusN	:	Str (" EBusN")
		|	EBusS	:	Str (" EBusS")
		|	EBusW	:	Str (" EBusW")
		|	EBusE	:	Str (" EBusE")
		|	FF		:	Str (" FF")
		ELSE (* do nothing *)
		END;
		Char (")")
	END
END Show;

PROCEDURE Err (ga : CLGAs.GA; u, v, sig : INTEGER; msg : ARRAY OF CHAR);
BEGIN
	IF showErr THEN Str ("*** "); Str (msg); Str (" at "); Show (ga, u, v, sig); Ln END
END Err;

PROCEDURE Max (VAR max : INTEGER; n : INTEGER);
BEGIN
	IF n > max THEN max := n END
END Max;

PROCEDURE OnPath (u, v, sig : INTEGER) : BOOLEAN;
BEGIN
	RETURN (destSig < 0) OR ((u = destU) & (v = destV) & (sig = destSig))
END OnPath;

PROCEDURE CellInputs (ga : CLGAs.GA; u, v, outSig : INTEGER; VAR inSigs : SET; stopAtFFs : BOOLEAN);
VAR routing : SHORTINT;
BEGIN
	routing := ga.c[u, v].routing;
	CASE routing OF
		Write, TurnB	:	inSigs := {AOut, BOut}
	|	TS, Turn0	:	inSigs := {AOut} (* B input is constant for AOut/BOut *)
	|	Read, Mux	:	inSigs := {AOut, BOut, LOut}
	ELSE Err (ga, u, v, None, "undefined routing"); outSig := BOut; inSigs := {} (* error recovery *)
	END;
	CASE ga.c[u, v].state OF
		State0	:	IF outSig = BOut THEN
							EXCL (inSigs, AOut);
							IF routing = Read THEN EXCL (inSigs, LOut) END
						ELSE EXCL (inSigs, BOut)
						END
	|	State1	:	IF outSig IN {AOut, LBusN..LBusE} THEN
							EXCL (inSigs, AOut);
							IF routing = Read THEN EXCL (inSigs, LOut) END
						ELSE EXCL (inSigs, BOut)
						END
	|	State2,
		State3	:	(* nothing *)
	ELSE Err (ga, u, v, None, "undefined state"); outSig := BOut; inSigs := {} (* error recovery *)
	END;
	IF (outSig IN {LBusN..LBusE}) & (routing = TS) THEN INCL (inSigs, BOut) END;
	IF ga.c[u, v].a = None THEN EXCL (inSigs, AOut) END;
	IF ga.c[u, v].b = None THEN EXCL (inSigs, BOut) END;
	IF LOut IN inSigs THEN (* specify which LBus *)
		EXCL (inSigs, LOut);
		IF (ga.c[u, v].nsL = None) & (ga.c[u, v].weL = None) THEN Err (ga, u, v, None, "undefined local bus input") END;
		CASE ga.c[u, v].nsL OF
			None	:	(* do nothing *)
		|	North	:	INCL (inSigs, LBusN)
		|	South	:	INCL (inSigs, LBusS)
		END;
		CASE ga.c[u, v].weL OF
			None	:	(* do nothing *)
		|	West		:	INCL (inSigs, LBusW)
		|	East		:	INCL (inSigs, LBusE)
		END
	END;
	IF stopAtFFs & (outSig IN {AOut, LBusN..LBusE}) & (ga.c[u, v].state = State3) THEN inSigs := {FF} END
END CellInputs;

PROCEDURE Clock (ga : CLGAs.GA; u, v, sig : INTEGER) : INTEGER;
VAR d : INTEGER;
BEGIN
	IF ga.clk[u] = ClkOne THEN d := 0 ELSE d := RegOut (* synchronous *) END;
	IF Deb THEN Str ("Clock"); Int (u, 3); Int (v, 3); Int (sig, 3); Int (d, 5); Ln END;
	RETURN d
(*	CASE ga.clk[u] OF (* asynchronous *)*)
(*		ClkOne		:	d := 0*)
(*	|	ClkAout		:	d := Cell (ga, u, Dim - 1, AOut); IF d > 0 THEN INC (d, RegOut + Clk) END*)
(*	|	ClkGlobal	:	d := RegOut + Clk + ClkBuf*)
(*	|	ClkExpress	:	d := Bus (ga, (u DIV Sector) * Sector, Dim - 1, EBusS); IF d > 0 THEN INC (d, RegOut + Clk)*)
(*	END;*)
END Clock;

PROCEDURE Neighbor (ga : CLGAs.GA; u, v, inSig : INTEGER; VAR u1, v1 : INTEGER);
VAR dir : INTEGER;
BEGIN
	u1 := u; v1 := v;
	CASE inSig OF
		AOut, BOut		:	IF inSig = AOut THEN dir := ga.c[u, v].a ELSE dir := ga.c[u, v].b END;
								CASE dir OF
									North	:	v1 := v + 1
								|	South	:	v1 := v - 1
								|	West		:	u1 := u - 1
								|	East		:	u1 := u + 1
								ELSE u1 := -(u + 1); v1 := -(v + 1); (* signal FF reached *)
								END
	|	LBusN, LBusS	:	u1 := (u DIV Sector) * Sector
	|	LBusW, LBusE	:	v1 := (v DIV Sector) * Sector
	END
END Neighbor;

PROCEDURE CellDelay (ga : CLGAs.GA; u, v, inSig, outSig : INTEGER) : INTEGER;
VAR d, d2 : INTEGER;
BEGIN
	IF outSig = BOut THEN
		CASE ga.c[u, v].state OF
			State0, State1	:	d := Wire
		|	State2			:	d := Nand
		|	State3			:	d := And
		END
	ELSIF (outSig IN {LBusN..LBusE}) & (inSig = BOut) & (ga.c[u, v].routing = TS) THEN
		d := BusEn
	ELSE (* outSig IN {AOut, LBusN..LBusE} *)
		IF outSig = AOut THEN d := 0 ELSE d := BusDrv END;
		CASE ga.c[u, v].state OF
			State0, State1	:	INC (d, Wire)
		|	State2			:	IF inSig IN {AOut, BOut} THEN INC (d, XorAB) ELSE INC (d, XorL) END
		|	State3			:	d2 := Clock (ga, u, v, AOut); IF d2 > 0 THEN INC (d, d2) ELSE d := Constant END
		END
	END;
	RETURN d
END CellDelay;

PROCEDURE T (outSig : INTEGER) : INTEGER;
BEGIN
	IF outSig IN {AOut, BOut} THEN RETURN outSig ELSE RETURN LOut END
END T;

PROCEDURE ^ Bus1 (ga : CLGAs.GA; u, v, sig : INTEGER; cTurn : BOOLEAN; VAR path : BOOLEAN) : INTEGER;

PROCEDURE Repeater1 (ga : CLGAs.GA; u, v, outSig, fromDir : INTEGER; VAR path : BOOLEAN) : INTEGER;
VAR nextU, nextV, repU, repV, locBus, exprBus, inSig, r, d1, dRep : INTEGER;

	PROCEDURE Rep (VAR r : RepDelay);
	BEGIN
		IF r[0].pass < pass THEN
			r[0].pass := pass; r[0].input := SHORT (inSig); r[0].dir := SHORT (fromDir);
			d1 := Bus1 (ga, nextU, nextV, inSig, FALSE, path) + dRep;
			r[0].delay := d1; r[0].onPath := path
		ELSIF (r[0].input = inSig) & (r[0].dir = fromDir) THEN d1 := r[0].delay; path := r[0].onPath
		ELSIF r[1].pass < pass THEN
			r[1].pass := pass; r[1].input := SHORT (inSig); r[1].dir := SHORT (fromDir);
			d1 := Bus1 (ga, nextU, nextV, inSig, FALSE, path) + dRep;
			r[1].delay := d1; r[1].onPath := path
		ELSIF (r[1].input = inSig) & (r[1].dir = fromDir) THEN d1 := r[1].delay; path := r[1].onPath
		ELSE HALT (99) (* can't have 3 inputs to a repeater *)
		END
	END Rep;

BEGIN
	IF Deb THEN Str ("Repeater"); Int (u, 3); Int (v, 3); Int (outSig, 3); Int (fromDir, 3); Ln END;
	nextU := u; nextV := v; repU := u; repV := v;
	IF outSig IN {LBusN, LBusS, EBusN, EBusS} THEN
		IF fromDir = Left THEN DEC (nextU, Sector); repU := (u - Sector) DIV Sector
		ELSE INC (nextU, Sector); repU := u DIV Sector
		END;
		IF (nextU < 0) OR (nextU = Dim) THEN RETURN Constant END
	ELSE (* outSig IN {LBusW, LBusE, EBusW, EBusE} *)
		IF fromDir = Left THEN INC (nextV, Sector); repV := v DIV Sector
		ELSE DEC (nextV, Sector); repV := (v - Sector) DIV Sector
		END;
		IF (nextV < 0) OR (nextV = Dim) THEN RETURN Constant END
	END;
	CASE outSig OF
		LBusN, EBusN	:	r := ga.hr[repU, repV].n; locBus := LBusN; exprBus := EBusN
	|	LBusS, EBusS	:	r := ga.hr[repU, repV].s; locBus := LBusS; exprBus := EBusS
	|	LBusW, EBusW	:	r := ga.vr[repU, repV].w; locBus := LBusW; exprBus := EBusW
	|	LBusE, EBusE	:	r := ga.vr[repU, repV].e; locBus := LBusE; exprBus := EBusE
	END;
	IF ODD (r DIV rep[Local, (outSig - LBusN) DIV 4, fromDir]) THEN inSig := locBus
	ELSIF ODD (r DIV rep[Express, (outSig - LBusN) DIV 4, fromDir]) THEN inSig := exprBus
	ELSE RETURN Constant
	END;
	IF outSig IN {LBusN..LBusE} THEN dRep := RepL ELSE dRep := RepE END;
	CASE outSig OF
		LBusN, EBusN	:	Rep (nrDelay[repU, repV])
	|	LBusS, EBusS	:	Rep (srDelay[repU, repV])
	|	LBusW, EBusW	:	Rep (wrDelay[repU, repV])
	|	LBusE, EBusE	:	Rep (erDelay[repU, repV])
	END;
	IF Deb THEN Str ("Repeater Delay"); Int (u, 3); Int (v, 3); Int (inSig, 3); Int (d1, 5);
		IF path THEN Str (" T") ELSE Str (" F") END; Ln END;
	RETURN d1
END Repeater1;

PROCEDURE ^ Cell1 (ga : CLGAs.GA; u, v, outSig : INTEGER; VAR path : BOOLEAN) : INTEGER;

(* no cornerturn: (u MOD Sector) = 0 OR (v MOD Sector) = 0 *)
(* cornerturns (cTurn=TRUE): (u,v) = coordinates of cornerturn cell *)
PROCEDURE Bus1 (ga : CLGAs.GA; u, v, sig : INTEGER; cTurn : BOOLEAN; VAR path : BOOLEAN) : INTEGER;
VAR d1, dir, i, u1, v1 : INTEGER; routing : SHORTINT; p : BOOLEAN;
BEGIN
	IF Deb THEN Str ("Bus"); Int (u, 3); Int (v, 3); Int (sig, 3); Ln END;
	d1 := Constant; path := FALSE; p := FALSE;
	IF sig IN {LBusN..LBusE} THEN (* check for output to local bus *)
		u1 := u; v1 := v;
		CASE sig OF
			LBusN	:	dir := North; u1 := (u DIV Sector) * Sector (* adjust to start of local bus *)
		|	LBusS	:	dir := South; u1 := (u DIV Sector) * Sector
		|	LBusW	:	dir := West; v1 := (v DIV Sector) * Sector
		|	LBusE	:	dir := East; v1 := (v DIV Sector) * Sector
		END;
		i := 0;
		WHILE i < Sector DO
			routing := ga.c[u1, v1].routing; IF routing = None THEN routing := Turn0 END;
			IF sig IN {LBusN, LBusS} THEN
				IF ga.c[u1, v1].nsL = dir THEN
					IF (routing IN {Write, TS}) OR ((routing IN {TurnB, Turn0}) & (~cTurn OR (u1 # u))) THEN
						Max (d1, Cell1 (ga, u1, v1, sig, p))
					END
				END;
				INC (u1)
			ELSE (* sig IN {LBusW, LBusE} *)
				IF ga.c[u1, v1].weL = dir THEN
					IF (routing IN {Write, TS}) OR ((routing IN {TurnB, Turn0}) & (~cTurn OR (v1 # v))) THEN
						Max (d1, Cell1 (ga, u1, v1, sig, p))
					END
				END;
				INC (v1)
			END;
			path := path OR p;
			INC (i)
		END;
		IF cTurn THEN
			IF sig IN {LBusN, LBusS} THEN u := (u DIV Sector) * Sector ELSE v := (v DIV Sector) * Sector END
		END
	END;
	Max (d1, Repeater1 (ga, u, v, sig, Left, p)); path := path OR p;
	Max (d1, Repeater1 (ga, u, v, sig, Right, p)); path := path OR p;
	IF sig = EBusW THEN
		IF (v = 0) & ~ODD (u) THEN Max (d1, Cell1 (ga, u, 0, AOut, p))
		ELSIF (v = Dim - Sector) & ODD (u) THEN Max (d1, Cell1 (ga, u, Dim - 1, BOut, p))
		END
	ELSIF sig = EBusE THEN
		IF (v = 0) & ~ODD (u) THEN Max (d1, Cell1 (ga, u, 0, BOut, p))
		ELSIF (v = Dim - Sector) & ODD (u) THEN Max (d1, Cell1 (ga, u, Dim - 1, AOut, p))
		END
	ELSIF sig = EBusN THEN
		IF (u = 0) & ODD (v) THEN Max (d1, Cell1 (ga, 0, v, BOut, p))
		ELSIF (u = Dim - Sector) & ~ODD (v) THEN Max (d1, Cell1 (ga, Dim - 1, v, AOut, p))
		END
	ELSIF sig = EBusS THEN
		IF (u = 0) & ODD (v) THEN Max (d1, Cell1 (ga, 0, v, AOut, p))
		ELSIF (u = Dim - Sector) & ~ODD (v) THEN Max (d1, Cell1 (ga, Dim - 1, v, BOut, p))
		END
	END;
	path := path OR p;
	IF Deb THEN Str ("Bus1 Delay"); Int (u, 3); Int (v, 3); Int (sig, 3); Int (d1, 5);
		IF path THEN Str (" T") ELSE Str (" F") END; Ln END;
	RETURN d1
END Bus1;

PROCEDURE Cell1 (ga : CLGAs.GA; u, v, outSig : INTEGER; VAR path : BOOLEAN) : INTEGER;
VAR d1, u1, v1, inSig, d2, dir, uv : INTEGER; inputs : SET; p : BOOLEAN;
BEGIN
	IF Deb THEN Str ("Cell"); Int (u, 3); Int (v, 3); Int (outSig, 3); Ln END;
	d1 := Constant;
	IF (u < 0) OR (u = Dim) OR (v < 0) OR (v = Dim) THEN (* border input from either express or IO *)
		IF outSig = AOut THEN
			IF (u = -1) & ~ODD (v) THEN d1 := Bus1 (ga, 0, v, EBusN, FALSE, path)
			ELSIF (u = Dim) & ODD (v) THEN d1 := Bus1 (ga, Dim - Sector, v, EBusS, FALSE, path)
			ELSIF (v = -1) & ODD (u) THEN d1 := Bus1 (ga, u, 0, EBusE, FALSE, path)
			ELSIF (v = Dim) & ~ODD (u) THEN d1 := Bus1 (ga, u, Dim - Sector, EBusW, FALSE, path)
			ELSIF ((u = -1) & (v = Dim -1)) OR ((u = Dim - 1) & (v = Dim)) THEN d1 := 0 (* global clock *)
			ELSIF ((u = 0) & (v = -1)) OR ((u = Dim) & (v = Dim - 1)) THEN d1 := 0 (* global reset *)
			ELSE (* input from I/O *)
				d1 := IOIn;
				IF u < 0 THEN dir := West; v := (v - 1) DIV 2; uv := v
				ELSIF u = Dim THEN dir := East; v := (v - 1) DIV 2; uv := v
				ELSIF v < 0 THEN dir := South; u := (u - 1) DIV 2; uv := u
				ELSE (* v = Dim *) dir := North; u := (u - 1) DIV 2; uv := u
				END;
				path := OnPath (u, v, outSig); ioDelay[dir, uv].onPath := path
			END
		ELSE (* outSig = BOut *)
			IF u = -1 THEN
				IF ~ODD (v) THEN d1 := Bus1 (ga, 0, v, EBusS, FALSE, path)
				ELSIF v < Dim - 1 THEN d1 := Cell1 (ga, 0, v + 1, BOut, path)
				ELSE Err (ga, 0, v, None, "illegal IO input to B") (* never an IO input from B *)
				END
			ELSIF u = Dim THEN
				IF ODD (v) THEN d1 := Bus1 (ga, Dim - Sector, v, EBusN, FALSE, path)
				ELSIF v > 0 THEN d1 := Cell1 (ga, Dim - 1, v - 1, BOut, path)
				ELSE Err (ga, Dim - 1, v, None, "illegal IO input to B") (* never an IO input from B *)
				END
			ELSIF v = -1 THEN
				IF ODD (u) THEN d1 := Bus1 (ga, u, 0, EBusW, FALSE, path)
				ELSIF u > 0 THEN d1 := Cell1 (ga, u - 1, 0, BOut, path)
				ELSE Err (ga, u, 0, None, "illegal IO input to B") (* never an IO input from B *)
				END
			ELSIF v = Dim THEN
				IF ~ODD (u) THEN d1 := Bus1 (ga, u, Dim - Sector, EBusE, FALSE, path)
				ELSIF u < Dim - 1 THEN d1 := Cell1 (ga, u + 1, Dim - 1, BOut, path)
				ELSE Err (ga, u, Dim - 1, None, "illegal IO input to B") (* never an IO input from B *)
				END
			END
		END
	ELSIF cDelay[u, v, T (outSig)].pass < pass THEN
		cDelay[u, v, T (outSig)].pass := pass; (* mark cell *)
		IF (outSig IN {LBusN..LBusE}) & ((ga.c[u, v].routing = None) OR (ga.c[u, v].routing IN {TurnB, Turn0})) THEN
			IF outSig IN {LBusN, LBusS} THEN (* cornerturn *)
				IF ga.c[u, v].weL = West THEN d1 := Bus1 (ga, u, v, LBusW, TRUE, path)
				ELSE d1 := Bus1 (ga, u, v, LBusE, TRUE, path)
				END
			ELSE (* cornerturn, outSig IN {LBusE, LBusW} *)
				IF ga.c[u, v].nsL = North THEN d1 := Bus1 (ga, u, v, LBusN, TRUE, path)
				ELSE d1 := Bus1 (ga, u, v, LBusS, TRUE, path)
				END
			END
		ELSE (* outSig IN {AOut, BOut, LBusN..LBusE}, no cornerturn *)
			cDelay[u, v, T (outSig)].onPath := OnPath (u, v, outSig);
			CellInputs (ga, u, v, outSig, inputs, TRUE);
			IF inputs * {AOut..LBusE} # {} THEN (* input from neighboring cell/bus *)
				inSig := AOut; path := FALSE; p := FALSE;
				REPEAT
					IF inSig IN inputs THEN
						d2 := CellDelay (ga, u, v, inSig, outSig);
						Neighbor (ga, u, v, inSig, u1, v1);
						IF inSig IN {AOut, BOut} THEN Max (d1, Cell1 (ga, u1, v1, inSig, p) + d2)
						ELSE Max (d1, Bus1 (ga, u1, v1, inSig, FALSE, p) + d2)
						END;
						path := path OR p
					END;
					INC (inSig)
				UNTIL inSig > LBusE
			ELSE (* inputs = {} OR inputs = {FF} *)
				path := OnPath (u, v, outSig);
				IF inputs = {FF} THEN d1 := CellDelay (ga, u, v, -1, outSig) END
			END
		END;
		cDelay[u, v, T (outSig)].delay := d1; cDelay[u, v, T (outSig)].onPath := path
	ELSE (* outSig IN {AOut, BOut, LBusN..LBusE}, reached a cycle/common subexpression *)
		d1 := cDelay[u, v, T (outSig)].delay; path := cDelay[u, v, T (outSig)].onPath
	END;
	IF ~path THEN d1 := Constant END; (* interested only in delays on path *)
	IF Deb THEN
		Str ("Cell1 Delay"); Int (u, 3); Int (v, 3); Int (outSig, 3); Int (d1, 5);
		IF path THEN Str (" T") ELSE Str (" F") END; Ln END;
	RETURN d1
END Cell1;

PROCEDURE StartCell1 (ga : CLGAs.GA; u, v, outSig : INTEGER) : INTEGER;
VAR d1, dClk, u1, v1, inSig : INTEGER; inputs : SET; path, p : BOOLEAN;
BEGIN
	d1 := Constant;
	IF (outSig = AOut) & (ga.c[u, v].state = State3) THEN (* skip FF *)
		dClk := Clock (ga, u, v, outSig);
		IF dClk > 0 THEN (* clock enabled *)
			CellInputs (ga, u, v, outSig, inputs, FALSE);
			inSig := AOut; path := FALSE; p := FALSE;
			REPEAT
				IF inSig IN inputs THEN
					Neighbor (ga, u, v, inSig, u1, v1);
					IF inSig IN {AOut, BOut} THEN Max (d1, Cell1 (ga, u1, v1, inSig, p))
					ELSE Max (d1, Bus1 (ga, u1, v1, inSig, FALSE, p))
					END;
					path := path OR p
				END;
				INC (inSig)
			UNTIL inSig > LBusE;
			INC (d1, RegSet)
		END
	ELSE d1 := Cell1 (ga, u, v, outSig, path)
	END;
	cDelay[u, v, T (outSig)].delay := d1;
	cDelay[u, v, T (outSig)].onPath := path;
	RETURN d1
END StartCell1;

PROCEDURE StartIO1 (ga : CLGAs.GA; u, v : INTEGER) : INTEGER;
VAR d1, dir, sel, uv : INTEGER; path, maxPath, p, mp : BOOLEAN;
BEGIN
	d1 := Constant;
	IF u < 0 THEN dir := West; uv := v; u := 0; v := 2 * v + 2
	ELSIF u = Dim THEN dir := East; uv := v; u := Dim - 1; v := 2 * v + 1
	ELSIF v < 0 THEN dir := South; uv := u; u := 2 * u + 1; v := 0
	ELSE dir := North; uv := u; u := 2 * u + 2; v := Dim - 1
	END;
	sel := ga.p[dir, uv].selector; path := FALSE; maxPath := FALSE; p := FALSE; mp := FALSE;
	ioDelay[dir, uv].pass := pass; (* mark IO *)
	CASE sel OF
	|	TSOff, TSOn	:	(* do nothing *)
	|	TSSerial		:	CASE dir OF
							|	North	:	d1 := Bus1 (ga, u, (v DIV Sector) * Sector, LBusW, FALSE, path) + IOEn
							|	South	:	d1 := Bus1 (ga, u, (v DIV Sector) * Sector, LBusE, FALSE, path) + IOEn
							|	West		:	d1 := Bus1 (ga, (u DIV Sector) * Sector, v, LBusS, FALSE, path) + IOEn
							|	East		:	d1 := Bus1 (ga, (u DIV Sector) * Sector, v, LBusN, FALSE, path) + IOEn
							END
	|	TSParallel	:	CASE dir OF
							|	North	:	d1 := Bus1 (ga, (u DIV Sector) * Sector, v, LBusN, FALSE, path) + IOEn
							|	South	:	d1 := Bus1 (ga, (u DIV Sector) * Sector, v, LBusS, FALSE, path) + IOEn
							|	West		:	d1 := Bus1 (ga, u, (v DIV Sector) * Sector, LBusW, FALSE, path) + IOEn
							|	East		:	d1 := Bus1 (ga, u, (v DIV Sector) * Sector, LBusE, FALSE, path) + IOEn
							END
	END;
	IF sel # TSOff THEN Max (d1, Cell1 (ga, u, v, AOut, p) + IOOut) END;
	ioDelay[dir, uv].delay := d1;
	ioDelay[dir, uv].onPath := path OR p; ioDelay[dir, uv].onMaxPath := maxPath OR mp;
	RETURN d1
END StartIO1;

PROCEDURE InTime (d : INTEGER) : BOOLEAN;
BEGIN
	RETURN (allPaths OR (d = dMax))
END InTime;

PROCEDURE OnMaxPath (u, v, sig : INTEGER) : BOOLEAN;
BEGIN
	RETURN (allPaths OR (destSig <  0) OR (u = destU) & (v = destV) & (sig = destSig))
END OnMaxPath;

PROCEDURE ^ Bus2 (ga : CLGAs.GA; u, v, sig, d : INTEGER; cTurn : BOOLEAN) : BOOLEAN;

PROCEDURE Repeater2 (ga : CLGAs.GA; u, v, outSig, d, fromDir : INTEGER) : BOOLEAN;
VAR nextU, nextV, repU, repV, locBus, exprBus, inSig, r, dRep : INTEGER; found : BOOLEAN;

	PROCEDURE Rep (VAR rep : RepDelay);
	BEGIN
		IF (rep[0].input = inSig) & (rep[0].dir = fromDir) THEN
			IF rep[0].pass < pass THEN
				rep[0].pass := pass;
				IF rep[0].onPath & InTime (d + rep[0].delay) THEN
					found := Bus2 (ga, nextU, nextV, inSig, d + dRep, FALSE);
					rep[0].onMaxPath := found
				END
			ELSE found := rep[0].onMaxPath
			END;
			IF found & (perform # NIL) THEN perform (ga, repU, repV, inSig + 16 * fromDir, Repeater, d) END
		ELSIF (rep[1].input = inSig) & (rep[1].dir = fromDir) THEN
			IF rep[1].pass < pass THEN
				rep[1].pass := pass;
				IF rep[1].onPath & InTime (d + rep[1].delay) THEN
					found := Bus2 (ga, nextU, nextV, inSig, d + dRep, FALSE);
					rep[1].onMaxPath := found
				END
			ELSE found := rep[1].onMaxPath
			END;
			IF found & (perform # NIL) THEN perform (ga, repU, repV, inSig + 16 * fromDir, Repeater, d) END
		END
	END Rep;

BEGIN
	IF Deb THEN Str ("Repeater"); Int (u, 3); Int (v, 3); Int (outSig, 3); Int (fromDir, 3); Int (d, 3); Ln END;
	found := FALSE; nextU := u; nextV := v; repU := u; repV := v;
	IF outSig IN {LBusN, LBusS, EBusN, EBusS} THEN
		IF fromDir = Left THEN DEC (nextU, Sector); repU := (u - Sector) DIV Sector
		ELSE INC (nextU, Sector); repU := u DIV Sector
		END;
		IF (nextU < 0) OR (nextU = Dim) THEN RETURN FALSE END
	ELSE (* outSig IN {LBusW, LBusE, EBusW, EBusE} *)
		IF fromDir = Left THEN INC (nextV, Sector); repV := v DIV Sector
		ELSE DEC (nextV, Sector); repV := (v - Sector) DIV Sector
		END;
		IF (nextV < 0) OR (nextV = Dim) THEN RETURN FALSE END
	END;
	CASE outSig OF
		LBusN, EBusN	:	r := ga.hr[repU, repV].n; locBus := LBusN; exprBus := EBusN
	|	LBusS, EBusS	:	r := ga.hr[repU, repV].s; locBus := LBusS; exprBus := EBusS
	|	LBusW, EBusW	:	r := ga.vr[repU, repV].w; locBus := LBusW; exprBus := EBusW
	|	LBusE, EBusE	:	r := ga.vr[repU, repV].e; locBus := LBusE; exprBus := EBusE
	END;
	IF ODD (r DIV rep[Local, (outSig - LBusN) DIV 4, fromDir]) THEN inSig := locBus
	ELSIF ODD (r DIV rep[Express, (outSig - LBusN) DIV 4, fromDir]) THEN inSig := exprBus
	ELSE RETURN FALSE
	END;
	IF outSig IN {LBusN..LBusE} THEN dRep := RepL ELSE dRep := RepE END;
	CASE outSig OF
		LBusN, EBusN	:	Rep (nrDelay[repU, repV])
	|	LBusS, EBusS	:	Rep (srDelay[repU, repV])
	|	LBusW, EBusW	:	Rep (wrDelay[repU, repV])
	|	LBusE, EBusE	:	Rep (erDelay[repU, repV])
	END;
	IF Deb THEN Str ("Repeater Delay"); Int (u, 3); Int (v, 3); Int (inSig, 3); IF ~found THEN Char ("~") END;Str ("found"); Ln END;
	RETURN found
END Repeater2;

PROCEDURE ^ Cell2 (ga : CLGAs.GA; u, v, outSig, d : INTEGER) : BOOLEAN;

(* no cornerturn: (u MOD Sector) = 0 OR (v MOD Sector) = 0 *)
(* cornerturns (cTurn=TRUE): (u,v) = coordinates of cornerturn cell *)
PROCEDURE Bus2 (ga : CLGAs.GA; u, v, sig, d : INTEGER; cTurn : BOOLEAN) : BOOLEAN;
VAR dir, i, u1, v1 : INTEGER; routing : SHORTINT; found, f : BOOLEAN;
BEGIN
	IF Deb THEN Str ("Bus"); Int (u, 3); Int (v, 3); Int (sig, 3); Int (d, 3); Ln END;
	found := FALSE;
	IF sig IN {LBusN..LBusE} THEN (* check for output to local bus *)
		u1 := u; v1 := v;
		CASE sig OF
			LBusN	:	dir := North; u1 := (u DIV Sector) * Sector (* adjust to start of local bus *)
		|	LBusS	:	dir := South; u1 := (u DIV Sector) * Sector
		|	LBusW	:	dir := West; v1 := (v DIV Sector) * Sector
		|	LBusE	:	dir := East; v1 := (v DIV Sector) * Sector
		END;
		i := 0; f := FALSE;
		WHILE i < Sector DO
			routing := ga.c[u1, v1].routing; IF routing = None THEN routing := Turn0 END;
			IF sig IN {LBusN, LBusS} THEN
				IF ga.c[u1, v1].nsL = dir THEN
					IF (routing IN {Write, TS}) OR ((routing IN {TurnB, Turn0}) & (~cTurn OR (u1 # u))) THEN
						f := Cell2 (ga, u1, v1, sig, d)
					END
				END;
				INC (u1)
			ELSE (* sig IN {LBusW, LBusE} *)
				IF ga.c[u1, v1].weL = dir THEN
					IF (routing IN {Write, TS}) OR ((routing IN {TurnB, Turn0}) & (~cTurn OR (v1 # v))) THEN
						f := Cell2 (ga, u1, v1, sig, d)
					END
				END;
				INC (v1)
			END;
			found := found OR f;
			INC (i)
		END;
		IF cTurn THEN
			IF sig IN {LBusN, LBusS} THEN u := (u DIV Sector) * Sector ELSE v := (v DIV Sector) * Sector END
		END
	END;
	IF ~found THEN found := Repeater2 (ga, u, v, sig, d, Left) END;
	IF ~found THEN found := Repeater2 (ga, u, v, sig, d, Right) END;
	IF ~found THEN
		IF sig = EBusW THEN
			IF (v = 0) & ~ODD (u) THEN found := Cell2 (ga, u, 0, AOut, d)
			ELSIF (v = Dim - Sector) & ODD (u) THEN found := Cell2 (ga, u, Dim - 1, BOut, d)
			END
		ELSIF sig = EBusE THEN
			IF (v = 0) & ~ODD (u) THEN found := Cell2 (ga, u, 0, BOut, d)
			ELSIF (v = Dim - Sector) & ODD (u) THEN found := Cell2 (ga, u, Dim - 1, AOut, d)
			END
		ELSIF sig = EBusN THEN
			IF (u = 0) & ODD (v) THEN found := Cell2 (ga, 0, v, BOut, d)
			ELSIF (u = Dim - Sector) & ~ODD (v) THEN found := Cell2 (ga, Dim - 1, v, AOut, d)
			END
		ELSIF sig = EBusS THEN
			IF (u = 0) & ODD (v) THEN found := Cell2 (ga, 0, v, AOut, d)
			ELSIF (u = Dim - Sector) & ~ODD (v) THEN found := Cell2 (ga, Dim - 1, v, BOut, d)
			END
		END
	END;
	IF Deb THEN Str ("Bus Delay"); Int (u, 3); Int (v, 3); Int (sig, 3); IF ~found THEN Char ("~") END;Str ("found"); Ln END;
	RETURN found
END Bus2;

PROCEDURE Cell2 (ga : CLGAs.GA; u, v, outSig, d : INTEGER) : BOOLEAN;
VAR u1, v1, inSig, d2, dir, uv, save : INTEGER; inputs : SET; found, f : BOOLEAN;
BEGIN
	IF Deb THEN Str ("Cell"); Int (u, 3); Int (v, 3); Int (outSig, 3); Int (d, 3); Ln END;
	found := FALSE;
	IF (u < 0) OR (u = Dim) OR (v < 0) OR (v = Dim) THEN (* border input from either express or IO *)
		IF outSig = AOut THEN
			IF (u = -1) & ~ODD (v) THEN found := Bus2 (ga, 0, v, EBusN, d, FALSE)
			ELSIF (u = Dim) & ODD (v) THEN found := Bus2 (ga, Dim - Sector, v, EBusS, d, FALSE)
			ELSIF (v = -1) & ODD (u) THEN found := Bus2 (ga, u, 0, EBusE, d, FALSE)
			ELSIF (v = Dim) & ~ODD (u) THEN found := Bus2 (ga, u, Dim - Sector, EBusW, d, FALSE)
			ELSIF ((u = -1) & (v = Dim -1)) OR ((u = Dim - 1) & (v = Dim)) THEN found := FALSE (* global clock *)
			ELSIF ((u = 0) & (v = -1)) OR ((u = Dim) & (v = Dim - 1)) THEN found := FALSE (* global reset *)
			ELSE (* input from I/O *)
				IF u < 0 THEN dir := West; v := (v - 1) DIV 2; uv := v
				ELSIF u = Dim THEN dir := East; v := (v - 1) DIV 2; uv := v
				ELSIF v < 0 THEN dir := South; u := (u - 1) DIV 2; uv := u
				ELSE (* v = Dim *) dir := North; u := (u - 1) DIV 2; uv := u
				END;
				found := ioDelay[dir, uv].onPath OR (InTime (d + ioDelay[dir, uv].delay) & OnMaxPath (u, v, outSig));
				ioDelay[dir, uv].onMaxPath := found;
				IF found & (perform # NIL) THEN perform (ga, u, v, outSig, IO, d + IOIn) END
			END
		ELSE (* outSig = BOut *)
			IF u = -1 THEN
				IF ~ODD (v) THEN found := Bus2 (ga, 0, v, EBusS, d, FALSE)
				ELSIF v < Dim - 1 THEN found := Cell2 (ga, 0, v + 1, BOut, d)
				END
			ELSIF u = Dim THEN
				IF ODD (v) THEN found := Bus2 (ga, Dim - Sector, v, EBusN, d, FALSE)
				ELSIF v > 0 THEN found := Cell2 (ga, Dim - 1, v - 1, BOut, d)
				END
			ELSIF v = -1 THEN
				IF ODD (u) THEN found := Bus2 (ga, u, 0, EBusW, d, FALSE)
				ELSIF u > 0 THEN found := Cell2 (ga, u - 1, 0, BOut, d)
				END
			ELSIF v = Dim THEN
				IF ~ODD (u) THEN found := Bus2 (ga, u, Dim - Sector, EBusE, d, FALSE)
				ELSIF u < Dim - 1 THEN found := Cell2 (ga, u + 1, Dim - 1, BOut, d)
				END
			END
		END
	ELSIF cDelay[u, v, T (outSig)].onPath & InTime (d + cDelay[u, v, T (outSig)].delay) THEN
		IF cDelay[u, v, T (outSig)].pass < pass THEN
			cDelay[u, v, T (outSig)].pass := pass;
			IF (outSig IN {LBusN..LBusE}) & ((ga.c[u, v].routing = None) OR (ga.c[u, v].routing IN {TurnB, Turn0})) THEN
				IF outSig IN {LBusN, LBusS} THEN (* cornerturn *)
					IF ga.c[u, v].weL = West THEN found := Bus2 (ga, u, v, LBusW, d, TRUE)
					ELSE found := Bus2 (ga, u, v, LBusE, d, TRUE)
					END
				ELSE (* cornerturn, outSig IN {LBusE, LBusW} *)
					IF ga.c[u, v].nsL = North THEN found := Bus2 (ga, u, v, LBusN, d, TRUE)
					ELSE found := Bus2 (ga, u, v, LBusS, d, TRUE)
					END
				END
			ELSE (* outSig IN {AOut, BOut, LBusN..LBusE}, no cornerturn *)
				CellInputs (ga, u, v, outSig, inputs, TRUE);
				IF inputs * {AOut..LBusE} # {} THEN (* input from neighboring cell/bus *)
					save := cDelay[u, v, T (outSig)].delay; (* prepare for feedback cycles *)
					cDelay[u, v, T (outSig)].delay := 0;
					inSig := AOut;
					REPEAT
						IF inSig IN inputs THEN
							d2 := CellDelay (ga, u, v, inSig, outSig);
							Neighbor (ga, u, v, inSig, u1, v1);
							IF inSig IN {AOut, BOut} THEN f := Cell2 (ga, u1, v1, inSig, d + d2)
							ELSE f := Bus2 (ga, u1, v1, inSig, d + d2, FALSE)
							END;
							found := found OR f
						END;
						INC (inSig)
					UNTIL inSig > LBusE;
					cDelay[u, v, T (outSig)].delay :=save
				ELSE (* inputs = {} OR inputs = {FF} *)
					found := OnMaxPath (u, v, T(outSig));
					IF inputs = {FF} THEN INC (d, CellDelay (ga, u, v, -1, outSig)) END
				END
			END
		ELSE (* cDelay[u, v, T (outSig)].pass = pass *)
			found := TRUE (* always TRUE, since we're on path and in time, ignore previous values of onMaxPath *)
		END;
		cDelay[u, v, T (outSig)].onMaxPath := found;
		IF found & (perform # NIL) THEN perform (ga, u, v, outSig, Cell, d) END
	END;
	IF Deb THEN Str ("Cell Delay"); Int (u, 3); Int (v, 3); Int (outSig, 3); IF ~found THEN Str (" ~") END;Str ("found"); Ln END;
	RETURN found
END Cell2;

PROCEDURE StartCell2 (ga : CLGAs.GA; u, v, outSig, d : INTEGER) : BOOLEAN;
VAR u1, v1, inSig, save : INTEGER; inputs : SET; found, f : BOOLEAN;
BEGIN
	found := FALSE;
	IF cDelay[u, v, T (outSig)].onPath & InTime (d + cDelay[u, v, T (outSig)].delay) THEN
		cDelay[u, v, T (outSig)].onMaxPath := TRUE;
		IF (outSig = AOut) & (ga.c[u, v].state = State3) THEN (* skip FF *)
			save := cDelay[u, v, T (outSig)].delay;
			cDelay[u, v, T (outSig)].delay := CellDelay (ga, u, v, -1, T (outSig)); (* for cycles with output *)
			CellInputs (ga, u, v, outSig, inputs, FALSE);
			inSig := AOut;
			REPEAT
				IF inSig IN inputs THEN
					Neighbor (ga, u, v, inSig, u1, v1);
					IF inSig IN {AOut, BOut} THEN f := Cell2 (ga, u1, v1, inSig, d + RegSet)
					ELSE f := Bus2 (ga, u1, v1, inSig, d + RegSet, FALSE)
					END;
					found := found OR f
				END;
				INC (inSig)
			UNTIL inSig > LBusE;
			cDelay[u, v, T (outSig)].onMaxPath := found;
			cDelay[u, v, T (outSig)].delay := save;
			IF found & (perform # NIL) THEN perform (ga, u, v, outSig, Cell, d) END
		ELSE found := Cell2 (ga, u, v, outSig, d)
		END
	END;
	RETURN found
END StartCell2;

PROCEDURE StartIO2 (ga : CLGAs.GA; u, v, d : INTEGER) : BOOLEAN;
VAR dir, sel, u1, v1, uv, save : INTEGER; found : BOOLEAN;
BEGIN
	u1 := u; v1 := v; found := FALSE;
	IF u < 0 THEN dir := West; uv := v; u := 0; v := 2 * v + 2
	ELSIF u = Dim THEN dir := East; uv := v; u := Dim - 1; v := 2 * v + 1
	ELSIF v < 0 THEN dir := South; uv := u; u := 2 * u + 1; v := 0
	ELSE dir := North; uv := u; u := 2 * u + 2; v := Dim - 1
	END;
	IF ioDelay[dir, uv].onPath & InTime (d + ioDelay[dir, uv].delay) THEN
		ioDelay[dir, uv].onMaxPath := TRUE;
		save := ioDelay[dir, uv].delay;
		ioDelay[dir, uv].delay := 0;
		sel := ga.p[dir, uv].selector;
		ioDelay[dir, uv].pass := pass; (* mark IO *)
		CASE sel OF
		|	TSOff, TSOn	:	(* do nothing *)
		|	TSSerial		:	CASE dir OF
								|	North	:	found := Bus2 (ga, u, (v DIV Sector) * Sector, LBusW, d + IOEn, FALSE)
								|	South	:	found := Bus2 (ga, u, (v DIV Sector) * Sector, LBusE, d + IOEn, FALSE)
								|	West		:	found := Bus2 (ga, (u DIV Sector) * Sector, v, LBusS, d + IOEn, FALSE)
								|	East		:	found := Bus2 (ga, (u DIV Sector) * Sector, v, LBusN, d + IOEn, FALSE)
								END
		|	TSParallel	:	CASE dir OF
								|	North	:	found := Bus2 (ga, (u DIV Sector) * Sector, v, LBusN, d + IOEn, FALSE)
								|	South	:	found := Bus2 (ga, (u DIV Sector) * Sector, v, LBusS, d + IOEn, FALSE)
								|	West		:	found := Bus2 (ga, u, (v DIV Sector) * Sector, LBusW, d + IOEn, FALSE)
								|	East		:	found := Bus2 (ga, u, (v DIV Sector) * Sector, LBusE, d + IOEn, FALSE)
								END
		END;
		IF sel # TSOff THEN found := Cell2 (ga, u, v, AOut, d + IOOut) END;
		found := TRUE;
		ioDelay[dir, uv].delay := save;
		IF perform # NIL THEN perform (ga, u1, v1, AOut, IO, d) END
	END;
	RETURN found
END StartIO2;

PROCEDURE Init (u, v, sig : INTEGER);
VAR i, j : INTEGER;
BEGIN
	destU := u; destV := v; destSig := sig;
	i := 0;
	WHILE i < Dim DO
		j := 0;
		WHILE j < Dim DO
			cDelay [i, j, AOut].delay := 0; cDelay [i, j, AOut].onMaxPath := FALSE; cDelay [i, j, AOut].onPath := FALSE;
			cDelay [i, j,BOut].delay := 0; cDelay [i, j, BOut].onMaxPath := FALSE; cDelay [i, j, BOut].onPath := FALSE;
			cDelay [i, j, LOut].delay := 0; cDelay [i, j, LOut].onMaxPath := FALSE; cDelay [i, j, LOut].onPath := FALSE;
			INC (j)
		END;
		INC (i)
	END;
	i := 0;
	WHILE i < (Dim DIV 2) - 1 DO
		ioDelay [North, i].delay := 0; ioDelay [North, i].onMaxPath := FALSE; ioDelay [North, i].onPath := FALSE;
		ioDelay [South, i].delay := 0; ioDelay [South, i].onMaxPath := FALSE; ioDelay [South, i].onPath := FALSE;
		ioDelay [West, i].delay := 0; ioDelay [West, i].onMaxPath := FALSE; ioDelay [West, i].onPath := FALSE;
		ioDelay [East, i].delay := 0; ioDelay [East, i].onMaxPath := FALSE; ioDelay [East, i].onPath := FALSE;
		INC (i)
	END;
	i := 0;
	WHILE i < Dim DO
		j := 0;
		WHILE j < (Dim DIV Sector) - 1 DO
			nrDelay [j, i, 0].delay := 0; nrDelay [j, i, 0].input := None;
			nrDelay [j, i, 0].onMaxPath := FALSE; nrDelay [j, i, 0].onPath := FALSE;
			nrDelay [j, i, 1].delay := 0; nrDelay [j, i, 1].input := None;
			nrDelay [j, i, 1].onMaxPath := FALSE; nrDelay [j, i, 1].onPath := FALSE;
			srDelay [j, i, 0].delay := 0; srDelay [j, i, 0].input := None;
			srDelay [j, i, 0].onMaxPath := FALSE; srDelay [j, i, 0].onPath := FALSE;
			srDelay [j, i, 1].delay := 0; srDelay [j, i, 1].input := None;
			srDelay [j, i, 1].onMaxPath := FALSE; srDelay [j, i, 1].onPath := FALSE;
			wrDelay [i, j, 0].delay := 0; wrDelay [i, j, 0].input := None;
			wrDelay [i, j, 0].onMaxPath := FALSE; wrDelay [i, j, 0].onPath := FALSE;
			wrDelay [i, j, 1].delay := 0; wrDelay [i, j, 1].input := None;
			wrDelay [i, j, 1].onMaxPath := FALSE; wrDelay [i, j, 1].onPath := FALSE;
			erDelay [i, j, 0].delay := 0; erDelay [i, j, 0].input := None;
			erDelay [i, j, 0].onMaxPath := FALSE; erDelay [i, j, 0].onPath := FALSE;
			erDelay [i, j, 1].delay := 0; erDelay [i, j, 1].input := None;
			erDelay [i, j, 1].onMaxPath := FALSE; erDelay [i, j, 1].onPath := FALSE;
			INC (j)
		END;
		INC (i)
	END
END Init;

PROCEDURE Path (ga : CLGAs.GA; inU, inV, inSig, outU, outV, outSig : INTEGER; h : Handler) : INTEGER;
VAR f, path : BOOLEAN;
BEGIN
	IF Deb THEN Str ("Phase 1"); Ln END;
	perform := h;
	INC (pass); dMax := Constant;
	Init (inU, inV, inSig);
	IF (outU < 0) OR (outU = Dim) OR (outV < 0) OR (outV = Dim) THEN dMax := StartIO1 (ga, outU, outV)
	ELSIF outSig IN {AOut, BOut} THEN dMax := StartCell1 (ga, outU, outV, outSig)
	ELSE dMax := Bus1 (ga, outU, outV, outSig, FALSE, path)
	END;
	IF Deb THEN Str ("Phase 2, max. delay was "); Int (dMax, 5); Ln END;
	IF dMax >= 0 THEN
		INC (pass);
		IF (outU < 0) OR (outU = Dim) OR (outV < 0) OR (outV = Dim) THEN f := StartIO2 (ga, outU, outV, 0)
		ELSIF outSig IN {AOut, BOut} THEN f := StartCell2 (ga, outU, outV, outSig, 0)
		ELSE f := Bus2 (ga, outU, outV, outSig, 0, FALSE)
		END
	END;
	RETURN dMax
END Path;

PROCEDURE AllPaths* (ga : CLGAs.GA; inU, inV, inSig, outU, outV, outSig : INTEGER; h : Handler) : INTEGER;
BEGIN
	allPaths := TRUE;
	RETURN Path (ga, inU, inV, inSig, outU, outV, outSig, h)
END AllPaths;

PROCEDURE MaxPath* (ga : CLGAs.GA; inU, inV, inSig, outU, outV, outSig : INTEGER; h : Handler) : INTEGER;
BEGIN
	allPaths := FALSE;
	RETURN Path (ga, inU, inV, inSig, outU, outV, outSig, h)
END MaxPath;

PROCEDURE GetCell* (u, v, sig : INTEGER; VAR delay : INTEGER; VAR onPath, onMaxPath : BOOLEAN);
BEGIN
	delay := cDelay[u, v, T (sig)].delay;
	onPath := cDelay[u, v, T (sig)].onPath;
	onMaxPath := cDelay[u, v, T (sig)].onMaxPath
END GetCell;

PROCEDURE GetIO* (u, v, sig : INTEGER; VAR delay : INTEGER; VAR onPath, onMaxPath : BOOLEAN);
VAR dir, uv : INTEGER;
BEGIN
	IF u < 0 THEN dir := West; uv := v
	ELSIF u = Dim THEN dir := East; uv := v
	ELSIF v < 0 THEN dir := South; uv := u
	ELSE (* v = Dim *) dir := North; uv := u
	END;
	delay := ioDelay[dir, uv].delay;
	onPath := ioDelay[dir, uv].onPath;
	onMaxPath := ioDelay[dir, uv].onMaxPath
END GetIO;

PROCEDURE GetRepeater* (u, v, sig : INTEGER; VAR delay : INTEGER; VAR onPath, onMaxPath : BOOLEAN);
VAR r : RepDelay; dir : SHORTINT;
BEGIN
	dir := SHORT (sig DIV 16); sig := sig MOD 16;
	CASE sig OF
		LBusN, EBusN	:	r := nrDelay[u, v]
	|	LBusS, EBusS	:	r := srDelay[u, v]
	|	LBusW, EBusW	:	r := wrDelay[u, v]
	|	LBusE, EBusE	:	r := erDelay[u, v]
	END;
	IF (r[0].input = sig) & (r[0].dir = dir) THEN delay := r[0].delay; onPath := r[0].onPath; onMaxPath := r[0].onMaxPath
	ELSE delay := r[1].delay; onPath := r[1].onPath; onMaxPath := r[1].onMaxPath
	END
END GetRepeater;

BEGIN
	Texts.OpenWriter (W);
	perform := NIL; showErr := TRUE;
	rep [Express, Express, Left] := EEWE; rep [Local, Express, Left] := LEWE;
	rep [Local, Local, Left] := LLWE; rep [Express, Local, Left] := ELWE;
	rep [Express, Express, Right] := EEEW; rep [Local, Express, Right] := LEEW;
	rep [Local, Local, Right] := LLEW; rep [Express, Local, Right] := ELEW;
	pass := 0; i := 0;
	WHILE i < Dim DO
		j := 0;
		WHILE j < Dim DO
			cDelay [i, j, 0].pass := 0; cDelay [i, j, 1].pass := 0; cDelay [i, j, 2].pass := 0;
			INC (j)
		END;
		INC (i)
	END;
	i := 0;
	WHILE i < (Dim DIV 2) - 1 DO
		ioDelay [North, i].pass := 0; ioDelay [South, i].pass := 0;
		ioDelay [West, i].pass := 0; ioDelay [East, i].pass := 0;
		INC (i)
	END;
	i := 0;
	WHILE i < Dim DO
		j := 0;
		WHILE j < (Dim DIV Sector) - 1 DO
			nrDelay [j, i, 0].pass := 0; nrDelay [j, i, 1].pass := 0;
			srDelay [j, i, 0].pass := 0; srDelay [j, i, 1].pass := 0;
			wrDelay [i, j, 0].pass := 0; wrDelay [i, j, 1].pass := 0;
			erDelay [i, j, 0].pass := 0; erDelay [i, j, 1].pass := 0;
			INC (j)
		END;
		INC (i)
	END
END CLAnalyze.
