
  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt  $      StampElems Alloc 2 Jun 94                  0             nN '  LineElems Alloc  J   
                8  FoldElems New      8   )    
                8       8   V    8   K  Syntax10b.Scn.Fnt          8   $    8       8   7    8      8   &    8   `        \            %            G        G        ^   8   (    8               G           8       *    08 '   
                                    b    8      8                       ,        K    8      8                   
                8      8               8   G   8               8   v    8                               
                    8   m   8                       $    8      8   
        4            8          r   8               8             8               8      8               8      8   
            8      8               8   )   8               8       8               8       8       
        8   	   8   
                                    8   9    8                               8   8            8   %    8      8                                           8   Z   8                                   8      8   
            (    ,        +            J        	                    
        +            J        	                    
        /            _            
        /            _            3    [Y  MODULE CL;	(** sg 26 Oct 92 / SHML 20 Jan 93 /  **)
	(* sg 7 Oct 93: inserted pass gate command, changed Inspect accordingly *)
	(* 25 Apr 94: LabelA, LabelB, DeleteA, DeleteB for automatic labelling *)
	(* 27 Apr 94: Undo, comment in Print command *)

	IMPORT
		CLGAs, Fr := CLFramesD, CLFrames, CLLoader, Files, Viewers,
		Texts, Oberon, MenuViewers, TextFrames, Printer;

	CONST Version = "CL_Editor  (SHML  2 Jun 94)"; Wirth = FALSE;
	VAR W: Texts.Writer; first: BOOLEAN;

	(* Support *) 

	PROCEDURE Min(VAR x: INTEGER; y: INTEGER);	BEGIN IF y < x THEN x := y END END Min;
	PROCEDURE Max(VAR x: INTEGER; y: INTEGER);	BEGIN IF y > x THEN x := y END END Max;

	PROCEDURE Str(s: ARRAY OF CHAR);	BEGIN Texts.WriteString(W, s) END Str;
	PROCEDURE Char(ch: CHAR);	BEGIN Texts.Write(W, ch) END Char;
	PROCEDURE Int(i: LONGINT);	BEGIN Texts.Write(W, " "); Texts.WriteInt(W, i, 0) END Int;
	PROCEDURE Ln;	BEGIN Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf) END Ln;
	PROCEDURE Append;	BEGIN Texts.Append(Oberon.Log, W.buf) END Append;

	PROCEDURE SetupSel(VAR s: Texts.Scanner);	(* Set up s on last text selection *)	
		VAR sel: Texts.Text; beg, end, time: LONGINT;
	BEGIN
		Oberon.GetSelection(sel, beg, end, time);
		IF time >= 0 THEN Texts.OpenScanner(s, sel, beg); Texts.Scan(s) END
	END SetupSel;

	PROCEDURE Setup(VAR s: Texts.Scanner);	(* Set up s on parameter list *)	
	BEGIN
		Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(s);
		IF (s.class = Texts.Char) & (s.line = 0) & (s.c = "^") THEN SetupSel(s) END
	END Setup;

	PROCEDURE MenuFrame(name, fileName, defaultMenu: ARRAY OF CHAR): TextFrames.Frame;	
		VAR mf: TextFrames.Frame; t: Texts.Text; buf: Texts.Buffer;
	BEGIN
		IF Files.Old(fileName) = NIL THEN mf := TextFrames.NewMenu(name, defaultMenu)
		ELSE
			mf := TextFrames.NewMenu(name, "");
			NEW(t); Texts.Open(t, fileName);
			NEW(buf); Texts.OpenBuf(buf); Texts.Save(t, 0, t.len, buf); Texts.Append(mf.text, buf)
		END;
		RETURN mf
	END MenuFrame;

	PROCEDURE Toggle(bit: SHORTINT);	
		VAR f: Fr.Frame;
	BEGIN
		CLFrames.GetParFrame(f);
		IF f # NIL THEN f.mode := f.mode / {bit}; Fr.Restore(f) END
	END Toggle;

	PROCEDURE ClockResetInfo(VAR a: ARRAY OF SHORTINT);	
		VAR i, j, k: SHORTINT;
	BEGIN
		i := 0;
		WHILE i < CLGAs.Dim DO
			k := a[i]; j := i+1;
			WHILE (j < CLGAs.Dim) & (a[j] = k) DO INC(j) END;
			Int(i);
			IF (j < CLGAs.Dim) & (j # i+1) OR (j = CLGAs.Dim) THEN Str(" .."); Int(j-1) END;
			Str(": ");
			CASE k OF
			| CLGAs.ClkAout: Str("Aout")
			| CLGAs.ClkGlobal: Str("Global")
			| CLGAs.ClkExpress: Str("Express")
			| CLGAs.ClkOne: Str("Off")
			END;
			Str("  "); i := j
		END;
		Ln
	END ClockResetInfo;

	PROCEDURE SetLabels(sig: INTEGER);	
		VAR
			i, x, y, dx, dy, start, num: INTEGER;
			label: ARRAY 32 OF CHAR;
			f: Fr.Frame; s: Texts.Scanner;

		PROCEDURE Insert(ga: CLGAs.GA; u, v, signal: INTEGER; VAR lab: ARRAY OF CHAR);
			VAR old: CLGAs.Label; name: ARRAY 32 OF CHAR;
		BEGIN
			old := CLGAs.This(ga, lab);
			IF (old = NIL) OR (old.u = u) & (old.v = v) & (old.sig = signal) THEN	(* delete old and insert new *) 
				CLGAs.Delete(ga, u, v, signal, name); CLGAs.Insert(ga, label, u, v, signal, old);
				ASSERT(old = NIL, 99)
			ELSE	(* label exists at other position *) 
				Str(lab); Str(" already defined at"); Int(old.u); Int(old.v); Ln
			END
		END Insert;

	BEGIN
		CLFrames.GetParFrame(f); Setup(s);
		IF s.class # Texts.String THEN RETURN END;
		COPY(s.s, label); Texts.Scan(s);
		IF s.class # Texts.Int THEN RETURN END;
		dx := SHORT(s.i); Texts.Scan(s);
		IF s.class # Texts.Int THEN RETURN END;
		dy := SHORT(s.i); Texts.Scan(s);
		IF s.class = Texts.Int THEN start := ABS(SHORT(s.i)) MOD 10 ELSE start := 0 END;
		IF ((dx # 0) OR (dy # 0)) & (f # NIL) & (f.selTyp = Fr.cellSel) THEN
			CLFrames.Backup(f);
			i := -1; REPEAT INC(i) UNTIL (label[i] = "*") OR (label[i] = 0X);
			IF label[i] = 0X THEN label[i+1] := 0X END;
			num := start; x := f.selU; y := f.selV;
			IF ABS(dx) > 0 THEN
				WHILE x < f.selU+f.selW DO
					label[i] := CHR(ORD("0")+num); Insert(f.a, x, y, sig, label);
					IF dx > 0 THEN num := (num+1) MOD 10 ELSE num := (num-1) MOD 10 END;
					INC(x, ABS(dx))
				END
			ELSE
				WHILE y < f.selV+f.selH DO
					label[i] := CHR(ORD("0")+num); Insert(f.a, x, y, sig, label);
					IF dy > 0 THEN num := (num+1) MOD 10 ELSE num := (num-1) MOD 10 END;
					INC(y, ABS(dy))
				END
			END;
			CLFrames.Update(f)
		END
	END SetLabels;

	PROCEDURE DeleteLabels(sig: INTEGER);	
		VAR
			x, y, dx, dy: INTEGER;
			label: ARRAY 32 OF CHAR;
			f: Fr.Frame; s: Texts.Scanner;
	BEGIN
		CLFrames.GetParFrame(f); Setup(s);
		IF s.class # Texts.Int THEN RETURN END;
		dx := SHORT(s.i); Texts.Scan(s);
		IF s.class # Texts.Int THEN RETURN END;
		dy := SHORT(s.i);
		IF ((dx # 0) OR (dy # 0)) & (f # NIL) & (f.selTyp = Fr.cellSel) THEN
			CLFrames.Backup(f);
			x := f.selU; y := f.selV; dx := ABS(dx); dy := ABS(dy);
			IF dx > 0 THEN
				WHILE x < f.selU+f.selW DO CLGAs.Delete(f.a, x, y, sig, label); INC(x, dx) END
			ELSE
				WHILE y < f.selV+f.selH DO CLGAs.Delete(f.a, x, y, sig, label); INC(y, dy) END
			END;
			CLFrames.Update(f)
		END
	END DeleteLabels;

	(** Commands and exported procedures **) 

	PROCEDURE Locate*;	(** (x y) | name | "^"	Locate cell/pad with coords x, y or
		label name in marked/selected viewer, if command in menuframe and not followed by int, treat it like "^" **)
		VAR u: INTEGER; l: CLGAs.Label; f: Fr.Frame; s: Texts.Scanner;
	BEGIN
		CLFrames.GetParFrame(f);
		IF f # NIL THEN
			Setup(s);
			IF (Oberon.Par.frame = Oberon.Par.vwr.dsc) & (s.class # Texts.Int) THEN SetupSel(s) END;
			IF (s.class = Texts.Name) OR (s.class = Texts.String) THEN
				l := CLGAs.This(f.a, s.s);
				IF l = NIL THEN s.s[s.len] := "'"; s.s[s.len+1] := 0X; l := CLGAs.This(f.a, s.s) END;
				IF l # NIL THEN Fr.Position(f, l.u, l.v); Fr.Select(f, l.u, l.v) END
			ELSIF s.class = Texts.Int THEN
				u := SHORT(s.i); Texts.Scan(s);
				IF s.class = Texts.Int THEN Fr.Position(f, u, SHORT(s.i)); Fr.Select(f, u, SHORT(s.i)) END
			END
		END
	END Locate;

	PROCEDURE Array*;	(** prefix | "^"	Locate array of cells or pad starting with prefix
		in marked/selected viewer, if command in menuframe treat it like "^" **)
		VAR s: Texts.Scanner; f: Fr.Frame; l: CLGAs.Label; minU, minV, maxU, maxV, i: INTEGER;
	BEGIN
		CLFrames.GetParFrame(f);
		IF Oberon.Par.frame = Oberon.Par.vwr.dsc THEN SetupSel(s) ELSE Setup(s) END;
		IF (f # NIL) & (s.class = Texts.Name) THEN
			l := f.a.first; minU := MAX(INTEGER); minV := minU; maxU := MIN(INTEGER); maxV := maxU;
			WHILE l # NIL DO
				i := -1; REPEAT INC(i) UNTIL (i = CLGAs.LabelLen) OR (s.s[i] # l.name[i]) OR (i = s.len);
				IF (i # CLGAs.LabelLen) & ((s.s[i] = l.name[i]) OR (l.name[i] = ".") OR (i = s.len)) THEN
					Min(minU, l.u); Min(minV, l.v); Max(maxU, l.u); Max(maxV, l.v)
				END;
				l := l.next
			END;
			IF (minU # MAX(INTEGER)) & (minV # MAX(INTEGER)) & (maxU # MIN(INTEGER)) & (maxV # MIN(INTEGER)) THEN
				IF minU < 0 THEN maxU := minU ELSIF maxU >= CLGAs.Dim THEN minU := maxU END;
				IF minV < 0 THEN maxV := minV ELSIF maxV >= CLGAs.Dim THEN minV := maxV END;
				Fr.Position(f, minU, minV);
				IF (minU < 0) OR (minV < 0) OR (maxU >= CLGAs.Dim) OR (maxV >= CLGAs.Dim) THEN
					Fr.Select(f, minU, minV)
				ELSE Fr.SelectCells(f, minU, minV, maxU-minU+1, maxV-minV+1, FALSE)
				END
			END
		END
	END Array;

	PROCEDURE Open*;	(** name | "^"	Open viewer showing design name **)	
		VAR s: Texts.Scanner; f: Fr.Frame; a: CLGAs.GA; v: Viewers.Viewer; x, y, res: INTEGER;
	BEGIN
		Setup(s);
		IF s.class = Texts.Name THEN
			IF first THEN Str(Version); Ln; first := FALSE END;
			NEW(a); CLGAs.Open(a, s.s, res);
			IF res = 0 THEN
				CLFrames.ShiftIO(a, FALSE);
				NEW(f); CLFrames.Open(f, a);
				Oberon.AllocateUserViewer(Oberon.Mouse.X, x, y);
				v := MenuViewers.New(
					MenuFrame(s.s, "CL.Menu.Text",
						"System.Close  System.Copy  System.Grow  CL.Locate  CL.Array  CL.Cells  CL.Load  CL.Undo  CL.Store "
					), f, TextFrames.menuH, x, y
				)
			ELSE Str("not a valid CLi file"); Ln
			END
		END
	END Open;

	PROCEDURE Store*;	
		VAR
			a: CLGAs.GA;
			s: Texts.Scanner; menu: TextFrames.Frame; t: Texts.Text;
			len: LONGINT;
			bak: ARRAY 64 OF CHAR; i, res: INTEGER;
	BEGIN
		IF Oberon.Par.frame = Oberon.Par.vwr.dsc THEN
			menu := Oberon.Par.vwr.dsc(TextFrames.Frame); t := menu.text;
			Texts.OpenScanner(s, t, 0); Texts.Scan(s);
			IF s.class = Texts.Name THEN
				Str(s.s); Str(" storing"); Append;
				COPY(s.s, bak); i := 0;
				WHILE bak[i] # 0X DO INC(i) END;
				bak[i] := "."; bak[i+1] := "B"; bak[i+2] := "a"; bak[i+3] := "k"; bak[i+4] := 0X;
				Files.Rename(s.s, bak, res);
				a := menu.next(Fr.Frame).a;
				CLFrames.ShiftIO(a, TRUE); CLGAs.Store(a, s.s, len); CLFrames.ShiftIO(a, FALSE);
				Int(len); Ln;
				Texts.OpenReader(s, t, t.len-1); Texts.Read(s, s.c);
				IF s.c = "!" THEN Texts.Delete(t, t.len-1, t.len) END
			END
		END
	END Store;

	PROCEDURE Undo*;	
	BEGIN
		IF Oberon.Par.frame = Oberon.Par.vwr.dsc THEN CLFrames.Undo(Oberon.Par.frame.next(Fr.Frame)) END
	END Undo;

	PROCEDURE Print*;
		(** (name [col] [comment]) | "^"	Print marked viewer on server name starting at 0 <= col < 16, add comment **)
		VAR x: INTEGER; s: Texts.Scanner; v: Viewers.Viewer; comment: ARRAY 32 OF CHAR;
	BEGIN
		IF Wirth THEN
			Setup(s);
			IF s.class = Texts.Int THEN x := SHORT(s.i) ELSE x := 0 END;
			Texts.Scan(s);
			IF (s.class = Texts.Name) OR (s.class = Texts.String) THEN COPY(s.s, comment) ELSE comment := "" END;
			IF (x >= 0) & (x < 16) THEN
				v := Oberon.MarkedViewer();
				IF (v.dsc # NIL) & (v.dsc.next IS Fr.Frame) THEN
					Texts.OpenScanner(s, v.dsc(TextFrames.Frame).text, 0); Texts.Scan(s);
					Str(s.s); Str(" printing"); Ln;
					CLFrames.Print(v.dsc(TextFrames.Frame).next(Fr.Frame), x, s.s, comment)
				END
			END
		ELSE
			Setup(s);
			IF s.class = Texts.Name THEN
				Printer.Open(s.s, Oberon.User, Oberon.Password);
				IF Printer.res = 0 THEN
					Texts.Scan(s);
					IF s.class = Texts.Int THEN x := SHORT(s.i) ELSE x := 0 END;
					Texts.Scan(s);
					IF (s.class = Texts.Name) OR (s.class = Texts.String) THEN COPY(s.s, comment) ELSE comment := "" END;
					IF (x >= 0) & (x < 16) THEN
						v := Oberon.MarkedViewer();
						IF (v.dsc # NIL) & (v.dsc.next IS Fr.Frame) THEN
							Texts.OpenScanner(s, v.dsc(TextFrames.Frame).text, 0); Texts.Scan(s);
							Str("CL.Print "); Str(s.s); Append;
							CLFrames.Print(v.dsc.next(Fr.Frame), x, s.s, comment);
							Str(" ."); Ln
						END
					END;
					Printer.Close
				ELSE
					IF Printer.res = 1 THEN Str(" no printer")
					ELSIF Printer.res = 2 THEN Str(" no link")
					ELSIF Printer.res = 3 THEN Str(" printer not ready")
					ELSIF Printer.res = 4 THEN Str(" no permission")
					END;
					Ln
				END
			ELSE Str(" no printer specified"); Ln
			END
		END
	END Print;

	PROCEDURE Load*;	(** frame below | name | "^"	Load configuration to CLi_board **)
		VAR s: Texts.Scanner; ga: CLGAs.GA; res: INTEGER;
	BEGIN
		IF Oberon.Par.frame = Oberon.Par.vwr.dsc THEN
			ga := Oberon.Par.vwr.dsc.next(Fr.Frame).a; CLFrames.ShiftIO(ga, TRUE);
			Texts.OpenScanner(s, Oberon.Par.vwr.dsc(TextFrames.Frame).text, 0); Texts.Scan(s);
			res := 0
		ELSE
			Setup(s); NEW(ga);
			IF s.class # Texts.Name THEN s.s := "" END;
			CLGAs.Open(ga, s.s, res)
		END;
		IF res = 0 THEN
			Str("loading "); Str(s.s); Append;
			CLLoader.Load(ga, FALSE); CLFrames.ShiftIO(ga, FALSE)
		END
	END Load;

	PROCEDURE Cells*;	BEGIN Toggle(Fr.cellMode) END Cells;

	PROCEDURE SetClock*;	
		VAR s: Texts.Scanner; f: Fr.Frame; ga: CLGAs.GA; val: SHORTINT; i: INTEGER;
	BEGIN
		CLFrames.GetParFrame(f);
		IF f # NIL THEN
			Setup(s);
			IF (s.class = Texts.Name) & f.selected & (f.selTyp = Fr.cellSel) & (f.selV = CLGAs.Dim-1) THEN
				IF s.s = "Aout" THEN val := CLGAs.ClkAout
				ELSIF s.s = "Global" THEN val := CLGAs.ClkGlobal
				ELSIF s.s = "Express" THEN val := CLGAs.ClkExpress
				ELSIF s.s = "Off" THEN val := CLGAs.ClkOne
				ELSE RETURN
				END;
				CLFrames.Backup(f);
				ga := f.a; Str("clock of column");
				IF f.selW = 1 THEN ga.clk[f.selU] := val; Int(f.selU)
				ELSE
					i := f.selU;
					WHILE i < f.selU+f.selW DO ga.clk[i] := val; INC(i) END;
					Char("s"); Int(f.selU); Str(".."); Int(f.selU+f.selW-1)
				END;
				CLFrames.Update(f);
				Str(": "); Str(s.s); Ln
			END
		END
	END SetClock;

	PROCEDURE SetReset*;	
		VAR s: Texts.Scanner; f: Fr.Frame; ga: CLGAs.GA; val: SHORTINT; i: INTEGER;
	BEGIN
		CLFrames.GetParFrame(f);
		IF f # NIL THEN
			Setup(s);
			IF (s.class = Texts.Name) & f.selected & (f.selTyp = Fr.cellSel) & (f.selV = 0) THEN
				IF s.s = "Aout" THEN val := CLGAs.ClkAout
				ELSIF s.s = "Global" THEN val := CLGAs.ClkGlobal
				ELSIF s.s = "Express" THEN val := CLGAs.ClkExpress
				ELSIF s.s = "Off" THEN val := CLGAs.ClkOne
				ELSE RETURN
				END;
				CLFrames.Backup(f);
				ga := f.a; Str("reset of column");
				IF f.selW = 1 THEN ga.res[f.selU] := val; Int(f.selU)
				ELSE
					i := f.selU;
					WHILE i < f.selU+f.selW DO ga.res[i] := val; INC(i) END;
					Char("s"); Int(f.selU); Str(".."); Int(f.selU+f.selW-1)
				END;
				CLFrames.Update(f);
				(*ELSE i := 0; WHILE i < CLGAs.Dim DO ga.res[i] := val; INC(i) END; Str("s 0..31")*)
				Str(": "); Str(s.s); Ln
			END
		END
	END SetReset;

	PROCEDURE SetPassGate*;	
		VAR s: Texts.Scanner; f: Fr.Frame; t, p : INTEGER;
	BEGIN
		CLFrames.GetParFrame(f);
		IF (f # NIL) & f.selected & (f.selTyp IN {Fr.eRepSel, Fr.sRepSel}) THEN
			Setup(s);
			IF s.class = Texts.Name THEN
				IF s.s = "On" THEN t := 0; p := CLGAs.PassGate
				ELSIF s.s = "Off" THEN t := 1; p := -CLGAs.PassGate
				ELSE t := 2; p := 0
				END;
				CLFrames.Backup(f);
				IF f.selTyp = Fr.eRepSel THEN
					IF f.a.vr[f.selU, f.selV].e DIV CLGAs.PassGate = t THEN INC(f.a.vr[f.selU, f.selV].e, p) END
				ELSE
					IF f.a.hr[f.selU, f.selV].s DIV CLGAs.PassGate = t THEN INC(f.a.hr[f.selU, f.selV].s, p) END
				END;
				CLFrames.Update(f)
			END
		END
	END SetPassGate;

	PROCEDURE LabelBus*;	
		VAR
			s: Texts.Scanner; Sel: Texts.Text; beg, end, time: LONGINT;
			f: Fr.Frame; sig: SHORTINT; u, v: INTEGER; old: CLGAs.Label; name: ARRAY CLGAs.LabelLen OF CHAR;
	BEGIN
		Texts.OpenScanner(s, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(s); f := Fr.Selected();
		IF (f # NIL) & (f.selTyp = Fr.cellSel) & (s.class = Texts.Name) THEN
			u := f.selU; v := f.selV;
			IF s.s = "LBusN" THEN sig := CLGAs.LBusN
			ELSIF s.s = "LBusS" THEN sig := CLGAs.LBusS
			ELSIF s.s = "LBusW" THEN sig := CLGAs.LBusW
			ELSIF s.s = "LBusE" THEN sig := CLGAs.LBusE
			ELSIF s.s = "EBusN" THEN sig := CLGAs.EBusN
			ELSIF s.s = "EBusS" THEN sig := CLGAs.EBusS
			ELSIF s.s = "EBusW" THEN sig := CLGAs.EBusW
			ELSIF s.s = "EBusE" THEN sig := CLGAs.EBusE
			END;
			CLFrames.Backup(f);
			CLGAs.Delete(f.a, u, v, sig, name);
			Oberon.GetSelection(Sel, beg, end, time);
			IF time >= 0 THEN
				Texts.OpenScanner(s, Sel, beg); Texts.Scan(s);
				IF s.class = Texts.Name THEN CLGAs.Insert(f.a, s.s, u, v, sig, old) END
			END;
			CLFrames.Update(f)
		END
	END LabelBus;

	PROCEDURE Inspect*;	
		VAR f: Fr.Frame; cell: CLGAs.Cell;
		PROCEDURE Dir(dir: SHORTINT);
		BEGIN
			CASE dir OF
			| CLGAs.None: Str(" none")
			| CLGAs.North: Str(" n")
			| CLGAs.South: Str(" s")
			| CLGAs.West: Str(" w")
			| CLGAs.East: Str(" e")
			END
		END Dir;
		PROCEDURE Label(caption: ARRAY OF CHAR; sig: SHORTINT);
			VAR L: CLGAs.Label;
		BEGIN L := CLGAs.LabelAt(f.a, f.selU, f.selV, sig); IF L # NIL THEN Str(caption); Str(L.name) END
		END Label;
	BEGIN
		f := Fr.Selected();
		IF f # NIL THEN
			CASE f.selTyp OF
			| Fr.cellSel:
				Str("cell (routing, state, a, b, nsL, weL):"); cell := f.a.c[f.selU, f.selV];
				CASE cell.routing OF
				| CLGAs.None: Str(" none")
				| CLGAs.Write: Str(" Write")
				| CLGAs.TS: Str(" TS")
				| CLGAs.Read: Str(" Read")
				| CLGAs.Mux: Str(" Mux")
				| CLGAs.TurnB: Str(" TurnB")
				| CLGAs.Turn0: Str(" Turn0")
				END;
				CASE cell.state OF
				| CLGAs.None: Str(" none")
				| CLGAs.State0: Str(" State0")
				| CLGAs.State1: Str(" State1")
				| CLGAs.State2: Str(" State2")
				| CLGAs.State3: Str(" State3")
				END;
				Dir(cell.a); Dir(cell.b); Dir(cell.nsL); Dir(cell.weL); Ln;
				Label(" A: ", CLGAs.AOut); Label(" B: ", CLGAs.BOut);
				Label(" LNorth: ", CLGAs.LBusN); Label(" LSouth: ", CLGAs.LBusS);
				Label(" LWest: ", CLGAs.LBusW); Label(" LEast: ", CLGAs.LBusE);
				Label(" ENorth: ", CLGAs.EBusN); Label(" ESouth: ", CLGAs.EBusS);
				Label(" EWest: ", CLGAs.EBusW); Label(" EEast: ", CLGAs.EBusE)
			| Fr.nRepSel: Str("n rep:"); Int(f.a.hr[f.selU, f.selV].n)
			| Fr.sRepSel:
				Str("s rep:"); Int(f.a.hr[f.selU, f.selV].s);
				IF ODD(f.a.hr[f.selU, f.selV].s DIV CLGAs.PassGate) THEN Str(" pass on") END
			| Fr.wRepSel: Str("w rep:"); Int(f.a.vr[f.selU, f.selV].w)
			| Fr.eRepSel:
				Str("e rep:"); Int(f.a.vr[f.selU, f.selV].e);
				IF ODD(f.a.vr[f.selU, f.selV].e DIV CLGAs.PassGate) THEN Str(" pass on") END
			| Fr.nPadSel: Str("n pad:"); Int(f.a.p[CLGAs.North, f.selU].selector)
			| Fr.sPadSel: Str("s pad:"); Int(f.a.p[CLGAs.South, f.selU].selector)
			| Fr.wPadSel: Str("w pad:"); Int(f.a.p[CLGAs.West, f.selV].selector)
			| Fr.ePadSel: Str("e pad:"); Int(f.a.p[CLGAs.East, f.selV].selector)
			END;
			Ln
		END
	END Inspect;

	PROCEDURE Labels*;	
		VAR f: Fr.Frame; L: CLGAs.Label; i: INTEGER;
	BEGIN
		CLFrames.GetParFrame(f);
		IF f # NIL THEN
			L := f.a.first; i := 0;
			WHILE L # NIL DO
				Str(L.name); Int(L.u); Int(L.v);
				IF i MOD 4 = 3 THEN Ln ELSE Str("            ") END;
				INC(i); L := L.next
			END
		END;
		Ln
	END Labels;

	PROCEDURE Clocks*;	
		VAR f: Fr.Frame;
	BEGIN
		CLFrames.GetParFrame(f);
		IF f # NIL THEN Str("clocks come from:"); Ln; ClockResetInfo(f.a.clk) END
	END Clocks;

	PROCEDURE Resets*;	
		VAR f: Fr.Frame;
	BEGIN
		CLFrames.GetParFrame(f);
		IF f # NIL THEN Str("resets come from:"); Ln; ClockResetInfo(f.a.res) END
	END Resets;

	PROCEDURE Statistics*;	
		VAR
			f: Fr.Frame; a: CLGAs.GA; cache: Fr.BusCache;
			i, j, minU, minV, maxU, maxV: INTEGER;
			routing, logic, register, cells,
			local, localN, localS, localW, localE,
			exp, expN, expS, expW, expE: LONGINT;
	BEGIN
		CLFrames.GetParFrame(f);
		IF f # NIL THEN
			a := f.a;
			routing := 0; logic := 0; register := 0; cells := 0;
			localN := 0; localS := 0; localW := 0; localE := 0;
			expN := 0; expS := 0; expW := 0; expE := 0;
			minU := CLGAs.Dim; minV := CLGAs.Dim; maxU := -1; maxV := -1;
			FOR i := 0 TO CLGAs.Dim-1 DO
				FOR j := 0 TO CLGAs.Dim-1 DO
					IF a.c[i, j].state+a.c[i, j].routing+a.c[i, j].a+a.c[i, j].b+a.c[i, j].weL+a.c[i, j].nsL # 6*CLGAs.None THEN
						IF i < minU THEN minU := i END;
						IF i > maxU THEN maxU := i END;
						IF j < minV THEN minV := j END;
						IF j > maxV THEN maxV := j END
					END;
					CASE a.c[i, j].state OF
					| CLGAs.None:
						IF a.c[i, j].routing # CLGAs.None THEN INC(cells)
						ELSIF a.c[i, j].weL+a.c[i, j].nsL # 2*CLGAs.None THEN INC(routing)
						END
					| CLGAs.State0, CLGAs.State1: INC(routing)
					| CLGAs.State2: INC(logic)
					| CLGAs.State3: INC(register)
					END
				END
			END;
			cache := f.cache;
			FOR j := 0 TO CLGAs.Dim DIV CLGAs.Sector -1 DO
				FOR i := 0 TO CLGAs.Dim-1 DO
					IF cache.localNS[j, i, 0] THEN INC(localN) END;
					IF cache.localNS[j, i, 1] THEN INC(localS) END;
					IF cache.localWE[i, j, 0] THEN INC(localW) END;
					IF cache.localWE[i, j, 1] THEN INC(localE) END;
					IF cache.expNS[j, i, 0] THEN INC(expN) END;
					IF cache.expNS[j, i, 1] THEN INC(expS) END;
					IF cache.expWE[i, j, 0] THEN INC(expW) END;
					IF cache.expWE[i, j, 1] THEN INC(expE) END
				END
			END;
			cells := cells+routing+logic+register;
			Str("used cells:"); Int(cells); Int(ENTIER(100*cells/(CLGAs.Dim*CLGAs.Dim)+0.5)); Char("%");
			Str(" (routing"); Int(routing); Str(" logic"); Int(logic); Str(" registers"); Int(register); Char(")"); Ln;
			local := localN+localS+localW+localE; exp := expN+expS+expW+expE;
			Str("used busses:"); Int(ENTIER(100*(local+exp)/(CLGAs.Dim*CLGAs.Dim)+0.5)); Char("%");
			Str(" (local"); Int(local); Str(" express"); Int(exp); Char(")"); Ln;
			IF cells # 0 THEN
				Str("bounding box:"); Int(maxU-minU+1); Str(" x"); Int(maxV-minV+1); Ln
			END 
		END
	END Statistics;

	PROCEDURE PutInt*(port, val: INTEGER);	(** Write val (0..255) to CLi_port port (0..3) **)		
	BEGIN CLLoader.Put(CHR(val), SHORT(port))
	END PutInt;

	PROCEDURE GetInt*(port: INTEGER): INTEGER;	(** Read value from CLi_port port (0..3) **)	
		VAR ch: CHAR;
	BEGIN CLLoader.Get (ch, SHORT(port)); RETURN ORD(ch)
	END GetInt;

	PROCEDURE WriteVal(val: INTEGER);	
		VAR i, s0, s1: INTEGER;
	BEGIN
		Int(val); Str("  ");
		s1 := val DIV 10H MOD 10H; s0 := val MOD 10H;
		IF s1 >= 10 THEN INC(s1, ORD("A")-ORD("9")-1) END;
		IF s0 >= 10 THEN INC(s0, ORD("A")-ORD("9")-1) END;
		Char(CHR(s1+ORD("0"))); Char(CHR(s0+ORD("0")));
		Str("  ");
		i := 128;
		REPEAT
			IF val >= i THEN Char("1"); DEC(val, i) ELSE Char("0") END;
			i := i DIV 2
		UNTIL i = 0
	END WriteVal;

	PROCEDURE Put*;	(** ([portNr] value) | "^" 	Write value (0..255) to CLi_port portNr (0 default..3) **)
		VAR s: Texts.Scanner; val: LONGINT; port: SHORTINT;
	BEGIN
		port := 0;
		Setup(s); IF s.class = Texts.Int THEN val := s.i MOD 256; Texts.Scan(s) END;
		IF s.class = Texts.Int THEN port := SHORT(SHORT(val MOD 4)); val := s.i MOD 256 END;
		CLLoader.Put(CHR(val), port);
		Str("port"); Int(port); Str(" :="); WriteVal(SHORT(val)); Ln
	END Put;

	PROCEDURE Get*;	(** [portNr] | "^" 	Read value from CLi_port portNr (0 default..3) **)
		VAR s: Texts.Scanner; port: SHORTINT; ch: CHAR; val: INTEGER;
	BEGIN
		Setup(s); IF s.class = Texts.Int THEN port := SHORT(SHORT(s.i MOD 4)) ELSE port := 0 END;
		CLLoader.Get(ch, port);
		val := ORD(ch);
		Str("port"); Int(port); Str("  ="); WriteVal(val); Ln
	END Get;

	PROCEDURE Reset*;	(** Give Reset Signal for CLi-Board **)	BEGIN CLLoader.Reset END Reset;

	PROCEDURE LabelA*;	BEGIN SetLabels(CLGAs.AOut) END LabelA;
		(** "label" dx dy [start]	start with lower left selected cell and label AOut in cell selection with labelx (x = 0|start..9)
			incrementing by dx dy **)

	PROCEDURE LabelB*;	BEGIN SetLabels(CLGAs.BOut) END LabelB;
		(** "label" dx dy [start]	start with lower left selected cell and label BOut in cell selection with labelx (x = 0|start..9)
			incrementing by dx dy **)

	PROCEDURE DeleteA*;	BEGIN DeleteLabels(CLGAs.AOut) END DeleteA;
		(** dx dy	start with lower left selected cell and delete label at AOut in cell selection incrementing by dx dy **)

	PROCEDURE DeleteB*;	BEGIN DeleteLabels(CLGAs.BOut) END DeleteB;
		(** dx dy	start with lower left selected cell and delete label at BOut in cell selection incrementing by dx dy **)

BEGIN Texts.OpenWriter(W); first := TRUE
END CL.
