h43559
s 00001/00001/00093
d D 1.5 83/02/19 18:39:34 mrk 5 4
c wrong interface to sincos
e
s 00002/00004/00092
d D 1.4 83/02/17 20:12:47 mrk 4 3
c added sincos routine support
e
s 00011/00011/00085
d D 1.3 83/02/08 17:33:18 mrk 3 2
c changed veritical text justification global; txtjv
e
s 00000/00000/00096
d D 1.2 83/01/28 13:59:44 tes 2 1
c initial_internal_update
e
s 00096/00000/00000
d D 1.1 83/01/28 13:04:20 tes 1 0
c date and time created 83/01/28 13:04:20 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gptxat (index)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set the text attributes associated with specified index#
#                                                                      #
#     Input Parameters:                                                #
#            none                                                      #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - device driver control                            #
#            gpsatt - Set an attribute on the current device           #
I 4
#            sincos - return sin and cosine of an angle                #
E 4
#                                                                      #
########################################################################
integer index

integer contrl(5), opcd, intin(3), ptsin(2), intout(1), ptsout(4), intin1, 
	intin2, intin3, acthgt, actwdt, k, iout
D 4
real radagl
E 4
 
include(`pltcom')
 
equivalence (contrl(OPCODE), opcd), (intin(1), intin1),
	    (intin(2), intin2), (intin(3), intin3),
	    (ptsout(2), acthgt), (ptsout(3), actwdt)

DxB write (DEBUGxUNIT, 100) index
DxB 100 format (' gptxzt:', i5)
 
   call gpsatt (SETxTEXTxFONT, nfont(index), iout)

   # contrl(1) = SETxCHARACTERxHEIGHT
   opcd = SETxCHARACTERxHEIGHT
   contrl(VERTICESxIN) = 1
   ptsin(1) = 0
   ptsin(2) = (ztxsiz(index)/100.) * yvwlng + 0.5

   call gzddop (contrl, intin, ptsin, intout, ptsout)

   zchwdt = float(actwdt)/xvwlng
   zchhgt = float(acthgt)/yvwlng
   zchsiz = zchhgt * 100.0

   call gpsatt (SETxTEXTxCOLORxINDEX, ntxclr(index), iout)

   #  If the text rotation is non-zero then set character precision otherwise
   #  use string precision. Character precision is used so that the rotated
   #  text will appear in the correct location for devices which do not rotate
   #  text.
 
   if (ztxrot(index) == 0.0) txtpre = 1
   else                      txtpre = 2

   # contrl(1) = SETxCHARACTERxUPxVECTOR
   opcd = SETxCHARACTERxUPxVECTOR
   contrl(VERTICESxIN) = 0
   # intin(1) = ztxrot(index) * 10.0 + 0.5
   intin1 = ztxrot(index) * 10.0 + 0.5

D 4
   radagl = ztxrot(index)*.0174533
   zdx = cos(radagl)           # Set dx/dy globals
   zdy = sin(radagl)
E 4
I 4
D 5
   call sincos (ztxrot(index), zdx, zdy)
E 5
I 5
   call sincos (ztxrot(index), zdy, zdx)
E 5
E 4

   # intin(2) = cos(radagl)
   intin2 = zdx * 100.0 
   # intin(3) = sin(radagl)
   intin3 = zdy * 100.0 
 
   call gzddop (contrl, intin, ptsin, intout, ptsout)

   k = njust(index)
D 3
   if (k > 6) {          # Map the character justification of 1-9 (lower left to
      txtjv = 0          #   upper right as follows:
      txtjh = k - 7      #      1 - 0,4
      }                  #      2 - 1,4        7   8   9
   else if (k > 3) {     #      3 - 2,4        4   5   6
      txtjv = 2          #      4 - 0,2        1   2   3
      txtjh = k - 4      #      5 - 1,2
      }                  #      6 - 2,2
   else {                #      7 - 0,0
      txtjv = 4          #      8 - 1,0
      txtjh = k - 1      #      9 - 2,0
E 3
I 3
   if (k > 6) {  # Map the character justification of 1-9 (lower left to
      txtjv = 2          #   upper right as follows:
      txtjh = k - 7      #      1 - 0,0
      }                  #      2 - 1,0        7   8   9
   else if (k > 3) {     #      3 - 2,0        4   5   6
      txtjv = 1          #      4 - 0,1        1   2   3
      txtjh = k - 4      #      5 - 1,1
      }                  #      6 - 2,1
   else {                #      7 - 0,2
      txtjv = 0          #      8 - 1,2
      txtjh = k - 1      #      9 - 2,2
E 3
      }
 
   return
end
E 1
